/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bimserver.utils.GrowingByteBuffer;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public class RecordSizeEstimater {
    private static final int AVERAGE_PRIMITIVE_LIST_SIZE = 2;
    private static final int AVERAGE_REFERENCE_LIST_SIZE = 2;
    private static final int AVERAGE_STRING_SIZE = 5;
    private static final int AVERAGE_BYTE_ARRAY_SIZE = 0;
    private final Map<EClass, Integer> bufferSizeEstimates = new HashMap<EClass, Integer>();

    public void init(Set<EPackage> ePackages) {
        for (EPackage ePackage : ePackages) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (!(eClassifier instanceof EClass)) continue;
                EClass eClass = (EClass)eClassifier;
                this.bufferSizeEstimates.put(eClass, this.estimateBufferSize(eClass));
            }
        }
    }

    private int estimateBufferSize(EClass eClass) {
        int size = 0;
        for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
            if (eStructuralFeature instanceof EAttribute) {
                EAttribute eAttribute = (EAttribute)eStructuralFeature;
                if (eAttribute.isMany()) {
                    size += 2 + 2 * this.getPrimitiveSize((EDataType)eAttribute.getEType());
                    continue;
                }
                size += this.getPrimitiveSize((EDataType)eAttribute.getEType());
                continue;
            }
            if (!(eStructuralFeature instanceof EReference)) continue;
            EReference eReference = (EReference)eStructuralFeature;
            if (eReference.isMany()) {
                size += 22;
                continue;
            }
            size += 10;
        }
        return size;
    }

    public int getPrimitiveSize(EDataType eDataType) {
        if (eDataType == EcorePackage.eINSTANCE.getEInt() || eDataType == EcorePackage.eINSTANCE.getEIntegerObject()) {
            return 4;
        }
        if (eDataType == EcorePackage.eINSTANCE.getEFloat() || eDataType == EcorePackage.eINSTANCE.getEFloatObject()) {
            return 4;
        }
        if (eDataType == EcorePackage.eINSTANCE.getEBoolean() || eDataType == EcorePackage.eINSTANCE.getEBooleanObject()) {
            return 1;
        }
        if (eDataType == EcorePackage.eINSTANCE.getEDate()) {
            return 8;
        }
        if (eDataType == EcorePackage.eINSTANCE.getELong() || eDataType == EcorePackage.eINSTANCE.getELongObject()) {
            return 8;
        }
        if (eDataType == EcorePackage.eINSTANCE.getEString()) {
            return 5;
        }
        if (eDataType == EcorePackage.eINSTANCE.getEDouble() || eDataType == EcorePackage.eINSTANCE.getEDoubleObject()) {
            return 8;
        }
        if (eDataType == EcorePackage.eINSTANCE.getEByteArray() || eDataType.getName().equals("DataHandler")) {
            return 0;
        }
        if (eDataType instanceof EEnum) {
            return 4;
        }
        throw new RuntimeException("Unimplemented: " + eDataType);
    }

    public int getEstimate(EClass eClass) {
        return this.bufferSizeEstimates.get(eClass);
    }

    public void adjustBasedOnDefault(GrowingByteBuffer buffer, EClass eClass, int size) {
        if (size > 2) {
            buffer.ensureExtraCapacity(10 * (size - 2));
        }
    }

    public void adjustBasedOnDefault(GrowingByteBuffer buffer, EDataType eType, int size) {
        if (size > 2) {
            buffer.ensureExtraCapacity(this.getPrimitiveSize(eType) * (size - 2));
        }
    }
}

