/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database;

import com.google.common.base.Charsets;
import java.util.Date;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.KeyValueStore;
import org.bimserver.utils.BinUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Registry {
    private static final Logger LOGGER = LoggerFactory.getLogger(Registry.class);
    public static final String REGISTRY_TABLE = "INT-Registry";
    private final KeyValueStore keyValueStore;

    public Registry(KeyValueStore keyValueStore) {
        this.keyValueStore = keyValueStore;
    }

    public void save(String key, long value, DatabaseSession databaseSession) throws BimserverLockConflictException {
        try {
            this.keyValueStore.store(REGISTRY_TABLE, key.getBytes(Charsets.UTF_8), BinUtils.longToByteArray((long)value), databaseSession);
        }
        catch (BimserverDatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public void save(String key, byte[] value, DatabaseSession databaseSession) throws BimserverLockConflictException {
        try {
            this.keyValueStore.store(REGISTRY_TABLE, key.getBytes(Charsets.UTF_8), value, databaseSession);
        }
        catch (BimserverDatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public void save(String key, boolean value, DatabaseSession databaseSession) throws BimserverLockConflictException {
        try {
            this.keyValueStore.store(REGISTRY_TABLE, key.getBytes(Charsets.UTF_8), BinUtils.booleanToByteArray((Boolean)value), databaseSession);
        }
        catch (BimserverDatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public void save(String key, int value, DatabaseSession databaseSession) throws BimserverLockConflictException {
        try {
            this.keyValueStore.store(REGISTRY_TABLE, key.getBytes(Charsets.UTF_8), BinUtils.intToByteArray((int)value), databaseSession);
        }
        catch (BimserverDatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public long readLong(String key, DatabaseSession databaseSession) throws BimserverLockConflictException, BimserverDatabaseException {
        byte[] bytes = this.keyValueStore.get(REGISTRY_TABLE, key.getBytes(Charsets.UTF_8), databaseSession);
        if (bytes == null) {
            return 1L;
        }
        return BinUtils.byteArrayToLong((byte[])bytes);
    }

    public int readInt(String key, DatabaseSession databaseSession) throws BimserverLockConflictException, BimserverDatabaseException {
        byte[] bytes = this.keyValueStore.get(REGISTRY_TABLE, key.getBytes(Charsets.UTF_8), databaseSession);
        if (bytes == null) {
            return 1;
        }
        return BinUtils.byteArrayToInt((byte[])bytes);
    }

    public int readInt(String key, DatabaseSession databaseSession, int defaultValue) throws BimserverLockConflictException, BimserverDatabaseException {
        byte[] bytes = this.keyValueStore.get(REGISTRY_TABLE, key.getBytes(Charsets.UTF_8), databaseSession);
        if (bytes == null) {
            return defaultValue;
        }
        return BinUtils.byteArrayToInt((byte[])bytes);
    }

    public Date readDate(String key, DatabaseSession databaseSession) throws BimserverLockConflictException, BimserverDatabaseException {
        long readLong = this.readLong(key, databaseSession);
        if (readLong == -1L) {
            return null;
        }
        return new Date(readLong);
    }

    public void save(String key, Date date, DatabaseSession databaseSession) throws BimserverLockConflictException {
        this.save(key, date.getTime(), databaseSession);
    }

    public boolean readBoolean(String key, boolean defaultValue, DatabaseSession databaseSession) throws BimserverLockConflictException, BimserverDatabaseException {
        byte[] bytes = this.keyValueStore.get(REGISTRY_TABLE, key.getBytes(Charsets.UTF_8), databaseSession);
        if (bytes == null) {
            return defaultValue;
        }
        return BinUtils.byteArrayToBoolean((byte[])bytes);
    }

    public boolean has(String key, DatabaseSession databaseSession) throws BimserverLockConflictException, BimserverDatabaseException {
        return this.keyValueStore.get(REGISTRY_TABLE, key.getBytes(Charsets.UTF_8), databaseSession) != null;
    }

    public byte[] readByteArray(String key, DatabaseSession databaseSession) throws BimserverLockConflictException, BimserverDatabaseException {
        return this.keyValueStore.get(REGISTRY_TABLE, key.getBytes(Charsets.UTF_8), databaseSession);
    }
}

