/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.GeometryGeneratingException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.PluginConfiguration;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.plugins.Plugin;
import org.bimserver.plugins.PluginManager;
import org.bimserver.webservices.authorization.Authorization;

public abstract class AbstractDownloadDatabaseAction<T>
extends BimDatabaseAction<T> {
    private Authorization authorization;
    private BimServer bimServer;

    public AbstractDownloadDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Authorization authorization) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.authorization = authorization;
    }

    protected void checkGeometry(PluginConfiguration serializerPluginConfiguration, PluginManager pluginManager, IfcModelInterface model, Project project, ConcreteRevision concreteRevision, Revision revision) throws BimserverDatabaseException, GeometryGeneratingException {
        Plugin plugin = pluginManager.getPlugin(serializerPluginConfiguration.getPluginDescriptor().getPluginClassName(), true);
    }

    public BimServer getBimServer() {
        return this.bimServer;
    }

    public static int findHighestStopRid(Project project, ConcreteRevision subRevision) {
        int highestStopId = Integer.MIN_VALUE;
        for (ConcreteRevision concreteRevision : project.getConcreteRevisions()) {
            if (concreteRevision.getId() > subRevision.getId() || !concreteRevision.isClear() || concreteRevision.getId() <= highestStopId) continue;
            highestStopId = concreteRevision.getId();
        }
        return highestStopId;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }
}

