/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Date;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.PostCommitAction;
import org.bimserver.database.actions.AddDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.interfaces.SConverter;
import org.bimserver.interfaces.objects.SLogAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.ExtendedDataAddedToProject;
import org.bimserver.models.store.ExtendedData;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class AddExtendedDataToProjectDatabaseAction
extends AddDatabaseAction<ExtendedData> {
    private final Long poid;
    private BimServer bimServer;
    private Authorization authorization;

    public AddExtendedDataToProjectDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Long poid, ExtendedData extendedData, Authorization authorization) {
        super(databaseSession, accessMethod, extendedData);
        this.bimServer = bimServer;
        this.poid = poid;
        this.authorization = authorization;
    }

    @Override
    public Long execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        super.execute();
        User actingUser = this.getUserByUoid(this.authorization.getUoid());
        Project project = this.getProjectByPoid(this.poid);
        if (project == null) {
            throw new UserException("Project with poid " + this.poid + " not found");
        }
        project.getExtendedData().add(this.getIdEObject());
        this.getDatabaseSession().store((IdEObject)project);
        final ExtendedDataAddedToProject extendedDataAddedToProject = this.getDatabaseSession().create(ExtendedDataAddedToProject.class);
        extendedDataAddedToProject.setAccessMethod(this.getAccessMethod());
        extendedDataAddedToProject.setDate(new Date());
        extendedDataAddedToProject.setExecutor(actingUser);
        extendedDataAddedToProject.setExtendedData((ExtendedData)this.getIdEObject());
        extendedDataAddedToProject.setProject(project);
        this.getDatabaseSession().addPostCommitAction(new PostCommitAction(){

            @Override
            public void execute() throws UserException {
                AddExtendedDataToProjectDatabaseAction.this.bimServer.getNotificationsManager().notify((SLogAction)new SConverter().convertToSObject(extendedDataAddedToProject));
            }
        });
        return null;
    }
}

