/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Date;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.PostCommitAction;
import org.bimserver.database.actions.AddDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.interfaces.SConverter;
import org.bimserver.interfaces.objects.SLogAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.ExtendedDataAddedToRevision;
import org.bimserver.models.store.ExtendedData;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.User;
import org.bimserver.notifications.NewExtendedDataOnRevisionNotification;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class AddExtendedDataToRevisionDatabaseAction
extends AddDatabaseAction<ExtendedData> {
    private final Long roid;
    private Authorization authorization;
    private BimServer bimServer;

    public AddExtendedDataToRevisionDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Long roid, Authorization authorization, ExtendedData extendedData) {
        super(databaseSession, accessMethod, extendedData);
        this.bimServer = bimServer;
        this.roid = roid;
        this.authorization = authorization;
    }

    @Override
    public Long execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        this.authorization.canWriteExtendedData(this.roid);
        User actingUser = this.getUserByUoid(this.authorization.getUoid());
        ((ExtendedData)this.getIdEObject()).setUser(actingUser);
        ((ExtendedData)this.getIdEObject()).setAdded(new Date());
        ((ExtendedData)this.getIdEObject()).setSize((long)((ExtendedData)this.getIdEObject()).getFile().getData().length);
        super.execute();
        Revision revision = this.getRevisionByRoid(this.roid);
        if (revision == null) {
            throw new UserException("Revision with roid " + this.roid + " not found");
        }
        revision.getExtendedData().add(this.getIdEObject());
        this.getDatabaseSession().store((IdEObject)revision);
        ((ExtendedData)this.getIdEObject()).setProject(revision.getProject());
        ((ExtendedData)this.getIdEObject()).setRevision(revision);
        if (((ExtendedData)this.getIdEObject()).getSchema() != null) {
            this.getDatabaseSession().store((IdEObject)((ExtendedData)this.getIdEObject()).getSchema());
        }
        final ExtendedDataAddedToRevision extendedDataAddedToRevision = this.getDatabaseSession().create(ExtendedDataAddedToRevision.class);
        extendedDataAddedToRevision.setAccessMethod(this.getAccessMethod());
        extendedDataAddedToRevision.setDate(new Date());
        extendedDataAddedToRevision.setExecutor(actingUser);
        extendedDataAddedToRevision.setExtendedData((ExtendedData)this.getIdEObject());
        extendedDataAddedToRevision.setRevision(revision);
        final long poid = revision.getProject().getOid();
        final long roid = revision.getOid();
        this.getDatabaseSession().addPostCommitAction(new PostCommitAction(){

            @Override
            public void execute() throws UserException {
                AddExtendedDataToRevisionDatabaseAction.this.bimServer.getNotificationsManager().notify(new NewExtendedDataOnRevisionNotification(AddExtendedDataToRevisionDatabaseAction.this.bimServer, ((ExtendedData)AddExtendedDataToRevisionDatabaseAction.this.getIdEObject()).getOid(), poid, roid, -1L));
                AddExtendedDataToRevisionDatabaseAction.this.bimServer.getNotificationsManager().notify((SLogAction)new SConverter().convertToSObject(extendedDataAddedToRevision));
            }
        });
        return null;
    }
}

