/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import org.bimserver.Authenticator;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.PostCommitAction;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.mail.EmailMessage;
import org.bimserver.mail.MailSystem;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.NewUserAdded;
import org.bimserver.models.store.ServerSettings;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.notifications.NewUserNotification;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.templating.TemplateIdentifier;
import org.bimserver.utils.GeneratorUtils;
import org.bimserver.utils.Hashers;
import org.bimserver.webservices.authorization.Authorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddUserDatabaseAction
extends BimDatabaseAction<User> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddUserDatabaseAction.class);
    private final String name;
    private final UserType userType;
    private final String username;
    private final boolean selfRegistration;
    private final String password;
    private boolean createSystemUser = false;
    private final BimServer bimServer;
    private String resetUrl;
    private static final SecureRandom secureRandom = new SecureRandom();

    public AddUserDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, String username, String name, UserType userType, Authorization authorization, boolean selfRegistration, String resetUrl) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.name = name;
        this.username = username;
        this.userType = userType;
        this.selfRegistration = selfRegistration;
        this.resetUrl = resetUrl;
        this.password = null;
    }

    public AddUserDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, String username, String password, String name, UserType userType, Authorization authorization, boolean selfRegistration, String resetUrl) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.password = password;
        this.name = name;
        this.username = username;
        this.userType = userType;
        this.selfRegistration = selfRegistration;
        this.resetUrl = resetUrl;
    }

    @Override
    public User execute() throws UserException, BimserverDatabaseException, BimserverLockConflictException {
        ServerSettings serverSettings;
        String trimmedUserName = this.username.trim().toLowerCase();
        String trimmedName = this.name.trim();
        if (this.userType == UserType.SYSTEM && !this.createSystemUser) {
            throw new UserException("Cannot create system users");
        }
        if (this.selfRegistration && this.userType == UserType.ADMIN) {
            throw new UserException("Cannot create admin user with self registration");
        }
        if (trimmedUserName.equals("")) {
            throw new UserException("Invalid username");
        }
        if (!(MailSystem.isValidEmailAddress(trimmedUserName) || trimmedUserName.equals("test") || trimmedUserName.equals("system"))) {
            throw new UserException("Username must be a valid e-mail address");
        }
        if (trimmedName.equals("")) {
            throw new UserException("Invalid name");
        }
        if (this.getUserByUserName(trimmedUserName) != null) {
            throw new UserException("A user with the username " + trimmedUserName + " already exists");
        }
        User actingUser = null;
        final User user = this.getDatabaseSession().create(User.class);
        if (this.password != null) {
            byte[] salt = new byte[32];
            secureRandom.nextBytes(salt);
            user.setPasswordHash(new Authenticator().createHash(this.password, salt));
            user.setPasswordSalt(salt);
        }
        user.setToken(GeneratorUtils.generateToken());
        user.setName(trimmedName);
        user.setUsername(trimmedUserName);
        user.setCreatedOn(new Date());
        user.setCreatedBy(actingUser);
        user.setUserType(this.userType);
        user.setLastSeen(null);
        final String token = GeneratorUtils.generateToken();
        user.setValidationToken(Hashers.getSha256Hash((String)token));
        user.setValidationTokenCreated(new Date());
        if (!this.createSystemUser) {
            NewUserAdded newUserAdded = this.getDatabaseSession().create(NewUserAdded.class);
            newUserAdded.setUser(user);
            newUserAdded.setExecutor(actingUser);
            newUserAdded.setDate(new Date());
            newUserAdded.setAccessMethod(this.getAccessMethod());
            this.getDatabaseSession().store((IdEObject)newUserAdded);
            this.getDatabaseSession().addPostCommitAction(new PostCommitAction(){

                @Override
                public void execute() throws UserException {
                    AddUserDatabaseAction.this.bimServer.getNotificationsManager().notify(new NewUserNotification(AddUserDatabaseAction.this.bimServer, user.getOid()));
                }
            });
            this.bimServer.updateUserSettings(this.getDatabaseSession(), user);
        }
        this.getDatabaseSession().store((IdEObject)user);
        if (this.bimServer != null && this.bimServer.getServerSettingsCache() != null && (serverSettings = this.bimServer.getServerSettingsCache().getServerSettings()).isSendConfirmationEmailAfterRegistration()) {
            this.getDatabaseSession().addPostCommitAction(new PostCommitAction(){

                @Override
                public void execute() throws UserException {
                    String body = null;
                    try {
                        if (MailSystem.isValidEmailAddress(user.getUsername())) {
                            EmailMessage message = AddUserDatabaseAction.this.bimServer.getMailSystem().createMessage();
                            String emailSenderAddress = serverSettings.getEmailSenderAddress();
                            InternetAddress addressFrom = new InternetAddress(emailSenderAddress);
                            message.setFrom(addressFrom);
                            InternetAddress[] addressTo = new InternetAddress[]{new InternetAddress(user.getUsername())};
                            message.setRecipients(Message.RecipientType.TO, addressTo);
                            HashMap<String, Object> context = new HashMap<String, Object>();
                            context.put("name", user.getName());
                            context.put("username", user.getUsername());
                            context.put("siteaddress", serverSettings.getSiteAddress());
                            context.put("validationlink", AddUserDatabaseAction.this.resetUrl + "&username=" + user.getUsername() + "&uoid=" + user.getOid() + "&validationtoken=" + token + "&address=" + AddUserDatabaseAction.this.bimServer.getServerSettingsCache().getServerSettings().getSiteAddress());
                            String subject = null;
                            if (AddUserDatabaseAction.this.selfRegistration) {
                                body = AddUserDatabaseAction.this.bimServer.getTemplateEngine().process(context, TemplateIdentifier.SELF_REGISTRATION_EMAIL_BODY);
                                subject = AddUserDatabaseAction.this.bimServer.getTemplateEngine().process(context, TemplateIdentifier.SELF_REGISTRATION_EMAIL_SUBJECT);
                            } else {
                                body = AddUserDatabaseAction.this.bimServer.getTemplateEngine().process(context, TemplateIdentifier.ADMIN_REGISTRATION_EMAIL_BODY);
                                subject = AddUserDatabaseAction.this.bimServer.getTemplateEngine().process(context, TemplateIdentifier.ADMIN_REGISTRATION_EMAIL_SUBJECT);
                            }
                            message.setContent(body, "text/html");
                            message.setSubject(subject.trim());
                            LOGGER.info("Sending registration e-mail to " + user.getUsername());
                            message.send();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error(body);
                        LOGGER.error("", (Throwable)e);
                    }
                }
            });
        }
        return user;
    }

    public void setCreateSystemUser() {
        this.createSystemUser = true;
    }
}

