/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.security.SecureRandom;
import java.util.Date;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.actions.LoginDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ObjectState;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.ServiceMap;
import org.bimserver.webservices.authorization.AuthenticationException;
import org.bimserver.webservices.authorization.Authorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutologinDatabaseAction
extends BimDatabaseAction<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutologinDatabaseAction.class);
    private final String token;
    private BimServer bimServer;
    private ServiceMap serviceMap;

    public AutologinDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, ServiceMap serviceMap, AccessMethod accessMethod, String token) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.serviceMap = serviceMap;
        this.token = token;
    }

    @Override
    public String execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        try {
            Authorization authorization = Authorization.fromToken(this.bimServer.getEncryptionKey(), this.token);
            User user = (User)this.getDatabaseSession().get(authorization.getUoid(), OldQuery.getDefault());
            if (user.getState() == ObjectState.DELETED) {
                throw new UserException("User account has been deleted");
            }
            if (user.getUserType() == UserType.SYSTEM) {
                throw new UserException("System user cannot login");
            }
            user.setLastSeen(new Date());
            authorization.setUoid(user.getOid());
            String asHexToken = authorization.asHexToken(this.bimServer.getEncryptionKey());
            this.serviceMap.setAuthorization(authorization);
            this.getDatabaseSession().store((IdEObject)user);
            return asHexToken;
        }
        catch (AuthenticationException e) {
            LOGGER.error("", (Throwable)e);
            try {
                Thread.sleep(LoginDatabaseAction.DEFAULT_LOGIN_ERROR_TIMEOUT + new SecureRandom().nextInt(1000));
            }
            catch (InterruptedException e2) {
                LOGGER.error("", (Throwable)e2);
            }
            throw new UserException("User not found or inccorrect autologin token");
        }
    }
}

