/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AbstractBranchDatabaseAction;
import org.bimserver.database.actions.AddProjectDatabaseAction;
import org.bimserver.database.actions.CheckinDatabaseAction;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.ifc.BasicIfcModel;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.plugins.IfcModelSet;
import org.bimserver.plugins.ModelHelper;
import org.bimserver.plugins.modelmerger.MergeException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class BranchToNewProjectDatabaseAction
extends AbstractBranchDatabaseAction {
    private final BimServer bimServer;
    private final Long roid;
    private final String projectName;
    private final String comment;
    private Authorization authorization;

    public BranchToNewProjectDatabaseAction(DatabaseSession session, AccessMethod accessMethod, BimServer bimServer, Authorization authorization, Long roid, String projectName, String comment) {
        super(session, accessMethod);
        this.bimServer = bimServer;
        this.authorization = authorization;
        this.roid = roid;
        this.projectName = projectName;
        this.comment = comment;
    }

    @Override
    public Long getPoid() {
        return -1L;
    }

    @Override
    public Long getRoid() {
        return this.roid;
    }

    @Override
    public ConcreteRevision execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        Revision oldRevision = (Revision)this.getDatabaseSession().get(StorePackage.eINSTANCE.getRevision(), (long)this.roid, (QueryInterface)OldQuery.getDefault());
        Project oldProject = oldRevision.getProject();
        User user = (User)this.getDatabaseSession().get(StorePackage.eINSTANCE.getUser(), this.authorization.getUoid(), (QueryInterface)OldQuery.getDefault());
        if (!this.authorization.hasRightsOnProjectOrSuperProjectsOrSubProjects(user, oldProject)) {
            throw new UserException("User has insufficient rights to download revisions from this project");
        }
        IfcModelSet ifcModelSet = new IfcModelSet(new IfcModelInterface[0]);
        PackageMetaData lastMetaData = null;
        for (ConcreteRevision subRevision : oldRevision.getConcreteRevisions()) {
            PackageMetaData packageMetaData = this.bimServer.getMetaDataManager().getPackageMetaData(subRevision.getProject().getSchema());
            if (lastMetaData != null && lastMetaData != packageMetaData) {
                throw new UserException("Branching not possible for revision with multiple schemas");
            }
            BasicIfcModel subModel = new BasicIfcModel(packageMetaData, null);
            this.getDatabaseSession().getMap((IfcModelInterface)subModel, new OldQuery(packageMetaData, subRevision.getProject().getId(), subRevision.getId(), -1L, OldQuery.Deep.NO));
            subModel.getModelMetaData().setDate(subRevision.getDate());
            ifcModelSet.add((Object)subModel);
        }
        BasicIfcModel model = new BasicIfcModel(lastMetaData, null);
        try {
            model = this.bimServer.getMergerFactory().createMerger(this.getDatabaseSession(), this.authorization.getUoid()).merge(oldRevision.getProject(), ifcModelSet, new ModelHelper(this.bimServer.getMetaDataManager(), (IfcModelInterface)model));
        }
        catch (MergeException e) {
            throw new UserException((Throwable)e);
        }
        model.resetOids();
        Project newProject = new AddProjectDatabaseAction(this.bimServer, this.getDatabaseSession(), this.getAccessMethod(), this.projectName, "ifc2x3tc1", this.authorization).execute();
        CheckinDatabaseAction createCheckinAction = new CheckinDatabaseAction(this.bimServer, this.getDatabaseSession(), this.getAccessMethod(), newProject.getOid(), this.authorization, (IfcModelInterface)model, this.comment, this.comment, false);
        return createCheckinAction.execute();
    }
}

