/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Date;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.PostCommitAction;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.interfaces.SConverter;
import org.bimserver.interfaces.objects.SLogAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.ProjectDeleted;
import org.bimserver.models.store.ObjectState;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class DeleteProjectDatabaseAction
extends BimDatabaseAction<Boolean> {
    private final long poid;
    private Authorization authorization;
    private BimServer bimServer;

    public DeleteProjectDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, long poid, Authorization authorization) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.poid = poid;
        this.authorization = authorization;
    }

    @Override
    public Boolean execute() throws UserException, BimserverDatabaseException, BimserverLockConflictException {
        User actingUser = this.getUserByUoid(this.authorization.getUoid());
        Project project = this.getProjectByPoid(this.poid);
        if (actingUser.getUserType() == UserType.ADMIN || actingUser.getHasRightsOn().contains((Object)project) && this.bimServer.getServerSettingsCache().getServerSettings().isAllowUsersToCreateTopLevelProjects()) {
            this.delete(project);
            final ProjectDeleted projectDeleted = this.getDatabaseSession().create(ProjectDeleted.class);
            projectDeleted.setAccessMethod(this.getAccessMethod());
            projectDeleted.setDate(new Date());
            projectDeleted.setExecutor(actingUser);
            projectDeleted.setProject(project);
            this.getDatabaseSession().addPostCommitAction(new PostCommitAction(){

                @Override
                public void execute() throws UserException {
                    DeleteProjectDatabaseAction.this.bimServer.getNotificationsManager().notify((SLogAction)new SConverter().convertToSObject(projectDeleted));
                }
            });
            this.getDatabaseSession().store((IdEObject)project);
            return true;
        }
        throw new UserException("No rights to delete this project");
    }

    private void delete(Project project) {
        project.setState(ObjectState.DELETED);
        for (Project subProject : project.getSubProjects()) {
            this.delete(subProject);
        }
    }
}

