/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.GeometryGeneratingException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.ObjectIdentifier;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AbstractDownloadDatabaseAction;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.ifc.BasicIfcModel;
import org.bimserver.ifc.IfcModelChangeListener;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.PluginConfiguration;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.plugins.IfcModelSet;
import org.bimserver.plugins.ModelHelper;
import org.bimserver.plugins.modelmerger.MergeException;
import org.bimserver.plugins.objectidms.ObjectIDM;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class DownloadByGuidsDatabaseAction
extends AbstractDownloadDatabaseAction<IfcModelInterface> {
    private final Set<String> guids;
    private final Set<Long> roids;
    private int progress;
    private final ObjectIDM objectIDM;
    private long serializerOid;
    private OldQuery.Deep deep;

    public DownloadByGuidsDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Set<Long> roids, Set<String> guids, long serializerOid, Authorization authorization, ObjectIDM objectIDM, OldQuery.Deep deep) {
        super(bimServer, databaseSession, accessMethod, authorization);
        this.roids = roids;
        this.guids = guids;
        this.serializerOid = serializerOid;
        this.objectIDM = objectIDM;
        this.deep = deep;
    }

    @Override
    public IfcModelInterface execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        User user = this.getUserByUoid(this.getAuthorization().getUoid());
        HashSet<String> foundGuids = new HashSet<String>();
        IfcModelSet ifcModelSet = new IfcModelSet(new IfcModelInterface[0]);
        Project project = null;
        long incrSize = 0L;
        PackageMetaData lastPackageMetaData = null;
        PluginConfiguration serializerPluginConfiguration = (PluginConfiguration)this.getDatabaseSession().get(StorePackage.eINSTANCE.getPluginConfiguration(), this.serializerOid, (QueryInterface)OldQuery.getDefault());
        HashMap<Integer, Long> ridRoidMap = new HashMap<Integer, Long>();
        for (Long roid : this.roids) {
            Revision virtualRevision = this.getRevisionByRoid(roid);
            ridRoidMap.put(virtualRevision.getRid(), virtualRevision.getOid());
            project = virtualRevision.getProject();
            if (!this.getAuthorization().hasRightsOnProjectOrSuperProjectsOrSubProjects(user, project)) {
                throw new UserException("User has insufficient rights to download revisions from this project");
            }
            HashMap map = new HashMap();
            for (String guid : this.guids) {
                if (foundGuids.contains(guid)) continue;
                for (ConcreteRevision concreteRevision : virtualRevision.getConcreteRevisions()) {
                    ObjectIdentifier objectIdentifier = this.getDatabaseSession().getOidOfGuid(concreteRevision.getProject().getSchema(), guid, concreteRevision.getProject().getId(), concreteRevision.getId());
                    if (objectIdentifier == null) continue;
                    foundGuids.add(guid);
                    if (!map.containsKey(concreteRevision)) {
                        map.put(concreteRevision, new HashSet());
                        incrSize += concreteRevision.getSize().longValue();
                    }
                    ((Set)map.get(concreteRevision)).add(objectIdentifier.getOid());
                }
            }
            final long totalSize = incrSize;
            final AtomicLong total = new AtomicLong();
            for (ConcreteRevision concreteRevision : map.keySet()) {
                PackageMetaData packageMetaData;
                lastPackageMetaData = packageMetaData = this.getBimServer().getMetaDataManager().getPackageMetaData(concreteRevision.getProject().getSchema());
                BasicIfcModel subModel = new BasicIfcModel(packageMetaData, ridRoidMap);
                int highestStopId = DownloadByGuidsDatabaseAction.findHighestStopRid(project, concreteRevision);
                OldQuery query = new OldQuery(packageMetaData, concreteRevision.getProject().getId(), concreteRevision.getId(), virtualRevision.getOid(), this.objectIDM, this.deep, highestStopId);
                subModel.addChangeListener(new IfcModelChangeListener(){

                    public void objectAdded() {
                        total.incrementAndGet();
                        DownloadByGuidsDatabaseAction.this.progress = (int)Math.round(100.0 * (double)total.get() / (double)totalSize);
                    }
                });
                Set oids = (Set)map.get(concreteRevision);
                this.getDatabaseSession().getMapWithOids((IfcModelInterface)subModel, oids, query);
                subModel.getModelMetaData().setDate(concreteRevision.getDate());
                try {
                    this.checkGeometry(serializerPluginConfiguration, this.getBimServer().getPluginManager(), (IfcModelInterface)subModel, project, concreteRevision, virtualRevision);
                }
                catch (GeometryGeneratingException e) {
                    throw new UserException((Throwable)e);
                }
                ifcModelSet.add((Object)subModel);
            }
        }
        try {
            BasicIfcModel ifcModel = new BasicIfcModel(lastPackageMetaData, ridRoidMap);
            ifcModel = this.getBimServer().getMergerFactory().createMerger(this.getDatabaseSession(), this.getAuthorization().getUoid()).merge(project, ifcModelSet, new ModelHelper(this.getBimServer().getMetaDataManager(), (IfcModelInterface)ifcModel));
            ifcModel.getModelMetaData().setName("query");
            for (String guid : this.guids) {
                if (foundGuids.contains(guid)) continue;
                throw new UserException("Guid " + guid + " not found");
            }
            ifcModel.getModelMetaData().setRevisionId(1);
            ifcModel.getModelMetaData().setAuthorizedUser(this.getUserByUoid(this.getAuthorization().getUoid()).getName());
            ifcModel.getModelMetaData().setDate(new Date());
            return ifcModel;
        }
        catch (MergeException e) {
            throw new UserException((Throwable)e);
        }
    }

    public int getProgress() {
        return this.progress;
    }
}

