/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.GeometryGeneratingException;
import org.bimserver.ServerIfcModel;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AbstractDownloadDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.ifc.BasicIfcModel;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.PluginConfiguration;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.plugins.IfcModelSet;
import org.bimserver.plugins.ModelHelper;
import org.bimserver.plugins.modelmerger.MergeException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DownloadByJsonQueryDatabaseAction
extends AbstractDownloadDatabaseAction<IfcModelInterface> {
    private final Set<Long> roids;
    private int progress;
    private long serializerOid;
    private String json;

    public DownloadByJsonQueryDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Set<Long> roids, String json, long serializerOid, Authorization authorization) {
        super(bimServer, databaseSession, accessMethod, authorization);
        this.roids = roids;
        this.json = json;
        this.serializerOid = serializerOid;
    }

    @Override
    public IfcModelInterface execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        IfcModelSet ifcModelSet = new IfcModelSet(new IfcModelInterface[0]);
        User user = this.getUserByUoid(this.getAuthorization().getUoid());
        Project project = null;
        PluginConfiguration serializerPluginConfiguration = (PluginConfiguration)this.getDatabaseSession().get(StorePackage.eINSTANCE.getPluginConfiguration(), this.serializerOid, (QueryInterface)OldQuery.getDefault());
        String name = "";
        PackageMetaData lastPackageMetaData = null;
        HashMap<Integer, Long> pidRoidMap = new HashMap<Integer, Long>();
        for (Long roid : this.roids) {
            Revision virtualRevision;
            block19: {
                virtualRevision = this.getRevisionByRoid(roid);
                pidRoidMap.put(virtualRevision.getProject().getId(), virtualRevision.getOid());
                project = virtualRevision.getProject();
                name = name + project.getName() + "-" + virtualRevision.getId() + "-";
                try {
                    this.getAuthorization().canDownload(roid);
                }
                catch (UserException e) {
                    if (!this.getAuthorization().hasRightsOnProjectOrSuperProjectsOrSubProjects(user, project)) {
                        throw new UserException("User has insufficient rights to download revisions from this project");
                    }
                    if (this.getAuthorization().hasRightsOnProjectOrSuperProjectsOrSubProjects(user, project)) break block19;
                    throw new UserException("User has insufficient rights to download revisions from this project");
                }
            }
            int size = 0;
            JsonParser parser = new JsonParser();
            JsonElement query = parser.parse(this.json);
            for (ConcreteRevision concreteRevision : virtualRevision.getConcreteRevisions()) {
                try {
                    PackageMetaData packageMetaData;
                    int highestStopId = DownloadByJsonQueryDatabaseAction.findHighestStopRid(project, concreteRevision);
                    lastPackageMetaData = packageMetaData = this.getBimServer().getMetaDataManager().getPackageMetaData(concreteRevision.getProject().getSchema());
                    ServerIfcModel subModel = new ServerIfcModel(packageMetaData, pidRoidMap, this.getDatabaseSession());
                    OldQuery databaseQuery = new OldQuery(packageMetaData, concreteRevision.getProject().getId(), concreteRevision.getId(), virtualRevision.getOid(), null, OldQuery.Deep.NO, highestStopId);
                    databaseQuery.updateOidCounters(concreteRevision, this.getDatabaseSession());
                    JsonObject queryObject = (JsonObject)query;
                    JsonArray queries = queryObject.get("queries").getAsJsonArray();
                    for (JsonElement queryElement : queries) {
                        this.processQueryPart(packageMetaData, queryObject, (JsonObject)queryElement, (IfcModelInterface)subModel, databaseQuery);
                    }
                    size = (int)((long)size + subModel.size());
                    subModel.getModelMetaData().setDate(concreteRevision.getDate());
                    subModel.fixInverseMismatches();
                    this.checkGeometry(serializerPluginConfiguration, this.getBimServer().getPluginManager(), (IfcModelInterface)subModel, project, concreteRevision, virtualRevision);
                    ifcModelSet.add((Object)subModel);
                }
                catch (GeometryGeneratingException | IfcModelInterfaceException e) {
                    throw new UserException(e);
                }
            }
            ServerIfcModel ifcModel = new ServerIfcModel(lastPackageMetaData, pidRoidMap, size, this.getDatabaseSession());
            if (ifcModelSet.size() > 1) {
                try {
                    ifcModel = this.getBimServer().getMergerFactory().createMerger(this.getDatabaseSession(), this.getAuthorization().getUoid()).merge(project, ifcModelSet, new ModelHelper(this.getBimServer().getMetaDataManager(), (IfcModelInterface)ifcModel));
                }
                catch (MergeException e) {
                    throw new UserException((Throwable)e);
                }
            } else {
                ifcModel = (IfcModelInterface)ifcModelSet.iterator().next();
            }
            ifcModel.getModelMetaData().setName("Unknown");
            ifcModel.getModelMetaData().setRevisionId(project.getRevisions().indexOf((Object)virtualRevision) + 1);
            if (this.getAuthorization().getUoid() != -1L) {
                ifcModel.getModelMetaData().setAuthorizedUser(this.getUserByUoid(this.getAuthorization().getUoid()).getName());
            }
            ifcModel.getModelMetaData().setDate(virtualRevision.getDate());
        }
        BasicIfcModel ifcModel = new BasicIfcModel(lastPackageMetaData, pidRoidMap);
        if (ifcModelSet.size() > 1) {
            try {
                ifcModel = this.getBimServer().getMergerFactory().createMerger(this.getDatabaseSession(), this.getAuthorization().getUoid()).merge(project, ifcModelSet, new ModelHelper(this.getBimServer().getMetaDataManager(), (IfcModelInterface)ifcModel));
            }
            catch (MergeException e) {
                throw new UserException((Throwable)e);
            }
        } else {
            ifcModel = (IfcModelInterface)ifcModelSet.iterator().next();
        }
        if (name.endsWith("-")) {
            name = name.substring(0, name.length() - 1);
        }
        ifcModel.getModelMetaData().setName(name);
        ifcModel.getModelMetaData().setRevisionId(1);
        if (this.getAuthorization().getUoid() != -1L) {
            ifcModel.getModelMetaData().setAuthorizedUser(this.getUserByUoid(this.getAuthorization().getUoid()).getName());
        }
        ifcModel.getModelMetaData().setDate(new Date());
        return ifcModel;
    }

    private void processQueryPart(PackageMetaData packageMetaData, JsonObject query, JsonObject typeQuery, IfcModelInterface model, QueryInterface queryInterface) throws BimserverDatabaseException, IfcModelInterfaceException {
        if (typeQuery.has("type")) {
            String type = typeQuery.get("type").getAsString();
            EClass typeClass = packageMetaData.getEClassIncludingDependencies(type);
            HashSet<EClass> eClasses = new HashSet<EClass>();
            eClasses.add(typeClass);
            if (typeQuery.has("includeAllSubtypes") && typeQuery.get("includeAllSubtypes").getAsBoolean()) {
                eClasses.addAll(packageMetaData.getAllSubClasses(typeClass));
            }
            this.getDatabaseSession().getAllOfTypes(model, eClasses, queryInterface);
            if (typeQuery.has("include")) {
                this.processInclude(query, typeQuery, model, queryInterface, model.getAllWithSubTypes(typeClass));
            }
        }
    }

    private void processInclude(JsonObject query, JsonObject queryPart, IfcModelInterface model, QueryInterface queryInterface, List<IdEObject> objects) throws BimserverDatabaseException, IfcModelInterfaceException {
        if (queryPart.get("include").isJsonArray()) {
            JsonArray includes = queryPart.get("include").getAsJsonArray();
            for (JsonElement include : includes) {
                if (include.isJsonPrimitive()) {
                    this.processSingleInclude(query, include, model, queryInterface, objects);
                    continue;
                }
                if (!include.isJsonObject()) continue;
                this.processDefine(query, (JsonObject)include, model, queryInterface, objects);
            }
        } else if (queryPart.get("include").isJsonObject()) {
            this.processDefine(query, queryPart.get("include").getAsJsonObject(), model, queryInterface, objects);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processSingleInclude(JsonObject query, JsonElement include, IfcModelInterface model, QueryInterface queryInterface, List<IdEObject> objects) throws BimserverDatabaseException, IfcModelInterfaceException {
        if (!include.isJsonPrimitive()) return;
        String includeName = include.getAsString();
        if (!query.has("defines")) throw new BimserverDatabaseException("No define with name '" + includeName + "' found");
        JsonObject defines = query.get("defines").getAsJsonObject();
        if (!defines.has(includeName)) throw new BimserverDatabaseException("No define with name '" + includeName + "' found");
        JsonObject define = defines.get(includeName).getAsJsonObject();
        this.processDefine(query, define, model, queryInterface, objects);
    }

    private void processDefine(JsonObject query, JsonObject define, IfcModelInterface model, QueryInterface queryInterface, List<IdEObject> objects) throws BimserverDatabaseException, IfcModelInterfaceException {
        for (IdEObject object : objects) {
            if (!define.has("field")) continue;
            String fieldName = define.get("field").getAsString();
            EStructuralFeature eStructuralFeature = object.eClass().getEStructuralFeature(fieldName);
            if (eStructuralFeature == null) {
                return;
            }
            Object value = object.eGet(eStructuralFeature);
            if (eStructuralFeature.isMany()) {
                if (!(eStructuralFeature instanceof EReference)) continue;
                List list = (List)value;
                for (Object o : list) {
                    if (!model.contains(((IdEObject)o).getOid())) {
                        model.add(((IdEObject)o).getOid(), (IdEObject)o);
                    }
                    ((IdEObject)o).load();
                    if (!define.has("include")) continue;
                    if (define.get("include").isJsonObject()) {
                        this.processDefine(query, define.get("include").getAsJsonObject(), model, queryInterface, Collections.singletonList((IdEObject)o));
                        continue;
                    }
                    if (define.get("include").isJsonArray()) {
                        this.processInclude(query, define, model, queryInterface, Collections.singletonList((IdEObject)o));
                        continue;
                    }
                    this.processSingleInclude(query, define.get("include"), model, queryInterface, Collections.singletonList((IdEObject)o));
                }
                continue;
            }
            if (value == null || !(value instanceof IdEObject)) continue;
            if (!model.contains(((IdEObject)value).getOid())) {
                model.add(((IdEObject)value).getOid(), (IdEObject)value);
            }
            ((IdEObject)value).load();
            if (!define.has("include")) continue;
            this.processDefine(query, define, model, queryInterface, Collections.singletonList((IdEObject)value));
        }
    }

    public int getProgress() {
        return this.progress;
    }
}

