/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.GeometryGeneratingException;
import org.bimserver.ServerIfcModel;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.ObjectIdentifier;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AbstractDownloadDatabaseAction;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.MetaDataException;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.ifc.IfcModelChangeListener;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.PluginConfiguration;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.plugins.IfcModelSet;
import org.bimserver.plugins.ModelHelper;
import org.bimserver.plugins.modelmerger.MergeException;
import org.bimserver.plugins.objectidms.ObjectIDM;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class DownloadByNamesDatabaseAction
extends AbstractDownloadDatabaseAction<IfcModelInterface> {
    private final Set<Long> roids;
    private int progress;
    private final ObjectIDM objectIDM;
    private long serializerOid;
    private Set<String> names;
    private OldQuery.Deep deep;

    public DownloadByNamesDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Set<Long> roids, Set<String> names, long serializerOid, Authorization authorization, ObjectIDM objectIDM, OldQuery.Deep deep) {
        super(bimServer, databaseSession, accessMethod, authorization);
        this.roids = roids;
        this.names = names;
        this.serializerOid = serializerOid;
        this.objectIDM = objectIDM;
        this.deep = deep;
    }

    @Override
    public IfcModelInterface execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        User user = this.getUserByUoid(this.getAuthorization().getUoid());
        HashSet<String> foundNames = new HashSet<String>();
        IfcModelSet ifcModelSet = new IfcModelSet(new IfcModelInterface[0]);
        Project project = null;
        long incrSize = 0L;
        PluginConfiguration serializerPluginConfiguration = (PluginConfiguration)this.getDatabaseSession().get(StorePackage.eINSTANCE.getPluginConfiguration(), this.serializerOid, (QueryInterface)OldQuery.getDefault());
        PackageMetaData lastPackageMetaData = null;
        HashMap<Integer, Long> ridRoidMap = new HashMap<Integer, Long>();
        for (Long l : this.roids) {
            Revision virtualRevision = this.getRevisionByRoid(l);
            ridRoidMap.put(virtualRevision.getRid(), virtualRevision.getOid());
            project = virtualRevision.getProject();
            if (!this.getAuthorization().hasRightsOnProjectOrSuperProjectsOrSubProjects(user, project)) {
                throw new UserException("User has insufficient rights to download revisions from this project");
            }
            HashMap map = new HashMap();
            for (String name : this.names) {
                if (foundNames.contains(name)) continue;
                for (ConcreteRevision concreteRevision : virtualRevision.getConcreteRevisions()) {
                    try {
                        for (ObjectIdentifier objectIdentifier : this.getDatabaseSession().getOidsOfName(concreteRevision.getProject().getSchema(), name, concreteRevision.getProject().getId(), concreteRevision.getId())) {
                            foundNames.add(name);
                            if (!map.containsKey(concreteRevision)) {
                                map.put(concreteRevision, new HashSet());
                                incrSize += concreteRevision.getSize().longValue();
                            }
                            ((Set)map.get(concreteRevision)).add(objectIdentifier.getOid());
                        }
                    }
                    catch (MetaDataException e) {
                        e.printStackTrace();
                    }
                }
            }
            final long totalSize = incrSize;
            final AtomicLong total = new AtomicLong();
            for (ConcreteRevision concreteRevision : map.keySet()) {
                PackageMetaData packageMetaData;
                lastPackageMetaData = packageMetaData = this.getBimServer().getMetaDataManager().getPackageMetaData(concreteRevision.getProject().getSchema());
                ServerIfcModel subModel = new ServerIfcModel(packageMetaData, ridRoidMap, this.getDatabaseSession());
                int highestStopId = DownloadByNamesDatabaseAction.findHighestStopRid(project, concreteRevision);
                OldQuery query = new OldQuery(packageMetaData, concreteRevision.getProject().getId(), concreteRevision.getId(), virtualRevision.getOid(), this.objectIDM, this.deep, highestStopId);
                subModel.addChangeListener(new IfcModelChangeListener(){

                    public void objectAdded() {
                        total.incrementAndGet();
                        DownloadByNamesDatabaseAction.this.progress = (int)Math.round(100.0 * (double)total.get() / (double)totalSize);
                    }
                });
                Set oids = (Set)map.get(concreteRevision);
                this.getDatabaseSession().getMapWithOids((IfcModelInterface)subModel, oids, query);
                subModel.getModelMetaData().setDate(concreteRevision.getDate());
                try {
                    this.checkGeometry(serializerPluginConfiguration, this.getBimServer().getPluginManager(), (IfcModelInterface)subModel, project, concreteRevision, virtualRevision);
                }
                catch (GeometryGeneratingException e) {
                    throw new UserException((Throwable)e);
                }
                ifcModelSet.add((Object)subModel);
            }
        }
        ServerIfcModel ifcModel = new ServerIfcModel(lastPackageMetaData, ridRoidMap, this.getDatabaseSession());
        try {
            ifcModel = this.getBimServer().getMergerFactory().createMerger(this.getDatabaseSession(), this.getAuthorization().getUoid()).merge(project, ifcModelSet, new ModelHelper(this.getBimServer().getMetaDataManager(), (IfcModelInterface)ifcModel));
            ifcModel.getModelMetaData().setName("query");
            for (String name : this.names) {
                if (foundNames.contains(name)) continue;
                throw new UserException("Name " + name + " not found");
            }
            ifcModel.getModelMetaData().setRevisionId(1);
            ifcModel.getModelMetaData().setAuthorizedUser(this.getUserByUoid(this.getAuthorization().getUoid()).getName());
            ifcModel.getModelMetaData().setDate(new Date());
            return ifcModel;
        }
        catch (MergeException mergeException) {
            throw new UserException((Throwable)mergeException);
        }
    }

    public int getProgress() {
        return this.progress;
    }
}

