/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.ServerIfcModel;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AbstractDownloadDatabaseAction;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.om.JsonQueryObjectModelConverter;
import org.bimserver.database.queries.om.Query;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.StorePackage;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.QueryException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DownloadByNewJsonQueryDatabaseAction
extends AbstractDownloadDatabaseAction<IfcModelInterface> {
    private final Set<Long> roids;
    private int progress;
    private String json;

    public DownloadByNewJsonQueryDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Set<Long> roids, String json, long serializerOid, Authorization authorization) {
        super(bimServer, databaseSession, accessMethod, authorization);
        this.roids = roids;
        this.json = json;
    }

    @Override
    public IfcModelInterface execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        long roid = this.roids.iterator().next();
        Revision revision = (Revision)this.getDatabaseSession().get(StorePackage.eINSTANCE.getRevision(), roid, (QueryInterface)OldQuery.getDefault());
        PackageMetaData packageMetaData = this.getBimServer().getMetaDataManager().getPackageMetaData(revision.getProject().getSchema());
        JsonQueryObjectModelConverter converter = new JsonQueryObjectModelConverter(packageMetaData);
        try {
            ObjectNode queryObject = (ObjectNode)new ObjectMapper().readValue(this.json, ObjectNode.class);
            Query query = converter.parseJson("query", queryObject);
            ServerIfcModel ifcModel = new ServerIfcModel(packageMetaData, null, this.getDatabaseSession());
            QueryObjectProvider queryObjectProvider = new QueryObjectProvider(this.getDatabaseSession(), this.getBimServer(), query, this.roids, packageMetaData);
            HashMapVirtualObject next = queryObjectProvider.next();
            while (next != null) {
                IdEObject newObject = packageMetaData.create(next.eClass());
                for (EAttribute eAttribute : newObject.eClass().getEAllAttributes()) {
                    newObject.eSet((EStructuralFeature)eAttribute, next.eGet((EStructuralFeature)eAttribute));
                }
                ifcModel.add(next.getOid(), newObject);
                next = queryObjectProvider.next();
            }
            queryObjectProvider = new QueryObjectProvider(this.getDatabaseSession(), this.getBimServer(), query, this.roids, packageMetaData);
            next = queryObjectProvider.next();
            while (next != null) {
                IdEObject idEObject = ifcModel.get(next.getOid());
                for (EReference eReference : idEObject.eClass().getEAllReferences()) {
                    if (eReference.isMany()) {
                        List refOids = (List)next.eGet((EStructuralFeature)eReference);
                        List list = (List)idEObject.eGet((EStructuralFeature)eReference);
                        if (refOids == null) continue;
                        for (Long refOid : refOids) {
                            IdEObject ref = ifcModel.get(refOid);
                            if (ref == null) continue;
                            list.add(ref);
                        }
                        continue;
                    }
                    long refOid = (Long)next.eGet((EStructuralFeature)eReference);
                    idEObject.eSet((EStructuralFeature)eReference, (Object)ifcModel.get(refOid));
                }
                next = queryObjectProvider.next();
            }
            String name = "";
            ifcModel.getModelMetaData().setName(name);
            ifcModel.getModelMetaData().setRevisionId(1);
            if (this.getAuthorization().getUoid() != -1L) {
                ifcModel.getModelMetaData().setAuthorizedUser(this.getUserByUoid(this.getAuthorization().getUoid()).getName());
            }
            ifcModel.getModelMetaData().setDate(new Date());
            return ifcModel;
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (IfcModelInterfaceException e) {
            e.printStackTrace();
        }
        catch (QueryException e) {
            e.printStackTrace();
        }
        return null;
    }

    public int getProgress() {
        return this.progress;
    }
}

