/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.GeometryGeneratingException;
import org.bimserver.ServerIfcModel;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AbstractDownloadDatabaseAction;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.ifc.IfcModelChangeListener;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.PluginConfiguration;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.plugins.IfcModelSet;
import org.bimserver.plugins.ModelHelper;
import org.bimserver.plugins.modelmerger.MergeException;
import org.bimserver.plugins.objectidms.ObjectIDM;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class DownloadByOidsDatabaseAction
extends AbstractDownloadDatabaseAction<IfcModelInterface> {
    private final Set<Long> oids;
    private final Set<Long> roids;
    private int progress;
    private long serializerOid;
    private OldQuery.Deep deep;

    public DownloadByOidsDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Set<Long> roids, Set<Long> oids, long serializerOid, Authorization authorization, ObjectIDM objectIDM, OldQuery.Deep deep) {
        super(bimServer, databaseSession, accessMethod, authorization);
        this.roids = roids;
        this.oids = oids;
        this.serializerOid = serializerOid;
        this.deep = deep;
    }

    @Override
    public IfcModelInterface execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        User user = this.getUserByUoid(this.getAuthorization().getUoid());
        IfcModelSet ifcModelSet = new IfcModelSet(new IfcModelInterface[0]);
        Project project = null;
        long incrSize = 0L;
        PackageMetaData lastPackageMetaData = null;
        HashMap<Integer, Long> pidRoidMap = new HashMap<Integer, Long>();
        PluginConfiguration serializerPluginConfiguration = (PluginConfiguration)this.getDatabaseSession().get(StorePackage.eINSTANCE.getPluginConfiguration(), this.serializerOid, (QueryInterface)OldQuery.getDefault());
        for (Long roid : this.roids) {
            Revision virtualRevision = this.getRevisionByRoid(roid);
            project = virtualRevision.getProject();
            if (!this.getAuthorization().hasRightsOnProjectOrSuperProjectsOrSubProjects(user, project)) {
                throw new UserException("User has insufficient rights to download revisions from this project");
            }
            final long totalSize = incrSize += (long)virtualRevision.getConcreteRevisions().size();
            final AtomicLong total = new AtomicLong();
            pidRoidMap.put(virtualRevision.getProject().getId(), virtualRevision.getOid());
            for (ConcreteRevision concreteRevision : virtualRevision.getConcreteRevisions()) {
                PackageMetaData packageMetaData;
                lastPackageMetaData = packageMetaData = this.getBimServer().getMetaDataManager().getPackageMetaData(concreteRevision.getProject().getSchema());
                ServerIfcModel subModel = new ServerIfcModel(packageMetaData, pidRoidMap, this.getDatabaseSession());
                int highestStopId = DownloadByOidsDatabaseAction.findHighestStopRid(project, concreteRevision);
                OldQuery query = new OldQuery(packageMetaData, concreteRevision.getProject().getId(), concreteRevision.getId(), virtualRevision.getOid(), null, this.deep, highestStopId);
                subModel.addChangeListener(new IfcModelChangeListener(){

                    public void objectAdded() {
                        total.incrementAndGet();
                        DownloadByOidsDatabaseAction.this.progress = (int)Math.round(100.0 * (double)total.get() / (double)totalSize);
                    }
                });
                this.getDatabaseSession().getMapWithOids((IfcModelInterface)subModel, this.oids, query);
                subModel.getModelMetaData().setDate(concreteRevision.getDate());
                try {
                    this.checkGeometry(serializerPluginConfiguration, this.getBimServer().getPluginManager(), (IfcModelInterface)subModel, project, concreteRevision, virtualRevision);
                }
                catch (GeometryGeneratingException e) {
                    throw new UserException((Throwable)e);
                }
                ifcModelSet.add((Object)subModel);
            }
        }
        ServerIfcModel ifcModel = new ServerIfcModel(lastPackageMetaData, pidRoidMap, this.getDatabaseSession());
        try {
            ifcModel = this.getBimServer().getMergerFactory().createMerger(this.getDatabaseSession(), this.getAuthorization().getUoid()).merge(project, ifcModelSet, new ModelHelper(this.getBimServer().getMetaDataManager(), (IfcModelInterface)ifcModel));
        }
        catch (MergeException e) {
            throw new UserException((Throwable)e);
        }
        ifcModel.getModelMetaData().setName("query");
        ifcModel.getModelMetaData().setRevisionId(1);
        ifcModel.getModelMetaData().setAuthorizedUser(this.getUserByUoid(this.getAuthorization().getUoid()).getName());
        ifcModel.getModelMetaData().setDate(new Date());
        return ifcModel;
    }

    public int getProgress() {
        return this.progress;
    }
}

