/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.GeometryGeneratingException;
import org.bimserver.ServerIfcModel;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AbstractDownloadDatabaseAction;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.ifc2x3tc1.Ifc2x3tc1Package;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.PluginConfiguration;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.plugins.IfcModelSet;
import org.bimserver.plugins.ModelHelper;
import org.bimserver.plugins.modelmerger.MergeException;
import org.bimserver.plugins.objectidms.HideAllInversesObjectIDM;
import org.bimserver.plugins.objectidms.ObjectIDM;
import org.bimserver.plugins.objectidms.StructuralFeatureIdentifier;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.CollectionUtils;
import org.bimserver.webservices.authorization.Authorization;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DownloadByTypesDatabaseAction
extends AbstractDownloadDatabaseAction<IfcModelInterface> {
    private final Set<String> classNames;
    private final Set<Long> roids;
    private int progress;
    private final ObjectIDM objectIDM;
    private final boolean includeAllSubtypes;
    private long serializerOid;
    private boolean useObjectIDM;
    private OldQuery.Deep deep;
    private String schema;

    public DownloadByTypesDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Set<Long> roids, String schema, Set<String> classNames, long serializerOid, boolean includeAllSubtypes, boolean useObjectIDM, Authorization authorization, ObjectIDM objectIDM, OldQuery.Deep deep) {
        super(bimServer, databaseSession, accessMethod, authorization);
        this.roids = roids;
        this.schema = schema;
        this.serializerOid = serializerOid;
        this.includeAllSubtypes = includeAllSubtypes;
        this.useObjectIDM = useObjectIDM;
        this.classNames = classNames;
        this.objectIDM = objectIDM;
        this.deep = deep;
    }

    @Override
    public IfcModelInterface execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        IfcModelSet ifcModelSet = new IfcModelSet(new IfcModelInterface[0]);
        User user = this.getUserByUoid(this.getAuthorization().getUoid());
        Project project = null;
        HashSet<EClass> eClasses = new HashSet<EClass>();
        PluginConfiguration serializerPluginConfiguration = (PluginConfiguration)this.getDatabaseSession().get(StorePackage.eINSTANCE.getPluginConfiguration(), this.serializerOid, (QueryInterface)OldQuery.getDefault());
        for (String className : this.classNames) {
            eClasses.add(this.getDatabaseSession().getEClassForName(this.schema, className));
            if (!this.includeAllSubtypes) continue;
            EClassifier eClassifier = Ifc2x3tc1Package.eINSTANCE.getEClassifier(className);
            if (eClassifier == null) {
                throw new UserException("Class " + className + " not found");
            }
            eClasses.addAll(this.getBimServer().getDatabase().getMetaDataManager().getPackageMetaData(this.schema).getAllSubClasses((EClass)eClassifier));
        }
        String name = "";
        PackageMetaData lastPackageMetaData = null;
        HashMap<Integer, Long> pidRoidMap = new HashMap<Integer, Long>();
        for (Long roid : this.roids) {
            Revision virtualRevision;
            block20: {
                virtualRevision = this.getRevisionByRoid(roid);
                pidRoidMap.put(virtualRevision.getProject().getId(), virtualRevision.getOid());
                project = virtualRevision.getProject();
                name = name + project.getName() + "-" + virtualRevision.getId() + "-";
                try {
                    this.getAuthorization().canDownload(roid);
                }
                catch (UserException e) {
                    if (!this.getAuthorization().hasRightsOnProjectOrSuperProjectsOrSubProjects(user, project)) {
                        throw new UserException("User has insufficient rights to download revisions from this project");
                    }
                    if (this.getAuthorization().hasRightsOnProjectOrSuperProjectsOrSubProjects(user, project)) break block20;
                    throw new UserException("User has insufficient rights to download revisions from this project");
                }
            }
            int size = 0;
            for (ConcreteRevision concreteRevision : virtualRevision.getConcreteRevisions()) {
                PackageMetaData packageMetaData = this.getBimServer().getMetaDataManager().getPackageMetaData(concreteRevision.getProject().getSchema());
                try {
                    HideAllInversesObjectIDM hideAllInversesObjectIDM = new HideAllInversesObjectIDM(CollectionUtils.singleSet((Object)Ifc2x3tc1Package.eINSTANCE), this.getBimServer().getPluginManager().getMetaDataManager().getPackageMetaData(this.schema));
                    hideAllInversesObjectIDM.removeFromGeneralIgnoreSet(new StructuralFeatureIdentifier(Ifc2x3tc1Package.eINSTANCE.getIfcRepresentationItem().getName(), Ifc2x3tc1Package.eINSTANCE.getIfcRepresentationItem_StyledByItem().getName()));
                    hideAllInversesObjectIDM.removeFromGeneralIgnoreSet(new StructuralFeatureIdentifier(Ifc2x3tc1Package.eINSTANCE.getIfcExtrudedAreaSolid().getName(), Ifc2x3tc1Package.eINSTANCE.getIfcRepresentationItem_StyledByItem().getName()));
                    hideAllInversesObjectIDM.removeFromGeneralIgnoreSet((EStructuralFeature)Ifc2x3tc1Package.eINSTANCE.getIfcObject_IsDefinedBy());
                    hideAllInversesObjectIDM.removeFromGeneralIgnoreSet((EStructuralFeature)Ifc2x3tc1Package.eINSTANCE.getIfcObjectDefinition_IsDecomposedBy());
                    hideAllInversesObjectIDM.removeFromGeneralIgnoreSet((EStructuralFeature)Ifc2x3tc1Package.eINSTANCE.getIfcOpeningElement_HasFillings());
                    hideAllInversesObjectIDM.removeFromGeneralIgnoreSet((EStructuralFeature)Ifc2x3tc1Package.eINSTANCE.getIfcObjectDefinition_HasAssociations());
                    hideAllInversesObjectIDM.removeFromGeneralIgnoreSet((EStructuralFeature)Ifc2x3tc1Package.eINSTANCE.getIfcGroup_IsGroupedBy());
                    int highestStopId = DownloadByTypesDatabaseAction.findHighestStopRid(project, concreteRevision);
                    IfcModelInterface subModel = this.getDatabaseSession().getAllOfTypes(eClasses, new OldQuery(packageMetaData, concreteRevision.getProject().getId(), concreteRevision.getId(), virtualRevision.getOid(), (ObjectIDM)(this.useObjectIDM ? this.objectIDM : hideAllInversesObjectIDM), this.deep, highestStopId));
                    size = (int)((long)size + subModel.size());
                    subModel.getModelMetaData().setDate(concreteRevision.getDate());
                    this.checkGeometry(serializerPluginConfiguration, this.getBimServer().getPluginManager(), subModel, project, concreteRevision, virtualRevision);
                    ifcModelSet.add((Object)subModel);
                    lastPackageMetaData = packageMetaData;
                }
                catch (GeometryGeneratingException e) {
                    throw new UserException((Throwable)e);
                }
            }
            ServerIfcModel ifcModel = new ServerIfcModel(lastPackageMetaData, pidRoidMap, size, this.getDatabaseSession());
            if (ifcModelSet.size() > 1) {
                try {
                    ifcModel = this.getBimServer().getMergerFactory().createMerger(this.getDatabaseSession(), this.getAuthorization().getUoid()).merge(project, ifcModelSet, new ModelHelper(this.getBimServer().getMetaDataManager(), (IfcModelInterface)ifcModel));
                }
                catch (MergeException e) {
                    throw new UserException((Throwable)e);
                }
            } else {
                ifcModel = (IfcModelInterface)ifcModelSet.iterator().next();
            }
            ifcModel.getModelMetaData().setName("Unknown");
            ifcModel.getModelMetaData().setRevisionId(project.getRevisions().indexOf((Object)virtualRevision) + 1);
            if (this.getAuthorization().getUoid() != -1L) {
                ifcModel.getModelMetaData().setAuthorizedUser(this.getUserByUoid(this.getAuthorization().getUoid()).getName());
            }
            ifcModel.getModelMetaData().setDate(virtualRevision.getDate());
        }
        ServerIfcModel ifcModel = new ServerIfcModel(lastPackageMetaData, pidRoidMap, this.getDatabaseSession());
        if (ifcModelSet.size() > 1) {
            try {
                ifcModel = this.getBimServer().getMergerFactory().createMerger(this.getDatabaseSession(), this.getAuthorization().getUoid()).merge(project, ifcModelSet, new ModelHelper(this.getBimServer().getMetaDataManager(), (IfcModelInterface)ifcModel));
            }
            catch (MergeException e) {
                throw new UserException((Throwable)e);
            }
        } else {
            ifcModel = (IfcModelInterface)ifcModelSet.iterator().next();
        }
        if (name.endsWith("-")) {
            name = name.substring(0, name.length() - 1);
        }
        ifcModel.getModelMetaData().setName(name);
        ifcModel.getModelMetaData().setRevisionId(1);
        if (this.getAuthorization().getUoid() != -1L) {
            ifcModel.getModelMetaData().setAuthorizedUser(this.getUserByUoid(this.getAuthorization().getUoid()).getName());
        }
        ifcModel.getModelMetaData().setDate(new Date());
        return ifcModel;
    }

    public int getProgress() {
        return this.progress;
    }
}

