/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.ServerIfcModel;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AbstractDownloadDatabaseAction;
import org.bimserver.database.actions.DownloadDatabaseAction;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.OidProvider;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.ifc2x3tc1.Ifc2x3tc1Package;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.QueryEnginePluginConfiguration;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.SerializerPluginConfiguration;
import org.bimserver.models.store.StorePackage;
import org.bimserver.plugins.ModelHelper;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.Reporter;
import org.bimserver.plugins.objectidms.HideAllInversesObjectIDM;
import org.bimserver.plugins.objectidms.ObjectIDM;
import org.bimserver.plugins.queryengine.QueryEngine;
import org.bimserver.plugins.queryengine.QueryEngineException;
import org.bimserver.plugins.queryengine.QueryEnginePlugin;
import org.bimserver.shared.exceptions.PluginException;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.CollectionUtils;
import org.bimserver.webservices.authorization.Authorization;
import org.eclipse.emf.ecore.EClass;

public class DownloadQueryDatabaseAction
extends AbstractDownloadDatabaseAction<IfcModelInterface> {
    private ObjectIDM objectIDM;
    private final long qeid;
    private final String code;
    private final long roid;
    private long serializerOid;

    public DownloadQueryDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, long roid, long qeid, long serializerOid, String code, Authorization authorization, ObjectIDM objectIDM) {
        super(bimServer, databaseSession, accessMethod, authorization);
        this.roid = roid;
        this.qeid = qeid;
        this.serializerOid = serializerOid;
        this.code = code;
        this.objectIDM = objectIDM;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IfcModelInterface execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException, ServerException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SerializerPluginConfiguration serializerPluginConfiguration = (SerializerPluginConfiguration)this.getDatabaseSession().get(StorePackage.eINSTANCE.getSerializerPluginConfiguration(), this.serializerOid, (QueryInterface)OldQuery.getDefault());
            DownloadDatabaseAction action = new DownloadDatabaseAction(this.getBimServer(), session, AccessMethod.INTERNAL, this.roid, -1L, serializerPluginConfiguration.getOid(), this.getAuthorization(), null);
            IfcModelInterface ifcModel = session.executeAndCommitAction(action);
            QueryEnginePluginConfiguration queryEngineObject = (QueryEnginePluginConfiguration)session.get(StorePackage.eINSTANCE.getQueryEnginePluginConfiguration(), this.qeid, (QueryInterface)OldQuery.getDefault());
            Revision revision = (Revision)session.get(this.roid, OldQuery.getDefault());
            PackageMetaData packageMetaData = this.getBimServer().getMetaDataManager().getPackageMetaData(revision.getProject().getSchema());
            if (this.objectIDM == null) {
                this.objectIDM = new HideAllInversesObjectIDM(CollectionUtils.singleSet((Object)Ifc2x3tc1Package.eINSTANCE), packageMetaData);
            }
            if (queryEngineObject == null) throw new UserException("No configured query engine found with qeid " + this.qeid);
            QueryEnginePlugin queryEnginePlugin = this.getBimServer().getPluginManager().getQueryEngine(queryEngineObject.getPluginDescriptor().getPluginClassName(), true);
            if (queryEnginePlugin != null) {
                IfcModelInterface finalResult;
                QueryEngine queryEngine = queryEnginePlugin.getQueryEngine(new PluginConfiguration(queryEngineObject.getSettings()));
                ServerIfcModel result = new ServerIfcModel(packageMetaData, null, this.getDatabaseSession());
                ModelHelper modelHelper = new ModelHelper(this.getBimServer().getMetaDataManager(), this.objectIDM, (IfcModelInterface)result);
                modelHelper.setOidProvider(new OidProvider(){
                    private long oid = 1000000L;

                    public long newOid(EClass eClass) {
                        return this.oid++;
                    }
                });
                IfcModelInterface ifcModelInterface = finalResult = queryEngine.query(ifcModel, this.code, new Reporter(){

                    public void error(Exception error) {
                    }

                    public void warning(String warning) {
                    }

                    public void info(String info) {
                    }
                }, modelHelper);
                return ifcModelInterface;
            }
            try {
                throw new UserException("No Query Engine found " + queryEngineObject.getPluginDescriptor().getPluginClassName());
            }
            catch (BimserverDatabaseException e) {
                throw new UserException((Throwable)e);
            }
            catch (QueryEngineException e) {
                throw new UserException((Throwable)e);
            }
            catch (PluginException e) {
                throw new UserException((Throwable)e);
            }
        }
    }
}

