/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Arrays;
import java.util.Date;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.actions.CreateRevisionResult;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.Checkout;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.UserException;

public abstract class GenericCheckinDatabaseAction
extends BimDatabaseAction<ConcreteRevision> {
    public GenericCheckinDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod) {
        super(databaseSession, accessMethod);
    }

    protected void checkCheckSum(Project project, IfcModelInterface model) throws UserException {
        ConcreteRevision lastConcreteRevision = project.getLastConcreteRevision();
        if (lastConcreteRevision != null) {
            int revisionId = -1;
            for (Revision revision : lastConcreteRevision.getRevisions()) {
                if (revision.getProject() != project) continue;
                revisionId = revision.getId();
            }
            byte[] revisionChecksum = lastConcreteRevision.getChecksum();
            if (revisionChecksum != null && model.getModelMetaData().getChecksum() != null && Arrays.equals(revisionChecksum, model.getModelMetaData().getChecksum())) {
                throw new UserException("Uploaded model is the same as last revision (" + revisionId + "), duplicate model not stored");
            }
        }
    }

    public CreateRevisionResult createNewConcreteRevision(DatabaseSession session, long size, Project project, User user, String comment) throws BimserverDatabaseException, BimserverLockConflictException {
        CreateRevisionResult result = new CreateRevisionResult();
        ConcreteRevision concreteRevision = this.getDatabaseSession().create(ConcreteRevision.class);
        concreteRevision.setSize(Long.valueOf(size));
        Date date = new Date();
        concreteRevision.setDate(date);
        concreteRevision.setId(Integer.valueOf(project.getConcreteRevisions().size() + 1));
        concreteRevision.setUser(user);
        concreteRevision.setProject(project);
        project.setLastConcreteRevision(concreteRevision);
        Revision newRevision = this.createNewVirtualRevision(session, project, concreteRevision, comment, date, user, size);
        for (Checkout checkout : project.getCheckouts()) {
            if (checkout.getUser() != user) continue;
            checkout.setActive(Boolean.valueOf(false));
            session.store((IdEObject)checkout);
        }
        project.setLastRevision(newRevision);
        result.addRevision(newRevision);
        for (Project parent = project.getParent(); parent != null; parent = parent.getParent()) {
            Revision revision = this.getDatabaseSession().create(Revision.class);
            result.addRevision(revision);
            revision.setComment("generated for subproject " + project.getName() + ", revision " + concreteRevision.getId() + ", by " + user.getName());
            revision.setDate(date);
            revision.setUser(this.getSystemUser());
            revision.setProject(parent);
            if (parent.getLastRevision() != null) {
                Revision lastRevision = parent.getLastRevision();
                for (ConcreteRevision oldRevision : lastRevision.getConcreteRevisions()) {
                    if (oldRevision.getProject() == project || oldRevision.getProject() == parent) continue;
                    revision.getConcreteRevisions().add((Object)oldRevision);
                    revision.setSize(Long.valueOf((revision.getSize() == null ? 0L : revision.getSize()) + oldRevision.getSize()));
                    session.store((IdEObject)revision);
                    session.store((IdEObject)oldRevision);
                }
            }
            revision.getConcreteRevisions().add((Object)concreteRevision);
            revision.setSize(Long.valueOf((revision.getSize() == null ? 0L : revision.getSize()) + concreteRevision.getSize()));
            revision.setLastConcreteRevision(concreteRevision);
            if (parent.getLastRevision() == null) {
                revision.setId(Integer.valueOf(1));
            } else {
                revision.setId(Integer.valueOf(parent.getLastRevision().getId() + 1));
            }
            parent.setLastRevision(revision);
            session.store((IdEObject)revision);
            session.store((IdEObject)parent);
        }
        session.store((IdEObject)project);
        session.store((IdEObject)user);
        session.store((IdEObject)concreteRevision);
        result.setConcreteRevision(concreteRevision);
        return result;
    }

    private Revision createNewVirtualRevision(DatabaseSession session, Project project, ConcreteRevision concreteRevision, String comment, Date date, User user, long size) throws BimserverLockConflictException, BimserverDatabaseException {
        Revision revision = session.create(Revision.class);
        revision.setLastConcreteRevision(concreteRevision);
        revision.setComment(comment);
        revision.setDate(date);
        revision.setUser(user);
        user.getRevisions().add((Object)revision);
        revision.setSize(Long.valueOf(size));
        revision.setId(Integer.valueOf(project.getRevisions().size() + 1));
        revision.getConcreteRevisions().add((Object)concreteRevision);
        revision.setProject(project);
        return revision;
    }
}

