/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.query.conditions.HasReferenceToInCondition;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.Checkout;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.StorePackage;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.CollectionUtils;

public class GetAllCheckoutsOfProjectDatabaseAction
extends BimDatabaseAction<List<Checkout>> {
    private final long poid;
    private final boolean checkSubProjects;

    public GetAllCheckoutsOfProjectDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, long poid, boolean checkSubProjects) {
        super(databaseSession, accessMethod);
        this.poid = poid;
        this.checkSubProjects = checkSubProjects;
    }

    @Override
    public List<Checkout> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        Project project = this.getProjectByPoid(this.poid);
        HashSet<Project> projects = new HashSet<Project>();
        if (this.checkSubProjects) {
            this.getSubProjects(project, projects);
        } else {
            projects.add(project);
        }
        HasReferenceToInCondition condition = new HasReferenceToInCondition(StorePackage.eINSTANCE.getCheckout_Project(), projects);
        Map<Long, Checkout> query = this.getDatabaseSession().query(condition, Checkout.class, OldQuery.getDefault());
        return CollectionUtils.mapToList(query);
    }

    private void getSubProjects(Project project, Set<Project> projects) {
        projects.add(project);
        for (Project subProject : project.getSubProjects()) {
            this.getSubProjects(subProject, projects);
        }
    }
}

