/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.List;
import java.util.Map;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.query.conditions.IsOfTypeCondition;
import org.bimserver.emf.IdEObject;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.CollectionUtils;
import org.eclipse.emf.ecore.EClass;

public class GetAllDatabaseAction<T extends IdEObject>
extends BimDatabaseAction<List<T>> {
    private final Class<T> clazz;
    private final EClass eClass;

    public GetAllDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, Class<T> clazz, EClass eClass) {
        super(databaseSession, accessMethod);
        this.clazz = clazz;
        this.eClass = eClass;
    }

    @Override
    public List<T> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        IsOfTypeCondition condition = new IsOfTypeCondition(this.eClass);
        Map<Long, T> result = this.getDatabaseSession().query(condition, this.clazz, OldQuery.getDefault());
        return CollectionUtils.mapToList(result);
    }
}

