/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.GetAllDatabaseAction;
import org.bimserver.database.query.conditions.IsOfTypeCondition;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.DeserializerPluginConfiguration;
import org.bimserver.models.store.StorePackage;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.CollectionUtils;

public class GetAllDeserializersDatabaseAction
extends GetAllDatabaseAction<DeserializerPluginConfiguration> {
    private final boolean onlyEnabled;
    private final BimServer bimServer;

    public GetAllDeserializersDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, BimServer bimServer, boolean onlyEnabled) {
        super(databaseSession, accessMethod, DeserializerPluginConfiguration.class, StorePackage.eINSTANCE.getDeserializerPluginConfiguration());
        this.bimServer = bimServer;
        this.onlyEnabled = onlyEnabled;
    }

    @Override
    public List<DeserializerPluginConfiguration> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        IsOfTypeCondition condition = new IsOfTypeCondition(StorePackage.eINSTANCE.getDeserializerPluginConfiguration());
        Map<Long, DeserializerPluginConfiguration> result = this.getDatabaseSession().query(condition, DeserializerPluginConfiguration.class, OldQuery.getDefault());
        List mapToList = CollectionUtils.mapToList(result);
        if (this.onlyEnabled) {
            Iterator iterator = mapToList.iterator();
            while (iterator.hasNext()) {
                DeserializerPluginConfiguration deserializer = (DeserializerPluginConfiguration)iterator.next();
                if (this.bimServer.getPluginManager().isEnabled(deserializer.getPluginDescriptor().getPluginClassName()) && deserializer.getEnabled().booleanValue()) continue;
                iterator.remove();
            }
        }
        return mapToList;
    }
}

