/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Set;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.query.conditions.AndCondition;
import org.bimserver.database.query.conditions.AttributeCondition;
import org.bimserver.database.query.conditions.HasReferenceToCondition;
import org.bimserver.database.query.conditions.Not;
import org.bimserver.database.query.literals.StringLiteral;
import org.bimserver.emf.IdEObject;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.StorePackage;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.CollectionUtils;

public class GetAllNonAuthorizedProjectsOfUserDatabaseAction
extends BimDatabaseAction<Set<Project>> {
    private final long uoid;

    public GetAllNonAuthorizedProjectsOfUserDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, long uoid) {
        super(databaseSession, accessMethod);
        this.uoid = uoid;
    }

    @Override
    public Set<Project> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        AndCondition condition = new Not(new HasReferenceToCondition(StorePackage.eINSTANCE.getProject_HasAuthorizedUsers(), (IdEObject)this.getUserByUoid(this.uoid))).and(new Not(new AttributeCondition(StorePackage.eINSTANCE.getProject_Name(), new StringLiteral("INT-Store"))));
        return CollectionUtils.mapToSet(this.getDatabaseSession().query(condition, Project.class, OldQuery.getDefault()));
    }
}

