/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.query.conditions.AndCondition;
import org.bimserver.database.query.conditions.AttributeCondition;
import org.bimserver.database.query.conditions.HasReferenceToCondition;
import org.bimserver.database.query.conditions.IsOfTypeCondition;
import org.bimserver.database.query.conditions.Not;
import org.bimserver.database.query.literals.EnumLiteral;
import org.bimserver.database.query.literals.StringLiteral;
import org.bimserver.emf.IdEObject;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ObjectState;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class GetAllProjectsDatabaseAction
extends BimDatabaseAction<Set<Project>> {
    private Authorization authorization;
    private boolean onlyTopLevel;
    private Boolean onlyActive;

    public GetAllProjectsDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, boolean onlyTopLevel, Boolean onlyActive, Authorization authorization) {
        super(databaseSession, accessMethod);
        this.onlyTopLevel = onlyTopLevel;
        this.onlyActive = onlyActive;
        this.authorization = authorization;
    }

    @Override
    public Set<Project> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        User user = this.getUserByUoid(this.authorization.getUoid());
        Not notStoreProject = new Not(new AttributeCondition(StorePackage.eINSTANCE.getProject_Name(), new StringLiteral("INT-Store")));
        HasReferenceToCondition authorized = new HasReferenceToCondition(StorePackage.eINSTANCE.getProject_HasAuthorizedUsers(), (IdEObject)user);
        AndCondition condition = new IsOfTypeCondition(StorePackage.eINSTANCE.getProject()).and(notStoreProject);
        if (this.onlyActive.booleanValue()) {
            condition = new AndCondition(condition, new AttributeCondition(StorePackage.eINSTANCE.getProject_State(), new EnumLiteral((Enum<?>)ObjectState.ACTIVE)));
        }
        if (user.getUserType() != UserType.ADMIN && user.getUserType() != UserType.SYSTEM) {
            condition = condition.and(authorized);
            condition = condition.and(new AttributeCondition(StorePackage.eINSTANCE.getProject_State(), new EnumLiteral((Enum<?>)ObjectState.ACTIVE)));
        }
        Map<Long, Project> results = this.getDatabaseSession().query(condition, Project.class, OldQuery.getDefault());
        HashSet<Project> resultSet = new HashSet<Project>();
        for (Project p : results.values()) {
            if (p.getParent() != null && this.onlyTopLevel) continue;
            resultSet.add(p);
        }
        for (Project project : results.values()) {
            this.addParentProjects(resultSet, project);
        }
        return resultSet;
    }

    private void addParentProjects(Set<Project> resultSet, Project project) {
        if (project.getParent() != null) {
            if (!resultSet.contains(project.getParent()) && (project.getParent() != null && project.getParent().getParent() == null || !this.onlyTopLevel)) {
                resultSet.add(project.getParent());
            }
            this.addParentProjects(resultSet, project.getParent());
        }
    }
}

