/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.interfaces.objects.SProjectSmall;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ObjectState;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.AdminAuthorization;
import org.bimserver.webservices.authorization.Authorization;

public class GetAllProjectsSmallDatabaseAction
extends BimDatabaseAction<List<SProjectSmall>> {
    private Authorization authorization;
    private BimServer bimServer;

    public GetAllProjectsSmallDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Authorization authorization) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.authorization = authorization;
    }

    @Override
    public List<SProjectSmall> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        ArrayList<SProjectSmall> list = new ArrayList<SProjectSmall>();
        User user = this.getUserByUoid(this.authorization.getUoid());
        IfcModelInterface model = this.getDatabaseSession().getAllOfType(StorePackage.eINSTANCE.getProject(), OldQuery.getDefault());
        List projects = model.getAll(Project.class);
        for (Project project : projects) {
            if (project.getParent() != null || project.getName().equals("INT-Store")) continue;
            Project rootProject = this.getRootProject(project);
            this.addProjects(list, rootProject, user);
        }
        return list;
    }

    private Project getRootProject(Project project) {
        if (project.getParent() != null) {
            return this.getRootProject(project.getParent());
        }
        return project;
    }

    private void addProjects(List<SProjectSmall> list, Project project, User user) {
        if (project.getState() == ObjectState.DELETED && !(this.authorization instanceof AdminAuthorization)) {
            return;
        }
        list.add(GetAllProjectsSmallDatabaseAction.createSmallProject(this.authorization, this.bimServer, project, user));
        ArrayList subProjects = new ArrayList(project.getSubProjects());
        Collections.sort(subProjects, new Comparator<Project>(){

            @Override
            public int compare(Project o1, Project o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Project subProject : subProjects) {
            this.addProjects(list, subProject, user);
        }
    }

    public static SProjectSmall createSmallProject(Authorization authorization, BimServer bimServer, Project project, User user) {
        SProjectSmall small = new SProjectSmall();
        small.setName(project.getName());
        small.setOid(project.getOid());
        small.setLastRevisionId(project.getLastRevision() == null ? -1L : project.getLastRevision().getOid());
        small.setNrRevisions(project.getRevisions().size());
        small.setSchema(project.getSchema());
        small.setNrSubProjects(project.getSubProjects().size());
        small.setHasCheckinRights(authorization.hasRightsOnProject(user, project));
        small.setState(bimServer.getSConverter().convertToSObject(project.getState()));
        small.setParentId(project.getParent() == null ? -1L : project.getParent().getOid());
        return small;
    }
}

