/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.actions.GetAllProjectsSmallDatabaseAction;
import org.bimserver.emf.QueryInterface;
import org.bimserver.interfaces.objects.SProjectSmall;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ObjectState;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.AdminAuthorization;
import org.bimserver.webservices.authorization.Authorization;

public class GetAllRelatedProjectsDatabaseAction
extends BimDatabaseAction<List<SProjectSmall>> {
    private Long poid;
    private BimServer bimServer;
    private Authorization authorization;

    public GetAllRelatedProjectsDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, Authorization authorization, AccessMethod accessMethod, Long poid) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.authorization = authorization;
        this.poid = poid;
    }

    @Override
    public List<SProjectSmall> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        ArrayList<SProjectSmall> list = new ArrayList<SProjectSmall>();
        Project project = (Project)this.getDatabaseSession().get(StorePackage.eINSTANCE.getProject(), (long)this.poid, (QueryInterface)OldQuery.getDefault());
        Project rootProject = this.getRootProject(project);
        User user = this.getUserByUoid(this.authorization.getUoid());
        this.addProjects(list, rootProject, user);
        return list;
    }

    private Project getRootProject(Project project) {
        if (project.getParent() != null) {
            return this.getRootProject(project.getParent());
        }
        return project;
    }

    private void addProjects(List<SProjectSmall> list, Project project, User user) {
        if (project.getState() == ObjectState.DELETED && !(this.authorization instanceof AdminAuthorization)) {
            return;
        }
        list.add(GetAllProjectsSmallDatabaseAction.createSmallProject(this.authorization, this.bimServer, project, user));
        ArrayList subProjects = new ArrayList(project.getSubProjects());
        Collections.sort(subProjects, new Comparator<Project>(){

            @Override
            public int compare(Project o1, Project o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Project subProject : subProjects) {
            this.addProjects(list, subProject, user);
        }
    }
}

