/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Set;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.query.conditions.HasReferenceToCondition;
import org.bimserver.emf.IdEObject;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.CollectionUtils;

public class GetAllRevisionsByUserDatabaseAction
extends BimDatabaseAction<Set<Revision>> {
    private final long uoid;

    public GetAllRevisionsByUserDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, long uoid) {
        super(databaseSession, accessMethod);
        this.uoid = uoid;
    }

    @Override
    public Set<Revision> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        User user = this.getUserByUoid(this.uoid);
        HasReferenceToCondition condition = new HasReferenceToCondition(StorePackage.eINSTANCE.getRevision_User(), (IdEObject)user);
        return CollectionUtils.mapToSet(this.getDatabaseSession().query(condition, Revision.class, OldQuery.getDefault()));
    }
}

