/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Set;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.query.conditions.AttributeCondition;
import org.bimserver.database.query.conditions.Condition;
import org.bimserver.database.query.conditions.IsOfTypeCondition;
import org.bimserver.database.query.conditions.Not;
import org.bimserver.database.query.literals.EnumLiteral;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ObjectState;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.CollectionUtils;
import org.bimserver.webservices.authorization.Authorization;

public class GetAllUsersDatabaseAction
extends BimDatabaseAction<Set<User>> {
    private Authorization authorization;

    public GetAllUsersDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, Authorization authorization) {
        super(databaseSession, accessMethod);
        this.authorization = authorization;
    }

    @Override
    public Set<User> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        User actingUser = this.getUserByUoid(this.authorization.getUoid());
        Condition condition = new IsOfTypeCondition(StorePackage.eINSTANCE.getUser());
        condition = condition.and(new Not(new AttributeCondition(StorePackage.eINSTANCE.getUser_UserType(), new EnumLiteral((Enum<?>)UserType.SYSTEM))));
        if (actingUser.getUserType() != UserType.ADMIN) {
            condition = condition.and(new AttributeCondition(StorePackage.eINSTANCE.getUser_State(), new EnumLiteral((Enum<?>)ObjectState.ACTIVE)));
        }
        return CollectionUtils.mapToSet(this.getDatabaseSession().query(condition, User.class, OldQuery.getDefault()));
    }
}

