/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.HashSet;
import java.util.Set;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ObjectState;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class GetAllWritableProjectsDatabaseAction
extends BimDatabaseAction<Set<Project>> {
    private Authorization authorization;

    public GetAllWritableProjectsDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, Authorization authorization) {
        super(databaseSession, accessMethod);
        this.authorization = authorization;
    }

    @Override
    public Set<Project> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        User user = this.getUserByUoid(this.authorization.getUoid());
        IfcModelInterface projectsModel = this.getDatabaseSession().getAllOfType(StorePackage.eINSTANCE.getProject(), OldQuery.getDefault());
        HashSet<Project> result = new HashSet<Project>();
        for (IdEObject idEObject : projectsModel.getValues()) {
            Project project;
            if (!(idEObject instanceof Project) || (project = (Project)idEObject).getName().equals("INT-Store") || user.getUserType() != UserType.ADMIN && (project.getState() != ObjectState.ACTIVE || !this.authorization.hasRightsOnProjectOrSuperProjects(user, project))) continue;
            result.add(project);
        }
        return result;
    }
}

