/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.interfaces.objects.SPluginBundle;
import org.bimserver.interfaces.objects.SPluginBundleType;
import org.bimserver.interfaces.objects.SPluginBundleVersion;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.plugins.GitHubPluginLocation;
import org.bimserver.plugins.GitHubPluginRepository;
import org.bimserver.plugins.GitHubPluginVersion;
import org.bimserver.plugins.MavenDependency;
import org.bimserver.plugins.MavenPluginLocation;
import org.bimserver.plugins.MavenPluginVersion;
import org.bimserver.plugins.PluginBundle;
import org.bimserver.plugins.PluginLocation;
import org.bimserver.plugins.PluginVersion;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAvailablePluginBundles
extends BimDatabaseAction<List<SPluginBundle>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetAvailablePluginBundles.class);
    private BimServer bimServer;
    private boolean strictVersionChecking;
    private DefaultArtifactVersion bimserverVersion;

    public GetAvailablePluginBundles(DatabaseSession databaseSession, AccessMethod accessMethod, BimServer bimServer, boolean strictVersionChecking) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.strictVersionChecking = strictVersionChecking;
    }

    @Override
    public List<SPluginBundle> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException, ServerException {
        ArrayList<SPluginBundle> result = new ArrayList<SPluginBundle>();
        GitHubPluginRepository repository = new GitHubPluginRepository(this.bimServer.getMavenPluginRepository(), this.bimServer.getServerSettingsCache().getServerSettings().getServiceRepositoryUrl());
        this.bimserverVersion = new DefaultArtifactVersion(this.bimServer.getVersionChecker().getLocalVersion().getFullString());
        for (PluginLocation<?> pluginLocation : repository.listPluginLocations()) {
            GitHubPluginLocation gitHubPluginLocation;
            SPluginBundle processMavenPluginLocation;
            PluginBundle pluginBundle = this.bimServer.getPluginManager().getPluginBundle(pluginLocation.getPluginIdentifier());
            if (pluginBundle != null) continue;
            if (pluginLocation instanceof MavenPluginLocation) {
                MavenPluginLocation mavenPluginLocation = (MavenPluginLocation)pluginLocation;
                processMavenPluginLocation = GetAvailablePluginBundles.processMavenPluginLocation(mavenPluginLocation, this.strictVersionChecking, (ArtifactVersion)this.bimserverVersion);
                if (processMavenPluginLocation == null) continue;
                result.add(processMavenPluginLocation);
                continue;
            }
            if (!(pluginLocation instanceof GitHubPluginLocation) || (processMavenPluginLocation = GetAvailablePluginBundles.processGitHubPluginLocation(gitHubPluginLocation = (GitHubPluginLocation)pluginLocation, this.strictVersionChecking, this.bimserverVersion)) == null) continue;
            result.add(processMavenPluginLocation);
        }
        return result;
    }

    public static SPluginBundle processPluginLocation(PluginLocation<?> pluginLocation, boolean strictVersionChecking, DefaultArtifactVersion bimserverVersion) {
        if (pluginLocation instanceof MavenPluginLocation) {
            return GetAvailablePluginBundles.processMavenPluginLocation((MavenPluginLocation)pluginLocation, strictVersionChecking, (ArtifactVersion)bimserverVersion);
        }
        if (pluginLocation instanceof GitHubPluginLocation) {
            return GetAvailablePluginBundles.processGitHubPluginLocation((GitHubPluginLocation)pluginLocation, strictVersionChecking, bimserverVersion);
        }
        return null;
    }

    public static SPluginBundle processGitHubPluginLocation(GitHubPluginLocation gitHubPluginLocation, boolean strictVersionChecking2, DefaultArtifactVersion bimserverVersion2) {
        SPluginBundle pluginUpdateInformation = new SPluginBundle();
        boolean usefulBundle = false;
        for (GitHubPluginVersion pluginVersion : gitHubPluginLocation.getAllVersions()) {
            SPluginBundleVersion sPluginVersion = new SPluginBundleVersion();
            boolean useful = true;
            if (!useful) continue;
            usefulBundle = true;
            sPluginVersion.setArtifactId(gitHubPluginLocation.getArtifactId());
            sPluginVersion.setGroupId(gitHubPluginLocation.getGroupId());
            sPluginVersion.setRepository(gitHubPluginLocation.getRepository());
            sPluginVersion.setType(SPluginBundleType.MAVEN);
            sPluginVersion.setVersion(pluginVersion.getVersion());
            sPluginVersion.setDescription(pluginVersion.getDescription());
            pluginUpdateInformation.setName(pluginVersion.getName());
            pluginUpdateInformation.setOrganization(pluginVersion.getOrganization());
            pluginUpdateInformation.setLatestVersion(sPluginVersion);
            pluginUpdateInformation.getAvailableVersions().add(sPluginVersion);
        }
        if (usefulBundle) {
            return pluginUpdateInformation;
        }
        return null;
    }

    public static SPluginBundle processMavenPluginLocation(MavenPluginLocation mavenPluginLocation, boolean strictVersionChecking, ArtifactVersion bimserverVersion) {
        SPluginBundle pluginUpdateInformation = new SPluginBundle();
        boolean usefulBundle = false;
        for (PluginVersion pluginVersion : mavenPluginLocation.getAllVersions()) {
            if (!(pluginVersion instanceof MavenPluginVersion)) continue;
            SPluginBundleVersion sPluginVersion = new SPluginBundleVersion();
            boolean useful = true;
            MavenPluginVersion mavenPluginVersion = (MavenPluginVersion)pluginVersion;
            for (MavenDependency mavenDependency : mavenPluginVersion.getDependencies()) {
                VersionRange versionRange;
                String artifactId;
                if (!mavenDependency.getArtifact().getGroupId().equals("org.opensourcebim") || !(artifactId = mavenDependency.getArtifact().getArtifactId()).equals("shared") && !artifactId.equals("pluginbase") || (versionRange = VersionRange.createFromVersion((String)mavenDependency.getArtifact().getVersion())).containsVersion(bimserverVersion)) continue;
                sPluginVersion.setMismatch(true);
                if (!strictVersionChecking) continue;
                useful = false;
                LOGGER.info("Skipping version " + mavenPluginVersion.getArtifact().getVersion() + " or artifact " + mavenPluginVersion.getArtifact().getArtifactId());
            }
            if (!useful) continue;
            usefulBundle = true;
            sPluginVersion.setArtifactId(mavenPluginLocation.getArtifactId());
            sPluginVersion.setGroupId(mavenPluginLocation.getGroupId());
            sPluginVersion.setRepository(mavenPluginLocation.getRepository());
            sPluginVersion.setType(SPluginBundleType.MAVEN);
            sPluginVersion.setVersion(mavenPluginVersion.getVersion().toString());
            sPluginVersion.setDescription(mavenPluginVersion.getModel().getDescription());
            pluginUpdateInformation.setName(mavenPluginVersion.getModel().getName());
            pluginUpdateInformation.setOrganization(mavenPluginVersion.getModel().getOrganization().getName());
            pluginUpdateInformation.setLatestVersion(sPluginVersion);
            pluginUpdateInformation.getAvailableVersions().add(sPluginVersion);
        }
        if (usefulBundle) {
            return pluginUpdateInformation;
        }
        return null;
    }
}

