/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.HashSet;
import java.util.Set;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.Checkout;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class GetCheckoutWarningsDatabaseAction
extends BimDatabaseAction<Set<String>> {
    private final long poid;
    private Authorization authorization;

    public GetCheckoutWarningsDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, long poid, Authorization authorization) {
        super(databaseSession, accessMethod);
        this.poid = poid;
        this.authorization = authorization;
    }

    @Override
    public Set<String> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        Project project = this.getProjectByPoid(this.poid);
        User user = this.getUserByUoid(this.authorization.getUoid());
        HashSet<String> warnings = new HashSet<String>();
        this.checkOtherUsersCheckouts(project, user, warnings);
        return warnings;
    }

    public void checkOtherUsersCheckouts(Project project, User user, Set<String> warnings) {
        int activeCheckouts = 0;
        for (Project p : this.getAllRelatedProjects(project)) {
            for (Checkout checkout : p.getCheckouts()) {
                if (!checkout.getActive().booleanValue() || checkout.getUser() == user) continue;
                ++activeCheckouts;
            }
        }
        if (activeCheckouts == 1) {
            warnings.add("Warning, another user is possibly working on this model because there is one active checkout");
        } else if (activeCheckouts > 1) {
            warnings.add("Warning, other users are possibly working on this model because there are " + activeCheckouts + " active checkouts");
        }
    }

    private Set<Project> getAllRelatedProjects(Project project) {
        HashSet<Project> projects = new HashSet<Project>();
        this.getAllRelatedProjects(projects, project);
        return projects;
    }

    private void getAllRelatedProjects(Set<Project> projects, Project project) {
        if (projects.contains(project)) {
            return;
        }
        projects.add(project);
        if (project.getParent() != null) {
            this.getAllRelatedProjects(projects, project.getParent());
        }
        for (Project subProject : project.getSubProjects()) {
            this.getAllRelatedProjects(projects, subProject);
        }
    }
}

