/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.ObjectIdentifier;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.actions.GetDataObjectByOidDatabaseAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.DataObject;
import org.bimserver.models.store.Revision;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class GetDataObjectByGuidDatabaseAction
extends BimDatabaseAction<DataObject> {
    private final String guid;
    private final long roid;
    private final BimServer bimServer;
    private Authorization authorization;

    public GetDataObjectByGuidDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, long roid, String guid, Authorization authorization) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.roid = roid;
        this.guid = guid;
        this.authorization = authorization;
    }

    @Override
    public DataObject execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        Revision virtualRevision = this.getRevisionByRoid(this.roid);
        ObjectIdentifier objectIdentifier = null;
        for (ConcreteRevision concreteRevision : virtualRevision.getConcreteRevisions()) {
            long oidOfGuid;
            objectIdentifier = this.getDatabaseSession().getOidOfGuid(concreteRevision.getProject().getSchema(), this.guid, concreteRevision.getProject().getId(), concreteRevision.getId());
            if (objectIdentifier == null || (oidOfGuid = objectIdentifier.getOid()) == -1L) continue;
            break;
        }
        if (objectIdentifier == null) {
            throw new UserException("Guid " + this.guid + " not found in this revision/project");
        }
        return new GetDataObjectByOidDatabaseAction(this.bimServer, this.getDatabaseSession(), this.getAccessMethod(), this.roid, objectIdentifier.getOid(), this.authorization).execute();
    }
}

