/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import com.google.common.base.Charsets;
import com.google.common.collect.BiMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AbstractDownloadDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IdEObjectImpl;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.ifc.BasicIfcModel;
import org.bimserver.models.ifc2x3tc1.IfcRoot;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.DataObject;
import org.bimserver.models.store.ListDataValue;
import org.bimserver.models.store.ReferenceDataValue;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.SimpleDataValue;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.plugins.IfcModelSet;
import org.bimserver.plugins.ModelHelper;
import org.bimserver.plugins.modelmerger.MergeException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public class GetDataObjectByOidDatabaseAction
extends AbstractDownloadDatabaseAction<DataObject> {
    private final long oid;
    private final long roid;

    public GetDataObjectByOidDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, long roid, long oid, Authorization authorization) {
        super(bimServer, databaseSession, accessMethod, authorization);
        this.roid = roid;
        this.oid = oid;
    }

    @Override
    public DataObject execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        Revision virtualRevision = this.getRevisionByRoid(this.roid);
        EObject eObject = null;
        IfcModelSet ifcModelSet = new IfcModelSet(new IfcModelInterface[0]);
        PackageMetaData lastPackageMetaData = null;
        HashMap<Integer, Long> pidRoidMap = new HashMap<Integer, Long>();
        pidRoidMap.put(virtualRevision.getProject().getId(), virtualRevision.getOid());
        for (ConcreteRevision concreteRevision : virtualRevision.getConcreteRevisions()) {
            PackageMetaData packageMetaData;
            lastPackageMetaData = packageMetaData = this.getBimServer().getMetaDataManager().getPackageMetaData(concreteRevision.getProject().getSchema());
            BasicIfcModel subModel = new BasicIfcModel(packageMetaData, pidRoidMap);
            int highestStopId = GetDataObjectByOidDatabaseAction.findHighestStopRid(concreteRevision.getProject(), concreteRevision);
            OldQuery query = new OldQuery(packageMetaData, concreteRevision.getProject().getId(), concreteRevision.getId(), virtualRevision.getOid(), null, OldQuery.Deep.NO, highestStopId);
            eObject = (EObject)this.getDatabaseSession().get(null, this.oid, (IfcModelInterface)subModel, (QueryInterface)query);
            subModel.getModelMetaData().setDate(concreteRevision.getDate());
            ifcModelSet.add((Object)subModel);
            if (eObject == null) continue;
            break;
        }
        BasicIfcModel ifcModel = new BasicIfcModel(lastPackageMetaData, pidRoidMap);
        try {
            ifcModel = this.getBimServer().getMergerFactory().createMerger(this.getDatabaseSession(), this.getAuthorization().getUoid()).merge(virtualRevision.getProject(), ifcModelSet, new ModelHelper(this.getBimServer().getMetaDataManager(), (IfcModelInterface)ifcModel));
        }
        catch (MergeException e) {
            throw new UserException((Throwable)e);
        }
        if (eObject == null) {
            throw new UserException("Object not found in this project/revision");
        }
        DataObject dataObject = null;
        if (eObject instanceof IfcRoot) {
            IfcRoot ifcRoot = (IfcRoot)eObject;
            String guid = ifcRoot.getGlobalId() != null ? ifcRoot.getGlobalId() : "";
            String name = ifcRoot.getName() != null ? ifcRoot.getName() : "";
            dataObject = StoreFactory.eINSTANCE.createDataObject();
            dataObject.setType(eObject.eClass().getName());
            ((IdEObjectImpl)dataObject).setOid(this.oid);
            dataObject.setGuid(guid);
            dataObject.setName(name);
        } else {
            dataObject = StoreFactory.eINSTANCE.createDataObject();
            dataObject.setType(eObject.eClass().getName());
            ((IdEObjectImpl)dataObject).setOid(this.oid);
            dataObject.setName("");
            dataObject.setGuid("");
        }
        GetDataObjectByOidDatabaseAction.fillDataObject((BiMap<? extends Long, ? extends EObject>)ifcModel.getObjects(), eObject, dataObject);
        return dataObject;
    }

    public static void fillDataObject(BiMap<? extends Long, ? extends EObject> mapResult, EObject eObject, DataObject dataObject) {
        for (EStructuralFeature eStructuralFeature : eObject.eClass().getEAllStructuralFeatures()) {
            Iterator list;
            Object eGet = eObject.eGet(eStructuralFeature);
            if (eStructuralFeature.getEAnnotation("hidden") != null) continue;
            if (eStructuralFeature instanceof EAttribute) {
                if (eStructuralFeature.isMany()) {
                    ListDataValue listDataValue = StoreFactory.eINSTANCE.createListDataValue();
                    listDataValue.setFieldName(eStructuralFeature.getName());
                    dataObject.getValues().add((Object)listDataValue);
                    if (eStructuralFeature.getEType() == EcorePackage.eINSTANCE.getEDoubleObject() || eStructuralFeature.getEType() == EcorePackage.eINSTANCE.getEDouble()) {
                        EStructuralFeature asStringFeature = eObject.eClass().getEStructuralFeature(eStructuralFeature.getName() + "AsString");
                        list = (List)eObject.eGet(asStringFeature);
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            Object o = iterator.next();
                            SimpleDataValue dataValue = StoreFactory.eINSTANCE.createSimpleDataValue();
                            dataValue.setStringValue(o.toString());
                            listDataValue.getValues().add((Object)dataValue);
                        }
                        continue;
                    }
                    if (eGet == null) continue;
                    List list2 = (List)eGet;
                    for (Object o : list2) {
                        SimpleDataValue dataValue = StoreFactory.eINSTANCE.createSimpleDataValue();
                        if (eGet != null) {
                            dataValue.setStringValue(o.toString());
                        } else {
                            dataValue.setStringValue(null);
                        }
                        listDataValue.getValues().add((Object)dataValue);
                    }
                    continue;
                }
                SimpleDataValue dataValue = StoreFactory.eINSTANCE.createSimpleDataValue();
                if (eGet != null) {
                    if (eGet instanceof byte[]) {
                        dataValue.setStringValue(new String((byte[])eGet, Charsets.UTF_8));
                    } else {
                        dataValue.setStringValue(eGet.toString());
                    }
                } else {
                    dataValue.setStringValue(null);
                }
                dataValue.setFieldName(eStructuralFeature.getName());
                dataObject.getValues().add((Object)dataValue);
                continue;
            }
            if (!(eStructuralFeature instanceof EReference)) continue;
            if (eStructuralFeature.isMany()) {
                ListDataValue dataValue;
                Object list3;
                if (eStructuralFeature.getEType() == EcorePackage.eINSTANCE.getEDouble() || eStructuralFeature.getEType() == EcorePackage.eINSTANCE.getEDoubleObject()) {
                    list3 = (List)eObject.eGet(eObject.eClass().getEStructuralFeature(eStructuralFeature.getName() + "AsString"));
                    dataValue = StoreFactory.eINSTANCE.createListDataValue();
                    dataValue.setFieldName(eStructuralFeature.getName());
                    dataObject.getValues().add((Object)dataValue);
                    list = list3.iterator();
                    while (list.hasNext()) {
                        Object o;
                        o = list.next();
                        SimpleDataValue simpleDataValue = StoreFactory.eINSTANCE.createSimpleDataValue();
                        simpleDataValue.setStringValue(o.toString());
                        dataValue.getValues().add((Object)simpleDataValue);
                    }
                    continue;
                }
                list3 = (EList)eGet;
                dataValue = StoreFactory.eINSTANCE.createListDataValue();
                dataObject.getValues().add((Object)dataValue);
                dataValue.setFieldName(eStructuralFeature.getName());
                list = list3.iterator();
                while (list.hasNext()) {
                    EObject item = (EObject)list.next();
                    if (item.eClass().getEAnnotation("wrapped") != null) {
                        EObject referenceEObject = item;
                        SimpleDataValue simpleDataValue = StoreFactory.eINSTANCE.createSimpleDataValue();
                        simpleDataValue.setStringValue(referenceEObject.eGet(referenceEObject.eClass().getEStructuralFeature("wrappedValue")).toString());
                        dataValue.getValues().add((Object)simpleDataValue);
                        continue;
                    }
                    Long oid = ((IdEObject)item).getOid();
                    ReferenceDataValue referenceDataValue = StoreFactory.eINSTANCE.createReferenceDataValue();
                    if (item instanceof IfcRoot) {
                        IfcRoot ifcRoot = (IfcRoot)item;
                        String guid = ifcRoot.getGlobalId();
                        referenceDataValue.setGuid(guid);
                    }
                    referenceDataValue.setTypeName(item.eClass().getName());
                    ((IdEObjectImpl)referenceDataValue).setOid(oid.longValue());
                    dataValue.getValues().add((Object)referenceDataValue);
                }
                continue;
            }
            EObject eObject2 = (EObject)eGet;
            if (eObject2 == null) continue;
            if (eObject2.eClass().getEAnnotation("wrapped") != null) {
                EObject referenceEObject = (EObject)eGet;
                SimpleDataValue e = StoreFactory.eINSTANCE.createSimpleDataValue();
                EStructuralFeature wrappedValueFeature = referenceEObject.eClass().getEStructuralFeature("wrappedValue");
                Object eGet2 = referenceEObject.eGet(wrappedValueFeature);
                if (eGet2 != null) {
                    e.setStringValue(eGet2.toString());
                } else {
                    e.setStringValue(null);
                }
                e.setFieldName(eStructuralFeature.getName());
                dataObject.getValues().add((Object)e);
                continue;
            }
            Long oid = ((IdEObject)eObject2).getOid();
            ReferenceDataValue reference = StoreFactory.eINSTANCE.createReferenceDataValue();
            if (eObject2 instanceof IfcRoot) {
                IfcRoot ifcRoot = (IfcRoot)eObject2;
                String guid = ifcRoot.getGlobalId();
                reference.setGuid(guid);
            }
            reference.setTypeName(eObject2.eClass().getName());
            ((IdEObjectImpl)reference).setOid(oid.longValue());
            reference.setFieldName(eStructuralFeature.getName());
            dataObject.getValues().add((Object)reference);
        }
    }
}

