/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.ServerIfcModel;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AbstractDownloadDatabaseAction;
import org.bimserver.database.actions.GetDataObjectByOidDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IdEObjectImpl;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.ifc2x3tc1.IfcRoot;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.DataObject;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.plugins.IfcModelSet;
import org.bimserver.plugins.ModelHelper;
import org.bimserver.plugins.modelmerger.MergeException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class GetDataObjectsByTypeDatabaseAction
extends AbstractDownloadDatabaseAction<List<DataObject>> {
    private final String className;
    private final long roid;
    private boolean flat;
    private String packageName;

    public GetDataObjectsByTypeDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, long roid, String packageName, String className, Authorization authorization, boolean flat) {
        super(bimServer, databaseSession, accessMethod, authorization);
        this.roid = roid;
        this.packageName = packageName;
        this.className = className;
        this.flat = flat;
    }

    @Override
    public List<DataObject> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        EClass eClass = this.getDatabaseSession().getEClassForName(this.packageName, this.className);
        Revision virtualRevision = this.getRevisionByRoid(this.roid);
        if (virtualRevision == null) {
            throw new UserException("No revision with roid " + this.roid + " found");
        }
        HashMap<Integer, Long> pidRoidMap = new HashMap<Integer, Long>();
        IfcModelSet ifcModelSet = new IfcModelSet(new IfcModelInterface[0]);
        pidRoidMap.put(virtualRevision.getProject().getId(), virtualRevision.getOid());
        PackageMetaData lastPackageMetaData = null;
        Project project = virtualRevision.getProject();
        for (ConcreteRevision concreteRevision : virtualRevision.getConcreteRevisions()) {
            PackageMetaData packageMetaData = this.getBimServer().getMetaDataManager().getPackageMetaData(concreteRevision.getProject().getSchema());
            int highestStopId = GetDataObjectsByTypeDatabaseAction.findHighestStopRid(project, concreteRevision);
            OldQuery query = new OldQuery(packageMetaData, concreteRevision.getProject().getId(), concreteRevision.getId(), -1L, null, OldQuery.Deep.NO, highestStopId);
            lastPackageMetaData = packageMetaData;
            IfcModelInterface subModel = this.getDatabaseSession().getAllOfType(packageMetaData.getEPackage().getName(), this.className, (QueryInterface)query);
            subModel.getModelMetaData().setDate(concreteRevision.getDate());
            ifcModelSet.add((Object)subModel);
        }
        ServerIfcModel ifcModel = new ServerIfcModel(lastPackageMetaData, pidRoidMap, this.getDatabaseSession());
        try {
            ifcModel = this.getBimServer().getMergerFactory().createMerger(this.getDatabaseSession(), this.getAuthorization().getUoid()).merge(project, ifcModelSet, new ModelHelper(this.getBimServer().getMetaDataManager(), (IfcModelInterface)ifcModel));
        }
        catch (MergeException e) {
            throw new UserException((Throwable)e);
        }
        ArrayList<DataObject> dataObjects = new ArrayList<DataObject>();
        for (Long oid : ifcModel.keySet()) {
            IdEObject eObject = ifcModel.get(oid);
            if (!eClass.isInstance((Object)eObject)) continue;
            DataObject dataObject = StoreFactory.eINSTANCE.createDataObject();
            if (eObject instanceof IfcRoot) {
                IfcRoot ifcRoot = (IfcRoot)eObject;
                String guid = ifcRoot.getGlobalId() != null ? ifcRoot.getGlobalId() : "";
                String name = ifcRoot.getName() != null ? ifcRoot.getName() : "";
                dataObject = StoreFactory.eINSTANCE.createDataObject();
                dataObject.setType(eObject.eClass().getName());
                ((IdEObjectImpl)dataObject).setOid(oid.longValue());
                dataObject.setGuid(guid);
                dataObject.setName(name);
            } else {
                dataObject = StoreFactory.eINSTANCE.createDataObject();
                dataObject.setType(eObject.eClass().getName());
                ((IdEObjectImpl)dataObject).setOid(oid.longValue());
                dataObject.setGuid("");
                dataObject.setName("");
            }
            if (!this.flat) {
                GetDataObjectByOidDatabaseAction.fillDataObject((BiMap<? extends Long, ? extends EObject>)ifcModel.getObjects(), (EObject)eObject, dataObject);
            }
            dataObjects.add(dataObject);
        }
        return dataObjects;
    }
}

