/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.ServerIfcModel;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AbstractDownloadDatabaseAction;
import org.bimserver.database.actions.GetDataObjectByOidDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IdEObjectImpl;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.models.ifc2x3tc1.IfcRoot;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.DataObject;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.plugins.IfcModelSet;
import org.bimserver.plugins.ModelHelper;
import org.bimserver.plugins.modelmerger.MergeException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;
import org.eclipse.emf.ecore.EObject;

public class GetDataObjectsDatabaseAction
extends AbstractDownloadDatabaseAction<List<DataObject>> {
    private final long roid;

    public GetDataObjectsDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, BimServer bimServer, long roid, Authorization authorization) {
        super(bimServer, databaseSession, accessMethod, authorization);
        this.roid = roid;
    }

    @Override
    public List<DataObject> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        Revision virtualRevision = this.getRevisionByRoid(this.roid);
        IfcModelSet ifcModelSet = new IfcModelSet(new IfcModelInterface[0]);
        PackageMetaData lastPackageMetaData = null;
        HashMap<Integer, Long> pidRoidMap = new HashMap<Integer, Long>();
        pidRoidMap.put(virtualRevision.getProject().getId(), virtualRevision.getOid());
        for (ConcreteRevision concreteRevision : virtualRevision.getConcreteRevisions()) {
            PackageMetaData packageMetaData;
            int highestStopId = GetDataObjectsDatabaseAction.findHighestStopRid(concreteRevision.getProject(), concreteRevision);
            lastPackageMetaData = packageMetaData = this.getBimServer().getMetaDataManager().getPackageMetaData(concreteRevision.getProject().getSchema());
            ServerIfcModel subModel = new ServerIfcModel(packageMetaData, pidRoidMap, this.getDatabaseSession());
            OldQuery query = new OldQuery(packageMetaData, concreteRevision.getProject().getId(), concreteRevision.getId(), virtualRevision.getOid(), null, OldQuery.Deep.YES, highestStopId);
            this.getDatabaseSession().getMap((IfcModelInterface)subModel, query);
            subModel.getModelMetaData().setDate(concreteRevision.getDate());
            ifcModelSet.add((Object)subModel);
        }
        ServerIfcModel ifcModel = new ServerIfcModel(lastPackageMetaData, pidRoidMap, this.getDatabaseSession());
        try {
            ifcModel = this.getBimServer().getMergerFactory().createMerger(this.getDatabaseSession(), this.getAuthorization().getUoid()).merge(virtualRevision.getProject(), ifcModelSet, new ModelHelper(this.getBimServer().getMetaDataManager(), (IfcModelInterface)ifcModel));
        }
        catch (MergeException e) {
            throw new UserException((Throwable)e);
        }
        ArrayList<DataObject> dataObjects = new ArrayList<DataObject>();
        for (Long oid : ifcModel.keySet()) {
            IdEObject eObject = ifcModel.get(oid);
            if (eObject.eClass().getEAnnotation("hidden") != null) continue;
            DataObject dataObject = null;
            if (eObject instanceof IfcRoot) {
                IfcRoot ifcRoot = (IfcRoot)eObject;
                String guid = ifcRoot.getGlobalId() != null ? ifcRoot.getGlobalId() : "";
                String name = ifcRoot.getName() != null ? ifcRoot.getName() : "";
                dataObject = StoreFactory.eINSTANCE.createDataObject();
                dataObject.setType(eObject.eClass().getName());
                ((IdEObjectImpl)dataObject).setOid(oid.longValue());
                dataObject.setGuid(guid);
                dataObject.setName(name);
            } else {
                dataObject = StoreFactory.eINSTANCE.createDataObject();
                dataObject.setType(eObject.eClass().getName());
                ((IdEObjectImpl)dataObject).setOid(oid.longValue());
                dataObject.setGuid("");
                dataObject.setName("");
            }
            GetDataObjectByOidDatabaseAction.fillDataObject((BiMap<? extends Long, ? extends EObject>)ifcModel.getObjects(), (EObject)eObject, dataObject);
            dataObjects.add(dataObject);
        }
        return dataObjects;
    }
}

