/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.actions.GetAvailablePluginBundles;
import org.bimserver.interfaces.objects.SPluginBundle;
import org.bimserver.interfaces.objects.SPluginBundleVersion;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.plugins.GitHubPluginRepository;
import org.bimserver.plugins.PluginBundle;
import org.bimserver.plugins.PluginBundleIdentifier;
import org.bimserver.plugins.PluginLocation;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetInstalledPluginBundles
extends BimDatabaseAction<List<SPluginBundle>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetInstalledPluginBundles.class);
    private BimServer bimServer;
    private boolean strictVersionChecking;
    private DefaultArtifactVersion bimserverVersion;

    public GetInstalledPluginBundles(DatabaseSession databaseSession, AccessMethod accessMethod, BimServer bimServer, boolean strictVersionChecking) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.strictVersionChecking = strictVersionChecking;
    }

    @Override
    public List<SPluginBundle> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException, ServerException {
        ArrayList<SPluginBundle> result = new ArrayList<SPluginBundle>();
        this.bimserverVersion = new DefaultArtifactVersion(this.bimServer.getVersionChecker().getLocalVersion().getFullString());
        GitHubPluginRepository repository = new GitHubPluginRepository(this.bimServer.getMavenPluginRepository(), this.bimServer.getServerSettingsCache().getServerSettings().getServiceRepositoryUrl());
        HashMap repositoryKnownLocation = new HashMap();
        for (PluginLocation<?> pluginLocation : repository.listPluginLocations()) {
            repositoryKnownLocation.put(pluginLocation.getPluginIdentifier(), pluginLocation);
        }
        for (PluginBundle pluginBundle : this.bimServer.getPluginManager().getPluginBundles()) {
            SPluginBundleVersion installedVersion = pluginBundle.getPluginBundleVersion();
            PluginBundleIdentifier pluginBundleIdentifier = new PluginBundleIdentifier(installedVersion.getGroupId(), installedVersion.getArtifactId());
            if (!repositoryKnownLocation.containsKey(pluginBundleIdentifier)) continue;
            PluginLocation pluginLocation = (PluginLocation)repositoryKnownLocation.get(pluginBundleIdentifier);
            SPluginBundle sPluginBundle = GetAvailablePluginBundles.processPluginLocation(pluginLocation, this.strictVersionChecking, this.bimserverVersion);
            if (sPluginBundle == null) {
                sPluginBundle = pluginBundle.getPluginBundle();
            }
            if (!sPluginBundle.getAvailableVersions().contains(pluginBundle.getPluginBundleVersion())) {
                sPluginBundle.getAvailableVersions().add(pluginBundle.getPluginBundleVersion());
            }
            sPluginBundle.setInstalledVersion(installedVersion);
            result.add(sPluginBundle);
        }
        return result;
    }
}

