/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.ArrayList;
import java.util.List;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ObjectState;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class GetProjectsOfUserDatabaseAction
extends BimDatabaseAction<List<Project>> {
    private long uoid;
    private Authorization authorization;

    public GetProjectsOfUserDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, Authorization authorization, long uoid) {
        super(databaseSession, accessMethod);
        this.authorization = authorization;
        this.uoid = uoid;
    }

    @Override
    public List<Project> execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        User actingUser = this.getUserByUoid(this.authorization.getUoid());
        if (actingUser.getUserType() == UserType.ADMIN || this.authorization.getUoid() == this.uoid) {
            User user = this.getUserByUoid(this.uoid);
            if (user != null) {
                ArrayList<Project> result = new ArrayList<Project>();
                for (Project project : user.getHasRightsOn()) {
                    if (project.getState() != ObjectState.ACTIVE && actingUser.getUserType() != UserType.ADMIN) continue;
                    result.add(project);
                }
                return result;
            }
            throw new UserException("User with id " + this.uoid + " does not exist");
        }
        throw new UserException("No rights");
    }
}

