/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.security.SecureRandom;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.bimserver.Authenticator;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.actions.GetUserByUserNameDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ObjectState;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.ServiceMap;
import org.bimserver.webservices.authorization.AdminAuthorization;
import org.bimserver.webservices.authorization.Authorization;
import org.bimserver.webservices.authorization.UserAuthorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginDatabaseAction
extends BimDatabaseAction<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginDatabaseAction.class);
    public static final Integer DEFAULT_LOGIN_ERROR_TIMEOUT = 2000;
    private final String username;
    private final String password;
    private BimServer bimServer;
    private ServiceMap serviceMap;

    public LoginDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, ServiceMap serviceMap, AccessMethod accessMethod, String username, String password) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.serviceMap = serviceMap;
        this.username = username;
        this.password = password;
    }

    @Override
    public String execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException, ServerException {
        GetUserByUserNameDatabaseAction action = new GetUserByUserNameDatabaseAction(this.getDatabaseSession(), this.getAccessMethod(), this.username);
        User user = (User)((BimDatabaseAction)action).execute();
        if (user != null) {
            if (user.getPasswordHash() == null || user.getPasswordHash().length == 0) {
                throw new UserException("Your email address has not been validated yet");
            }
            if (new Authenticator().validate(this.password, user.getPasswordHash(), user.getPasswordSalt())) {
                if (user.getState() == ObjectState.DELETED) {
                    throw new UserException("User account has been deleted");
                }
                if (user.getUserType() == UserType.SYSTEM) {
                    throw new UserException("System user cannot login");
                }
                Authorization authorization = null;
                authorization = user.getUserType() == UserType.ADMIN ? new AdminAuthorization(this.bimServer.getServerSettingsCache().getServerSettings().getSessionTimeOutSeconds(), TimeUnit.SECONDS) : new UserAuthorization(this.bimServer.getServerSettingsCache().getServerSettings().getSessionTimeOutSeconds(), TimeUnit.SECONDS);
                authorization.setUoid(user.getOid());
                String asHexToken = authorization.asHexToken(this.bimServer.getEncryptionKey());
                this.serviceMap.setAuthorization(authorization);
                user.setLastSeen(new Date());
                this.getDatabaseSession().store((IdEObject)user);
                return asHexToken;
            }
        }
        try {
            Thread.sleep(DEFAULT_LOGIN_ERROR_TIMEOUT + new SecureRandom().nextInt(1000));
        }
        catch (InterruptedException e) {
            LOGGER.error("", (Throwable)e);
        }
        throw new UserException("Invalid username/password combination");
    }
}

