/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Date;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.PostCommitAction;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.interfaces.SConverter;
import org.bimserver.interfaces.objects.SLogAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.UserRemovedFromProject;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class RemoveUserFromProjectDatabaseAction
extends BimDatabaseAction<Boolean> {
    private final long uoid;
    private final long poid;
    private Authorization authorization;
    private BimServer bimServer;

    public RemoveUserFromProjectDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, long uoid, long poid, Authorization authorization) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.uoid = uoid;
        this.poid = poid;
        this.authorization = authorization;
    }

    @Override
    public Boolean execute() throws UserException, BimserverDatabaseException, BimserverLockConflictException {
        User user = this.getUserByUoid(this.uoid);
        Project project = this.getProjectByPoid(this.poid);
        User actingUser = this.getUserByUoid(this.authorization.getUoid());
        if (this.authorization.hasRightsOnProject(actingUser, project)) {
            if (user.getUserType() == UserType.ADMIN) {
                int nrAdmins = 0;
                for (User authUser : project.getHasAuthorizedUsers()) {
                    if (authUser.getUserType() != UserType.ADMIN) continue;
                    ++nrAdmins;
                }
                if (nrAdmins == 1) {
                    throw new UserException("User cannot be removed from this project because it is the only admin user with authorization on this project");
                }
            }
            project.getHasAuthorizedUsers().remove((Object)user);
            user.getHasRightsOn().remove((Object)project);
            final UserRemovedFromProject userRemovedFromProject = this.getDatabaseSession().create(UserRemovedFromProject.class);
            userRemovedFromProject.setDate(new Date());
            userRemovedFromProject.setExecutor(actingUser);
            userRemovedFromProject.setAccessMethod(this.getAccessMethod());
            userRemovedFromProject.setProject(project);
            userRemovedFromProject.setUser(user);
            this.getDatabaseSession().addPostCommitAction(new PostCommitAction(){

                @Override
                public void execute() throws UserException {
                    RemoveUserFromProjectDatabaseAction.this.bimServer.getNotificationsManager().notify((SLogAction)new SConverter().convertToSObject(userRemovedFromProject));
                }
            });
            this.getDatabaseSession().store((IdEObject)user);
            this.getDatabaseSession().store((IdEObject)project);
            return true;
        }
        throw new UserException("Insufficient rights to remove user from project");
    }
}

