/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.GenerateGeometryResult;
import org.bimserver.StreamingGeometryGenerator;
import org.bimserver.SummaryMap;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.PostCommitAction;
import org.bimserver.database.actions.CreateRevisionResult;
import org.bimserver.database.actions.GenericCheckinDatabaseAction;
import org.bimserver.database.actions.ProgressListener;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.om.Query;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.mail.MailSystem;
import org.bimserver.models.geometry.GeometryPackage;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.NewRevisionAdded;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.IfcHeader;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.Service;
import org.bimserver.models.store.User;
import org.bimserver.notifications.NewRevisionNotification;
import org.bimserver.plugins.deserializers.DatabaseInterface;
import org.bimserver.plugins.deserializers.StreamingDeserializer;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.QueryContext;
import org.bimserver.shared.QueryException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;
import org.bimserver.webservices.authorization.ExplicitRightsAuthorization;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingCheckinDatabaseAction
extends GenericCheckinDatabaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamingCheckinDatabaseAction.class);
    private final String comment;
    private final long poid;
    private final BimServer bimServer;
    private ConcreteRevision concreteRevision;
    private Project project;
    private Authorization authorization;
    private String fileName;
    private long fileSize;
    private InputStream inputStream;
    private StreamingDeserializer deserializer;

    public StreamingCheckinDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, long poid, Authorization authorization, String comment, String fileName, InputStream inputStream, StreamingDeserializer deserializer) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.poid = poid;
        this.authorization = authorization;
        this.comment = comment;
        this.fileName = fileName;
        this.inputStream = inputStream;
        this.deserializer = deserializer;
    }

    public HashMapVirtualObject getByOid(PackageMetaData packageMetaData, DatabaseSession databaseSession, long roid, long oid) throws JsonParseException, JsonMappingException, IOException, QueryException, BimserverDatabaseException {
        Query query = new Query("test", packageMetaData);
        QueryPart queryPart = query.createQueryPart();
        queryPart.addOid(oid);
        QueryObjectProvider queryObjectProvider = new QueryObjectProvider(databaseSession, this.bimServer, query, Collections.singleton(roid), packageMetaData);
        HashMapVirtualObject first = queryObjectProvider.next();
        return first;
    }

    @Override
    public ConcreteRevision execute() throws UserException, BimserverDatabaseException {
        try {
            ExplicitRightsAuthorization explicitRightsAuthorization;
            if (this.fileSize == -1L) {
                this.setProgress("Deserializing IFC file...", -1);
            } else {
                this.setProgress("Deserializing IFC file...", 0);
            }
            this.authorization.canCheckin(this.poid);
            this.project = this.getProjectByPoid(this.poid);
            int nrConcreteRevisionsBefore = this.project.getConcreteRevisions().size();
            User user = this.getUserByUoid(this.authorization.getUoid());
            if (this.project == null) {
                throw new UserException("Project with poid " + this.poid + " not found");
            }
            if (!this.authorization.hasRightsOnProjectOrSuperProjects(user, this.project)) {
                throw new UserException("User has no rights to checkin models to this project");
            }
            if (!MailSystem.isValidEmailAddress(user.getUsername())) {
                throw new UserException("Users must have a valid e-mail address to checkin");
            }
            PackageMetaData packageMetaData = this.bimServer.getMetaDataManager().getPackageMetaData("ifc2x3tc1");
            CreateRevisionResult result = this.createNewConcreteRevision(this.getDatabaseSession(), -1L, this.project, user, this.comment.trim());
            long newRoid = result.getRevisions().get(0).getOid();
            QueryContext queryContext = new QueryContext((DatabaseInterface)this.getDatabaseSession(), packageMetaData, result.getConcreteRevision().getProject().getId().intValue(), result.getConcreteRevision().getId().intValue(), newRoid, -1);
            long size = this.deserializer.read(this.inputStream, this.fileName, this.fileSize, queryContext);
            Set eClasses = this.deserializer.getSummaryMap().keySet();
            Map<EClass, Long> startOids = this.getDatabaseSession().getStartOids();
            HashMap<EClass, Long> oidCounters = new HashMap<EClass, Long>();
            int s = 0;
            for (Object eClass : eClasses) {
                if (DatabaseSession.perRecordVersioning((EClass)eClass)) continue;
                ++s;
            }
            ByteBuffer buffer = ByteBuffer.allocate(10 * s);
            for (EClass eClass : eClasses) {
                long oid = startOids.get(eClass);
                if (DatabaseSession.perRecordVersioning(eClass)) continue;
                oidCounters.put(eClass, oid);
                buffer.putShort(this.getDatabaseSession().getCid(eClass));
                buffer.putLong(oid);
            }
            queryContext.setOidCounters(oidCounters);
            this.concreteRevision = result.getConcreteRevision();
            this.concreteRevision.setOidCounters(buffer.array());
            this.setProgress("Generating inverses/opposites", 0);
            int inverseFixes = 0;
            int c = 0;
            int writes = 0;
            HashSet<Long> unq = new HashSet<Long>();
            for (EClass eClass : this.deserializer.getSummaryMap().keySet()) {
                if (!packageMetaData.hasInverses(eClass)) continue;
                Query query = new Query("test", packageMetaData);
                QueryPart queryPart = query.createQueryPart();
                queryPart.addType(eClass, true);
                QueryObjectProvider queryObjectProvider = new QueryObjectProvider(this.getDatabaseSession(), this.bimServer, query, Collections.singleton(newRoid), packageMetaData);
                HashMapVirtualObject next = queryObjectProvider.next();
                while (next != null) {
                    for (EReference eReference : packageMetaData.getAllHasInverseReferences(eClass)) {
                        Object reference = next.eGet((EStructuralFeature)eReference);
                        if (reference == null) continue;
                        if (eReference.isMany()) {
                            List references = (List)reference;
                            for (Long refOid : references) {
                                HashMapVirtualObject referencedObject = this.getByOid(packageMetaData, this.getDatabaseSession(), newRoid, refOid);
                                EReference oppositeReference = packageMetaData.getInverseOrOpposite(referencedObject.eClass(), (EStructuralFeature)eReference);
                                if (oppositeReference.isMany()) {
                                    Object existingList = referencedObject.eGet((EStructuralFeature)oppositeReference);
                                    if (existingList != null) {
                                        int currentSize = ((List)existingList).size();
                                        referencedObject.setListItemReference((EStructuralFeature)oppositeReference, currentSize + 1, next.eClass(), Long.valueOf(next.getOid()), 0);
                                        ++inverseFixes;
                                    } else {
                                        referencedObject.setListItemReference((EStructuralFeature)oppositeReference, 0, next.eClass(), Long.valueOf(next.getOid()), 0);
                                        ++inverseFixes;
                                    }
                                } else {
                                    referencedObject.setReference((EStructuralFeature)oppositeReference, next.getOid(), 0);
                                    ++inverseFixes;
                                }
                                referencedObject.saveOverwrite();
                                unq.add(referencedObject.getOid());
                                ++writes;
                            }
                            continue;
                        }
                        Long refOid = (Long)reference;
                        HashMapVirtualObject referencedObject = this.getByOid(packageMetaData, this.getDatabaseSession(), newRoid, refOid);
                        EReference oppositeReference = packageMetaData.getInverseOrOpposite(referencedObject.eClass(), (EStructuralFeature)eReference);
                        if (oppositeReference.isMany()) {
                            Object existingList = referencedObject.eGet((EStructuralFeature)oppositeReference);
                            if (existingList != null) {
                                int currentSize = ((List)existingList).size();
                                referencedObject.setListItemReference((EStructuralFeature)oppositeReference, currentSize + 1, next.eClass(), Long.valueOf(next.getOid()), 0);
                                ++inverseFixes;
                            } else {
                                referencedObject.setListItemReference((EStructuralFeature)oppositeReference, 0, next.eClass(), Long.valueOf(next.getOid()), 0);
                                ++inverseFixes;
                            }
                        } else {
                            referencedObject.setReference((EStructuralFeature)oppositeReference, next.getOid(), 0);
                            unq.add(referencedObject.getOid());
                            ++inverseFixes;
                        }
                        referencedObject.saveOverwrite();
                        ++writes;
                    }
                    next = queryObjectProvider.next();
                }
                this.setProgress("Generating inverses/opposites", (int)(100.0 * (double)c / (double)this.deserializer.getSummaryMap().keySet().size()));
                ++c;
            }
            LOGGER.info("Inverse/opposite fixes: " + inverseFixes + ", writes: " + writes + ", unq: " + unq.size());
            ProgressListener progressListener = new ProgressListener(){

                @Override
                public void updateProgress(String state, int percentage) {
                    StreamingCheckinDatabaseAction.this.setProgress("Generating geometry", percentage);
                }
            };
            StreamingGeometryGenerator geometryGenerator = new StreamingGeometryGenerator(this.bimServer, progressListener);
            this.setProgress("Generating geometry", 0);
            GenerateGeometryResult generateGeometry = geometryGenerator.generateGeometry(this.getActingUid(), this.getDatabaseSession(), queryContext);
            this.concreteRevision.setMinBounds(generateGeometry.getMinBounds());
            this.concreteRevision.setMaxBounds(generateGeometry.getMaxBounds());
            this.setProgress("Doing other stuff...", -1);
            eClasses = this.deserializer.getSummaryMap().keySet();
            s = 2;
            for (EClass eClass : eClasses) {
                if (DatabaseSession.perRecordVersioning(eClass)) continue;
                ++s;
            }
            buffer = ByteBuffer.allocate(10 * s);
            for (EClass eClass : eClasses) {
                long oid = startOids.get(eClass);
                if (DatabaseSession.perRecordVersioning(eClass)) continue;
                buffer.putShort(this.getDatabaseSession().getCid(eClass));
                buffer.putLong(oid);
            }
            buffer.putShort(this.getDatabaseSession().getCid(GeometryPackage.eINSTANCE.getGeometryInfo()));
            buffer.putLong(startOids.get(GeometryPackage.eINSTANCE.getGeometryInfo()));
            buffer.putShort(this.getDatabaseSession().getCid(GeometryPackage.eINSTANCE.getGeometryData()));
            buffer.putLong(startOids.get(GeometryPackage.eINSTANCE.getGeometryData()));
            this.concreteRevision = result.getConcreteRevision();
            this.concreteRevision.setOidCounters(buffer.array());
            result.getConcreteRevision().setSize(Long.valueOf(size));
            for (Revision revision : result.getRevisions()) {
                revision.setSize(Long.valueOf(size));
            }
            IfcHeader ifcHeader = this.deserializer.getIfcHeader();
            if (ifcHeader != null) {
                this.getDatabaseSession().store((IdEObject)ifcHeader);
                this.concreteRevision.setIfcHeader(ifcHeader);
            }
            this.project.getConcreteRevisions().add((Object)this.concreteRevision);
            NewRevisionAdded newRevisionAdded = this.getDatabaseSession().create(NewRevisionAdded.class);
            newRevisionAdded.setDate(new Date());
            newRevisionAdded.setExecutor(user);
            final Revision revision = (Revision)this.concreteRevision.getRevisions().get(0);
            this.concreteRevision.setSummary(new SummaryMap(packageMetaData, this.deserializer.getSummaryMap()).toRevisionSummary(this.getDatabaseSession()));
            if (this.authorization instanceof ExplicitRightsAuthorization && (explicitRightsAuthorization = (ExplicitRightsAuthorization)this.authorization).getSoid() != -1L) {
                Service service = (Service)this.getDatabaseSession().get(explicitRightsAuthorization.getSoid(), OldQuery.getDefault());
                revision.setService(service);
            }
            newRevisionAdded.setRevision(revision);
            newRevisionAdded.setProject(this.project);
            newRevisionAdded.setAccessMethod(this.getAccessMethod());
            if (nrConcreteRevisionsBefore != 0) {
                this.concreteRevision.setClear(true);
            }
            this.getDatabaseSession().addPostCommitAction(new PostCommitAction(){

                @Override
                public void execute() throws UserException {
                    StreamingCheckinDatabaseAction.this.bimServer.getNotificationsManager().notify(new NewRevisionNotification(StreamingCheckinDatabaseAction.this.bimServer, StreamingCheckinDatabaseAction.this.project.getOid(), revision.getOid()));
                }
            });
            this.getDatabaseSession().store((IdEObject)this.concreteRevision);
            this.getDatabaseSession().store((IdEObject)this.project);
        }
        catch (Throwable e) {
            if (e instanceof BimserverDatabaseException) {
                throw (BimserverDatabaseException)e;
            }
            if (e instanceof UserException) {
                throw (UserException)e;
            }
            LOGGER.error("", e);
            throw new UserException(e);
        }
        return this.concreteRevision;
    }

    public String getFileName() {
        return this.fileName;
    }

    public ConcreteRevision getConcreteRevision() {
        return this.concreteRevision;
    }

    public Revision getRevision() {
        return (Revision)this.concreteRevision.getRevisions().get(0);
    }

    public long getCroid() {
        return this.concreteRevision.getOid();
    }

    public long getActingUid() {
        return this.authorization.getUoid();
    }

    public long getPoid() {
        return this.poid;
    }
}

