/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.util.Date;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.PostCommitAction;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.QueryInterface;
import org.bimserver.interfaces.SConverter;
import org.bimserver.interfaces.objects.SGeoTag;
import org.bimserver.interfaces.objects.SLogAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.GeoTagUpdated;
import org.bimserver.models.store.GeoTag;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class UpdateGeoTagDatabaseAction
extends BimDatabaseAction<Void> {
    private final SGeoTag sGeoTag;
    private Authorization authorization;
    private BimServer bimServer;

    public UpdateGeoTagDatabaseAction(BimServer bimServer, DatabaseSession databaseSession, AccessMethod accessMethod, Authorization authorization, SGeoTag sGeoTag) {
        super(databaseSession, accessMethod);
        this.bimServer = bimServer;
        this.authorization = authorization;
        this.sGeoTag = sGeoTag;
    }

    @Override
    public Void execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        User actingUser = this.getUserByUoid(this.authorization.getUoid());
        GeoTag geoTag = (GeoTag)this.getDatabaseSession().get(StorePackage.eINSTANCE.getGeoTag(), this.sGeoTag.getOid(), (QueryInterface)OldQuery.getDefault());
        boolean hasRights = false;
        for (Project project : geoTag.getProjects()) {
            if (!this.authorization.hasRightsOnProject(actingUser, project)) continue;
            hasRights = true;
        }
        if (!hasRights) {
            throw new UserException("User has no rights on any projects associated with this geotag");
        }
        geoTag.setEnabled(this.sGeoTag.getEnabled());
        geoTag.setX(this.sGeoTag.getX());
        geoTag.setY(this.sGeoTag.getY());
        geoTag.setZ(this.sGeoTag.getZ());
        geoTag.setDirectionAngle(this.sGeoTag.getDirectionAngle());
        geoTag.setEpsg(this.sGeoTag.getEpsg());
        final GeoTagUpdated geoTagUpdated = this.getDatabaseSession().create(GeoTagUpdated.class);
        geoTagUpdated.setGeoTag(geoTag);
        geoTagUpdated.setAccessMethod(this.getAccessMethod());
        geoTagUpdated.setDate(new Date());
        geoTagUpdated.setExecutor(actingUser);
        this.getDatabaseSession().addPostCommitAction(new PostCommitAction(){

            @Override
            public void execute() throws UserException {
                UpdateGeoTagDatabaseAction.this.bimServer.getNotificationsManager().notify((SLogAction)new SConverter().convertToSObject(geoTagUpdated));
            }
        });
        this.getDatabaseSession().store((IdEObject)geoTag);
        return null;
    }
}

