/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;

public class UserHasRightsDatabaseAction
extends BimDatabaseAction<Boolean> {
    private final long poid;
    private final long uoid;
    private Authorization authorization;

    public UserHasRightsDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, long uoid, Authorization authorization, long poid) {
        super(databaseSession, accessMethod);
        this.uoid = uoid;
        this.authorization = authorization;
        this.poid = poid;
    }

    @Override
    public Boolean execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        Project project = this.getProjectByPoid(this.poid);
        User user = this.getUserByUoid(this.uoid);
        return this.authorization.hasRightsOnProjectOrSuperProjectsOrSubProjects(user, project);
    }
}

