/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.actions;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import org.bimserver.Authenticator;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.Hashers;

public class ValidateUserDatabaseAction
extends BimDatabaseAction<User> {
    private static final long VALIDATION_TOKEN_EXPIRE_MILLIS = 604800000L;
    private final long uoid;
    private final String token;
    private final String password;

    public ValidateUserDatabaseAction(DatabaseSession databaseSession, AccessMethod accessMethod, long uoid, String token, String password) {
        super(databaseSession, accessMethod);
        this.uoid = uoid;
        this.token = token;
        this.password = password;
    }

    @Override
    public User execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        User user = this.getUserByUoid(this.uoid);
        if (user.getValidationToken() == null || user.getValidationTokenCreated() == null) {
            throw new UserException("This account is already validated and no password reset has been requested");
        }
        if (user.getValidationTokenCreated().getTime() + 604800000L < new Date().getTime()) {
            throw new UserException("The validation period of this validation token has expired, please contact your administrator or request the password reset again");
        }
        if (!Arrays.equals(user.getValidationToken(), Hashers.getSha256Hash((String)this.token))) {
            throw new UserException("The given token is not correct");
        }
        if (this.password == null || this.password.trim().equals("")) {
            throw new UserException("Invalid new password");
        }
        byte[] salt = new byte[32];
        new SecureRandom().nextBytes(salt);
        user.setPasswordHash(new Authenticator().createHash(this.password, salt));
        user.setPasswordSalt(salt);
        user.setValidationToken(null);
        user.setValidationTokenCreated(null);
        this.getDatabaseSession().store((IdEObject)user);
        return user;
    }
}

