/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.berkeley;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimTransaction;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.KeyValueStore;
import org.bimserver.database.Record;
import org.bimserver.database.RecordIterator;
import org.bimserver.database.SearchingRecordIterator;
import org.bimserver.database.berkeley.BerkeleyRecordIterator;
import org.bimserver.database.berkeley.BerkeleySearchingRecordIterator;
import org.bimserver.database.berkeley.BerkeleyTransaction;
import org.bimserver.database.berkeley.BimserverConcurrentModificationDatabaseException;
import org.bimserver.database.berkeley.DatabaseInitException;
import org.bimserver.utils.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerkeleyKeyValueStore
implements KeyValueStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(BerkeleyKeyValueStore.class);
    private Environment environment;
    private long committedWrites;
    private long reads;
    private final Map<String, Database> tables;
    private boolean isNew;
    private TransactionConfig transactionConfig;
    private CursorConfig cursorConfig;
    private long lastPrintedReads;
    private long lastPrintedCommittedWrites;
    private static final boolean MONITOR_CURSOR_STACK_TRACES = false;
    private final AtomicLong cursorCounter;
    private final Map<Long, StackTraceElement[]> openCursors;
    private boolean useTransactions;
    private boolean defer;

    public BerkeleyKeyValueStore(Path dataDir) throws DatabaseInitException {
        block10: {
            this.tables = new HashMap<String, Database>();
            this.lastPrintedReads = 0L;
            this.lastPrintedCommittedWrites = 0L;
            this.cursorCounter = new AtomicLong();
            this.openCursors = new ConcurrentHashMap<Long, StackTraceElement[]>();
            this.useTransactions = false;
            this.defer = true;
            if (Files.isDirectory(dataDir, new LinkOption[0])) {
                try {
                    if (PathUtils.list((Path)dataDir).size() > 0) {
                        LOGGER.info("Non-empty database directory found \"" + dataDir.toString() + "\"");
                        this.isNew = false;
                        break block10;
                    }
                    LOGGER.info("Empty database directory found \"" + dataDir.toString() + "\"");
                    this.isNew = true;
                }
                catch (IOException e) {
                    LOGGER.error("", (Throwable)e);
                }
            } else {
                this.isNew = true;
                LOGGER.info("No database directory found, creating \"" + dataDir.toString() + "\"");
                try {
                    Files.createDirectory(dataDir, new FileAttribute[0]);
                    LOGGER.info("Successfully created database dir \"" + dataDir.toString() + "\"");
                }
                catch (Exception e) {
                    LOGGER.error("Error creating database dir \"" + dataDir.toString() + "\"");
                }
            }
        }
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setCachePercent(50);
        envConfig.setAllowCreate(true);
        envConfig.setTransactional(this.useTransactions);
        envConfig.setTxnTimeout(10L, TimeUnit.SECONDS);
        envConfig.setLockTimeout(2000L, TimeUnit.MILLISECONDS);
        envConfig.setConfigParam("je.checkpointer.highPriority", "true");
        envConfig.setConfigParam("je.cleaner.threads", "5");
        try {
            this.environment = new Environment(dataDir.toFile(), envConfig);
        }
        catch (EnvironmentLockedException e) {
            String message = "Environment locked exception. Another process is using the same database, or the current user has no write access (database location: \"" + dataDir.toString() + "\")";
            throw new DatabaseInitException(message);
        }
        catch (DatabaseException e) {
            String message = "A database initialisation error has occured (" + e.getMessage() + ")";
            throw new DatabaseInitException(message);
        }
        this.transactionConfig = new TransactionConfig();
        this.transactionConfig.setReadCommitted(true);
        this.cursorConfig = new CursorConfig();
        this.cursorConfig.setReadCommitted(true);
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public BimTransaction startTransaction() {
        if (this.useTransactions) {
            try {
                return new BerkeleyTransaction(this.environment.beginTransaction(null, this.transactionConfig));
            }
            catch (DatabaseException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public boolean createTable(String tableName, DatabaseSession databaseSession, boolean transactional) throws BimserverDatabaseException {
        if (this.tables.containsKey(tableName)) {
            throw new BimserverDatabaseException("Table " + tableName + " already created");
        }
        DatabaseConfig databaseConfig = new DatabaseConfig();
        databaseConfig.setAllowCreate(true);
        databaseConfig.setDeferredWrite(!transactional || !this.useTransactions);
        databaseConfig.setTransactional(transactional && this.useTransactions);
        databaseConfig.setSortedDuplicates(false);
        Database database = this.environment.openDatabase(null, tableName, databaseConfig);
        if (database == null) {
            return false;
        }
        this.tables.put(tableName, database);
        return true;
    }

    @Override
    public boolean createIndexTable(String tableName, DatabaseSession databaseSession, boolean transactional) throws BimserverDatabaseException {
        if (this.tables.containsKey(tableName)) {
            throw new BimserverDatabaseException("Table " + tableName + " already created");
        }
        DatabaseConfig databaseConfig = new DatabaseConfig();
        databaseConfig.setAllowCreate(true);
        databaseConfig.setDeferredWrite(!transactional || !this.useTransactions);
        databaseConfig.setTransactional(transactional && this.useTransactions);
        databaseConfig.setSortedDuplicates(true);
        Database database = this.environment.openDatabase(null, tableName, databaseConfig);
        if (database == null) {
            return false;
        }
        this.tables.put(tableName, database);
        return true;
    }

    @Override
    public boolean openTable(String tableName) throws BimserverDatabaseException {
        if (this.tables.containsKey(tableName)) {
            throw new BimserverDatabaseException("Table " + tableName + " already opened");
        }
        DatabaseConfig databaseConfig = new DatabaseConfig();
        databaseConfig.setAllowCreate(false);
        databaseConfig.setDeferredWrite(this.defer);
        databaseConfig.setTransactional(this.useTransactions);
        databaseConfig.setSortedDuplicates(false);
        Database database = this.environment.openDatabase(null, tableName, databaseConfig);
        if (database == null) {
            throw new BimserverDatabaseException("Table " + tableName + " not found in database");
        }
        this.tables.put(tableName, database);
        return true;
    }

    @Override
    public void openIndexTable(String tableName) throws BimserverDatabaseException {
        if (this.tables.containsKey(tableName)) {
            throw new BimserverDatabaseException("Table " + tableName + " already opened");
        }
        DatabaseConfig databaseConfig = new DatabaseConfig();
        databaseConfig.setAllowCreate(false);
        databaseConfig.setDeferredWrite(this.defer);
        databaseConfig.setTransactional(this.useTransactions);
        databaseConfig.setSortedDuplicates(true);
        Database database = this.environment.openDatabase(null, tableName, databaseConfig);
        if (database == null) {
            throw new BimserverDatabaseException("Table " + tableName + " not found in database");
        }
        this.tables.put(tableName, database);
    }

    private Database getDatabase(String tableName) throws BimserverDatabaseException {
        Database database = this.tables.get(tableName);
        if (database == null) {
            throw new BimserverDatabaseException("Table " + tableName + " not found");
        }
        return database;
    }

    private Transaction getTransaction(DatabaseSession databaseSession) {
        BerkeleyTransaction berkeleyTransaction;
        if (databaseSession != null && (berkeleyTransaction = (BerkeleyTransaction)databaseSession.getBimTransaction()) != null) {
            return berkeleyTransaction.getTransaction();
        }
        return null;
    }

    @Override
    public void close() {
        for (Database database : this.tables.values()) {
            try {
                database.close();
            }
            catch (DatabaseException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        if (this.environment != null) {
            try {
                this.environment.close();
            }
            catch (DatabaseException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    @Override
    public byte[] get(String tableName, byte[] keyBytes, DatabaseSession databaseSession) throws BimserverDatabaseException {
        DatabaseEntry key = new DatabaseEntry(keyBytes);
        DatabaseEntry value = new DatabaseEntry();
        try {
            Database database = this.getDatabase(tableName);
            OperationStatus operationStatus = database.get(database.getConfig().getTransactional() ? this.getTransaction(databaseSession) : null, key, value, LockMode.DEFAULT);
            if (operationStatus == OperationStatus.SUCCESS) {
                return value.getData();
            }
        }
        catch (DatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> getDuplicates(String tableName, byte[] keyBytes, DatabaseSession databaseSession) throws BimserverDatabaseException {
        ArrayList<byte[]> arrayList;
        DatabaseEntry key = new DatabaseEntry(keyBytes);
        DatabaseEntry value = new DatabaseEntry();
        Cursor cursor = this.getDatabase(tableName).openCursor(this.getTransaction(databaseSession), this.cursorConfig);
        try {
            OperationStatus operationStatus = cursor.getSearchKey(key, value, LockMode.DEFAULT);
            ArrayList<byte[]> result = new ArrayList<byte[]>();
            while (operationStatus == OperationStatus.SUCCESS) {
                result.add(value.getData());
                operationStatus = cursor.getNextDup(key, value, LockMode.DEFAULT);
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            try {
                cursor.close();
                throw throwable;
            }
            catch (DatabaseException e) {
                LOGGER.error("", (Throwable)e);
                return null;
            }
        }
        cursor.close();
        return arrayList;
    }

    public long getTotalWrites() {
        return this.committedWrites;
    }

    @Override
    public void sync() {
        try {
            this.environment.flushLog(true);
            this.environment.evictMemory();
        }
        catch (DatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    @Override
    public boolean containsTable(String tableName) {
        try {
            return this.environment.getDatabaseNames().contains(tableName);
        }
        catch (DatabaseException e) {
            LOGGER.error("", (Throwable)e);
            return false;
        }
    }

    @Override
    public RecordIterator getRecordIterator(String tableName, DatabaseSession databaseSession) throws BimserverDatabaseException {
        Cursor cursor = null;
        try {
            cursor = this.getDatabase(tableName).openCursor(this.getTransaction(databaseSession), this.cursorConfig);
            BerkeleyRecordIterator berkeleyRecordIterator = new BerkeleyRecordIterator(cursor, this, this.cursorCounter.incrementAndGet());
            return berkeleyRecordIterator;
        }
        catch (DatabaseException e) {
            LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public SearchingRecordIterator getRecordIterator(String tableName, byte[] mustStartWith, byte[] startSearchingAt, DatabaseSession databaseSession) throws BimserverLockConflictException, BimserverDatabaseException {
        Cursor cursor = null;
        try {
            cursor = this.getDatabase(tableName).openCursor(this.getTransaction(databaseSession), this.cursorConfig);
            BerkeleySearchingRecordIterator berkeleySearchingRecordIterator = new BerkeleySearchingRecordIterator(cursor, this, this.cursorCounter.incrementAndGet(), mustStartWith, startSearchingAt);
            return berkeleySearchingRecordIterator;
        }
        catch (BimserverLockConflictException e) {
            if (cursor != null) {
                try {
                    cursor.close();
                    throw e;
                }
                catch (DatabaseException e1) {
                    LOGGER.error("", (Throwable)e1);
                }
            }
        }
        catch (DatabaseException e1) {
            LOGGER.error("", (Throwable)e1);
        }
        return null;
    }

    @Override
    public long count(String tableName) {
        try {
            return this.getDatabase(tableName).count();
        }
        catch (DatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (BimserverDatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getFirstStartingWith(String tableName, byte[] key, DatabaseSession databaseSession) throws BimserverLockConflictException, BimserverDatabaseException {
        try (SearchingRecordIterator recordIterator = this.getRecordIterator(tableName, key, key, databaseSession);){
            Record record = recordIterator.next(key);
            if (record == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = record.getValue();
            return byArray;
        }
    }

    @Override
    public void delete(String tableName, byte[] key, DatabaseSession databaseSession) throws BimserverLockConflictException {
        DatabaseEntry entry = new DatabaseEntry(key);
        try {
            this.getDatabase(tableName).delete(this.getTransaction(databaseSession), entry);
        }
        catch (LockConflictException e) {
            throw new BimserverLockConflictException(e);
        }
        catch (DatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (BimserverDatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String indexTableName, byte[] featureBytesOldIndex, byte[] array, DatabaseSession databaseSession) throws BimserverLockConflictException {
        try (Cursor cursor = this.getDatabase(indexTableName).openCursor(this.getTransaction(databaseSession), this.cursorConfig);){
            if (cursor.getSearchBoth(new DatabaseEntry(featureBytesOldIndex), new DatabaseEntry(array), LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                cursor.delete();
            }
        }
        catch (LockConflictException e) {
            throw new BimserverLockConflictException(e);
        }
        catch (DatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (BimserverDatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    @Override
    public String getLocation() {
        try {
            return this.environment.getHome().getAbsolutePath();
        }
        catch (DatabaseException e) {
            LOGGER.error("", (Throwable)e);
            return "unknown";
        }
    }

    @Override
    public String getStats() {
        try {
            return this.environment.getStats(null).toString();
        }
        catch (DatabaseException e) {
            LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public void commit(DatabaseSession databaseSession) throws BimserverLockConflictException, BimserverDatabaseException {
        Transaction bdbTransaction = this.getTransaction(databaseSession);
        try {
            bdbTransaction.commit();
        }
        catch (LockConflictException e) {
            throw new BimserverLockConflictException(e);
        }
        catch (DatabaseException e) {
            throw new BimserverDatabaseException("", (Throwable)e);
        }
    }

    @Override
    public void store(String tableName, byte[] key, byte[] value, DatabaseSession databaseSession) throws BimserverDatabaseException, BimserverLockConflictException {
        this.store(tableName, key, value, 0, value.length, databaseSession);
    }

    @Override
    public void store(String tableName, byte[] key, byte[] value, int offset, int length, DatabaseSession databaseSession) throws BimserverDatabaseException, BimserverLockConflictException {
        DatabaseEntry dbKey = new DatabaseEntry(key);
        DatabaseEntry dbValue = new DatabaseEntry(value, offset, length);
        try {
            Database database = this.getDatabase(tableName);
            database.put(database.getConfig().getTransactional() ? this.getTransaction(databaseSession) : null, dbKey, dbValue);
        }
        catch (LockConflictException e) {
            throw new BimserverLockConflictException(e);
        }
        catch (DatabaseException e) {
            throw new BimserverDatabaseException("", (Throwable)e);
        }
    }

    @Override
    public void storeNoOverwrite(String tableName, byte[] key, byte[] value, DatabaseSession databaseSession) throws BimserverDatabaseException, BimserverLockConflictException, BimserverConcurrentModificationDatabaseException {
        this.storeNoOverwrite(tableName, key, value, 0, value.length, databaseSession);
    }

    @Override
    public void storeNoOverwrite(String tableName, byte[] key, byte[] value, int index, int length, DatabaseSession databaseSession) throws BimserverDatabaseException, BimserverLockConflictException, BimserverConcurrentModificationDatabaseException {
        DatabaseEntry dbKey = new DatabaseEntry(key);
        DatabaseEntry dbValue = new DatabaseEntry(value, index, length);
        try {
            Database database = this.getDatabase(tableName);
            OperationStatus putNoOverwrite = database.putNoOverwrite(this.getTransaction(databaseSession), dbKey, dbValue);
            if (putNoOverwrite == OperationStatus.KEYEXIST) {
                ByteBuffer keyBuffer = ByteBuffer.wrap(key);
                if (key.length == 16) {
                    int pid = keyBuffer.getInt();
                    long oid = keyBuffer.getLong();
                    int rid = -keyBuffer.getInt();
                    throw new BimserverConcurrentModificationDatabaseException("Key exists: pid: " + pid + ", oid: " + oid + ", rid: " + rid);
                }
                throw new BimserverConcurrentModificationDatabaseException("Key exists: ");
            }
        }
        catch (LockConflictException e) {
            throw new BimserverLockConflictException(e);
        }
        catch (DatabaseException e) {
            throw new BimserverDatabaseException("", (Throwable)e);
        }
    }

    @Override
    public String getType() {
        return "Berkeley DB Java Edition " + JEVersion.CURRENT_VERSION.toString();
    }

    @Override
    public long getDatabaseSizeInBytes() {
        long size = 0L;
        try {
            File home = this.environment.getHome();
            for (File file : home.listFiles()) {
                size += file.length();
            }
        }
        catch (DatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
        return size;
    }

    @Override
    public Set<String> getAllTableNames() {
        return new HashSet<String>(this.environment.getDatabaseNames());
    }

    @Override
    public synchronized void incrementReads(long reads) {
        this.reads += reads;
        if (this.reads / 100000L != this.lastPrintedReads) {
            LOGGER.info("reads: " + this.reads);
            this.lastPrintedReads = this.reads / 100000L;
        }
    }

    @Override
    public synchronized void incrementCommittedWrites(long committedWrites) {
        this.committedWrites += committedWrites;
        if (this.committedWrites / 100000L != this.lastPrintedCommittedWrites) {
            LOGGER.info("writes: " + this.committedWrites);
            this.lastPrintedCommittedWrites = this.committedWrites / 100000L;
        }
    }

    public void removeOpenCursor(long cursorId) {
    }

    @Override
    public void dumpOpenCursors() {
        for (StackTraceElement[] ste : this.openCursors.values()) {
            System.out.println("Open cursor");
            for (StackTraceElement stackTraceElement : ste) {
                LOGGER.info("\t" + stackTraceElement.getClassName() + ":" + stackTraceElement.getLineNumber() + "." + stackTraceElement.getMethodName());
            }
        }
    }
}

