/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.migrations;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.bimserver.database.migrations.Migrator;
import org.bimserver.database.migrations.Schema;
import org.bimserver.emf.MetaDataManager;
import org.bimserver.models.store.StorePackage;
import org.bimserver.plugins.PluginManager;
import org.bimserver.shared.InterfaceList;
import org.bimserver.shared.exceptions.PluginException;
import org.bimserver.shared.interfaces.ServiceInterface;
import org.bimserver.shared.meta.SService;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.shared.meta.SourceCodeFetcher;
import org.bimserver.shared.reflector.RealtimeReflectorFactoryBuilder;
import org.bimserver.tools.generators.AdaptorGeneratorWrapper;
import org.bimserver.tools.generators.AsyncServiceGeneratorWrapper;
import org.bimserver.tools.generators.DataObjectGeneratorWrapper;
import org.bimserver.tools.generators.ProtocolBuffersGenerator;
import org.bimserver.tools.generators.SConverterGeneratorWrapper;
import org.bimserver.tools.generators.SPackageGeneratorWrapper;
import org.bimserver.tools.generators.SServiceGeneratorWrapper;
import org.eclipse.emf.ecore.EPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeMigrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeMigrator.class);
    private ProtocolBuffersGenerator protocolBuffersGenerator;
    private List<SService> knownServices = new ArrayList<SService>();
    private List<String> knownShortNames = new ArrayList<String>();
    private SServicesMap servicesMap = new SServicesMap();

    public static void main(String[] args) {
        new CodeMigrator().start();
    }

    public static void loadPlugins(PluginManager pluginManager, Path current, Path[] pluginDirectories) throws PluginException {
        LOGGER.info("Loading plugins from " + current.toString());
        if (pluginDirectories != null) {
            for (Path pluginDirectory : pluginDirectories) {
                try {
                    pluginManager.loadAllPluginsFromEclipseWorkspaces(pluginDirectory, false);
                }
                catch (PluginException e) {
                    LOGGER.error("", (Throwable)e);
                }
                catch (IOException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        }
    }

    public static void loadPlugins(PluginManager pluginManager, Path[] pluginDirectories) throws PluginException {
        if (pluginDirectories != null) {
            for (Path pluginDirectory : pluginDirectories) {
                try {
                    pluginManager.loadAllPluginsFromEclipseWorkspaces(pluginDirectory, false);
                }
                catch (PluginException e) {
                    LOGGER.error("", (Throwable)e);
                }
                catch (IOException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        }
    }

    private void start() {
        Path tmp;
        LOGGER.info("Starting code migrator...");
        Migrator migrator = new Migrator(null);
        int latestVersion = migrator.getLatestVersion();
        LOGGER.info("Migrating to version " + latestVersion);
        Schema schema = migrator.migrateSchemaTo(latestVersion);
        schema.writeToEcore(new File("models/models.ecore"));
        LOGGER.info("Model migrated to version " + latestVersion);
        LOGGER.info("Generating ServiceInterface objects...");
        LinkedHashSet<EPackage> ePackages = new LinkedHashSet<EPackage>();
        Path home = Paths.get("cmhome", new String[0]);
        if (!Files.exists(home, new LinkOption[0])) {
            try {
                Files.createDirectories(home, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!Files.exists(tmp = home.resolve("tmp"), new LinkOption[0])) {
            try {
                Files.createDirectories(tmp, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        MetaDataManager metaDataManager = new MetaDataManager(tmp);
        metaDataManager.init();
        DataObjectGeneratorWrapper serviceGenerator = new DataObjectGeneratorWrapper(metaDataManager);
        for (EPackage ePackage : schema.getEPackages()) {
            if (ePackage.getName().equals("ifc2x3tc1") || ePackage.getName().equals("ifc4")) continue;
            ePackages.add(ePackage);
        }
        serviceGenerator.generateDataObjects(ePackages);
        LOGGER.info("ServiceInterface objects successfully generated");
        SConverterGeneratorWrapper sConverterGenerator = new SConverterGeneratorWrapper(metaDataManager);
        sConverterGenerator.generate(ePackages);
        SServiceGeneratorWrapper serviceGeneratorWrapper = new SServiceGeneratorWrapper();
        serviceGeneratorWrapper.generate(ServiceInterface.class, (EPackage)StorePackage.eINSTANCE);
        LOGGER.info("Generating protocol buffers file and classes...");
        this.protocolBuffersGenerator = new ProtocolBuffersGenerator();
        for (Class clazz : InterfaceList.getInterfaces()) {
            SService service = new SService(this.servicesMap, new SourceCodeFetcher(){

                public String get(Class<?> clazz) {
                    File javaFile = new File("../PluginBase/src/" + clazz.getName().replace(".", "/") + ".java");
                    try {
                        return FileUtils.readFileToString((File)javaFile);
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
            }, clazz);
            this.servicesMap.add(service);
        }
        this.servicesMap.initialize();
        for (SService service : this.servicesMap.list()) {
            AdaptorGeneratorWrapper adaptorGeneratorWrapper = new AdaptorGeneratorWrapper();
            adaptorGeneratorWrapper.generate(service.getInterfaceClass(), service);
            AsyncServiceGeneratorWrapper asyncServiceGeneratorWrapper = new AsyncServiceGeneratorWrapper();
            asyncServiceGeneratorWrapper.generate(service.getInterfaceClass(), service);
            File protoFile = new File("../BimServerClientLib/src/org/bimserver/client/protocolbuffers/" + service.getInterfaceClass().getSimpleName() + ".proto");
            File descFile = new File("../BimServerClientLib/src/org/bimserver/client/protocolbuffers/" + service.getInterfaceClass().getSimpleName() + ".desc");
            this.protocolBuffersGenerator.generate(service.getInterfaceClass(), protoFile, descFile, this.knownServices.isEmpty(), service, this.knownShortNames);
            this.knownServices.add(service);
            this.knownShortNames.add(service.getInterfaceClass().getSimpleName());
        }
        SPackageGeneratorWrapper sPackageGeneratorWrapper = new SPackageGeneratorWrapper();
        sPackageGeneratorWrapper.generate(ePackages);
        LOGGER.info("Protocol buffers file and classes generated");
        RealtimeReflectorFactoryBuilder reflectorBuilder = new RealtimeReflectorFactoryBuilder(InterfaceList.createSServicesMap(), new File("../PluginBase/genclasses"));
        reflectorBuilder.newReflectorFactory();
        LOGGER.info("");
        LOGGER.info("Migration successfull");
        try {
            FileUtils.deleteDirectory((File)new File("cmhome"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

