/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.migrations;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.bimserver.database.Database;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.migrations.InconsistentModelsException;
import org.bimserver.database.migrations.Migration;
import org.bimserver.database.migrations.MigrationException;
import org.bimserver.database.migrations.Schema;
import org.bimserver.emf.IdEObjectImpl;
import org.bimserver.models.ifc2x3tc1.Ifc2x3tc1Package;
import org.bimserver.models.log.LogPackage;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.models.store.StorePackage;
import org.eclipse.emf.ecore.EPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Migrator.class);
    private final Database database;

    public Migrator(Database database) {
        this.database = database;
    }

    private Migration getMigration(int number) {
        String name = "org.bimserver.database.migrations.steps.Step" + StringUtils.leftPad((String)("" + number), (int)4, (String)"0");
        try {
            Class<?> migrationClass = Class.forName(name);
            return (Migration)migrationClass.newInstance();
        }
        catch (Exception e) {
            if (!(e instanceof ClassNotFoundException)) {
                LOGGER.error("", (Throwable)e);
            }
            return null;
        }
    }

    public Schema migrateSchemaTo(int targetVersion) {
        Schema schema = new Schema();
        boolean moreUpgrades = true;
        int i = 0;
        while (moreUpgrades && i <= targetVersion) {
            Migration migration = this.getMigration(i);
            if (migration != null) {
                migration.migrate(schema, null);
                ++i;
                continue;
            }
            moreUpgrades = false;
        }
        if (i < targetVersion) {
            LOGGER.warn("Not upgraded to " + targetVersion + ", probably missing Step files!");
        }
        return schema;
    }

    public int getLatestVersion() {
        int i = -1;
        Migration migration;
        while ((migration = this.getMigration(i + 1)) != null) {
            ++i;
        }
        return i;
    }

    public Schema migrateSchemaToLatest() {
        return this.migrateSchemaTo(this.getLatestVersion());
    }

    public Schema migrate() throws MigrationException, InconsistentModelsException {
        try (DatabaseSession session = this.database.createSession();){
            Schema schema = this.migrate(session);
            session.commit();
            Schema schema2 = schema;
            return schema2;
        }
    }

    private Schema upgrade(DatabaseSession databaseSession, int applicationSchemaVersion, int databaseSchemaVersion) throws MigrationException, InconsistentModelsException {
        Schema schema = new Schema();
        for (int i = 0; i <= applicationSchemaVersion; ++i) {
            Migration migration = this.getMigration(i);
            if (migration != null) {
                migration.migrate(schema, databaseSession);
                if (i > databaseSchemaVersion) {
                    schema.upgradeDatabase(this.database, i, databaseSession);
                }
            } else {
                throw new MigrationException("Required migration not found: " + i);
            }
            schema.clearUpdates();
        }
        Schema emfSchema = new Schema();
        emfSchema.addEPackage((EPackage)StorePackage.eINSTANCE);
        emfSchema.addEPackage((EPackage)LogPackage.eINSTANCE);
        emfSchema.addEPackage((EPackage)Ifc2x3tc1Package.eINSTANCE);
        return schema;
    }

    public List<org.bimserver.models.store.Migration> getMigrations() {
        ArrayList<org.bimserver.models.store.Migration> migrations = new ArrayList<org.bimserver.models.store.Migration>();
        int applicationSchemaVersion = this.database.getApplicationSchemaVersion();
        int databaseSchemaVersion = this.database.getDatabaseSchemaVersion();
        for (int i = applicationSchemaVersion; i >= 0; --i) {
            Migration migration = this.getMigration(i);
            if (migration == null) continue;
            org.bimserver.models.store.Migration migrationObject = StoreFactory.eINSTANCE.createMigration();
            ((IdEObjectImpl)migrationObject).setOid((long)i);
            migrationObject.setNumber(Integer.valueOf(i));
            migrationObject.setExecuted(Boolean.valueOf(i <= databaseSchemaVersion));
            migrationObject.setDescription(migration.getDescription());
            migrations.add(migrationObject);
        }
        return migrations;
    }

    public Schema migrate(DatabaseSession session) throws MigrationException, InconsistentModelsException {
        int applicationSchemaVersion = this.database.getApplicationSchemaVersion();
        int databaseSchemaVersion = this.database.getDatabaseSchemaVersion();
        Schema schema = this.upgrade(session, applicationSchemaVersion, databaseSchemaVersion);
        return schema;
    }

    public boolean migrationRequired() {
        return this.database.getApplicationSchemaVersion() > this.database.getDatabaseSchemaVersion();
    }

    public boolean migrationImpossible() {
        return this.database.getApplicationSchemaVersion() < this.database.getDatabaseSchemaVersion();
    }
}

