/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.migrations;

import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.Database;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.migrations.Change;
import org.bimserver.models.ifc2x3tc1.Ifc2x3tc1Package;
import org.bimserver.models.ifc4.Ifc4Package;
import org.eclipse.emf.ecore.EClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewClassChange
implements Change {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewClassChange.class);
    private final EClass eClass;

    public NewClassChange(EClass eClass) {
        this.eClass = eClass;
    }

    @Override
    public void change(Database database, DatabaseSession databaseSession) throws BimserverDatabaseException {
        String tableName = this.getEClass().getEPackage().getName() + "_" + this.getEClass().getName();
        if (this.eClass.getEAnnotation("nodatabase") == null) {
            LOGGER.info("Creating table: " + tableName);
            try {
                boolean transactional = this.getEClass().getEPackage() != Ifc2x3tc1Package.eINSTANCE && this.getEClass().getEPackage() != Ifc4Package.eINSTANCE;
                boolean created = database.createTable(this.getEClass(), databaseSession, transactional);
                if (!created) {
                    throw new BimserverDatabaseException("Could not create table " + tableName);
                }
            }
            catch (BimserverLockConflictException e) {
                LOGGER.error("", (Throwable)((Object)e));
            }
        }
    }

    public EClass getEClass() {
        return this.eClass;
    }
}

