/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.migrations;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.Database;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.migrations.AddIndexChange;
import org.bimserver.database.migrations.Change;
import org.bimserver.database.migrations.NewAttributeChange;
import org.bimserver.database.migrations.NewClassBulkChange;
import org.bimserver.database.migrations.NewClassChange;
import org.bimserver.database.migrations.NewEnumChange;
import org.bimserver.database.migrations.NewPackageChange;
import org.bimserver.database.migrations.NewReferenceChange;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schema {
    private static final Logger LOGGER = LoggerFactory.getLogger(Schema.class);
    private final Map<String, EPackage> packages = new TreeMap<String, EPackage>();
    private final Map<EClass, Set<EClass>> directSubClasses = new HashMap<EClass, Set<EClass>>();
    private final Map<EClass, Set<EClass>> indirectSubClasses = new HashMap<EClass, Set<EClass>>();
    private final Set<Change> changes = new LinkedHashSet<Change>();

    private void initSubClasses() {
        for (EPackage ePackage : this.packages.values()) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (!(eClassifier instanceof EClass)) continue;
                EClass eClass = (EClass)eClassifier;
                this.initDirectSubClasses(eClass);
                this.initIndirectSubClasses(eClass);
            }
        }
    }

    private void initDirectSubClasses(EClass eClass) {
        HashSet<EClass> set = new HashSet<EClass>();
        this.directSubClasses.put(eClass, set);
        set.add(eClass);
        for (EClassifier eClassifier : eClass.getEPackage().getEClassifiers()) {
            EClass e;
            if (!(eClassifier instanceof EClass) || !(e = (EClass)eClassifier).getESuperTypes().contains((Object)eClass)) continue;
            set.add(e);
        }
    }

    public Set<EPackage> getEPackages() {
        return new HashSet<EPackage>(this.packages.values());
    }

    private void initIndirectSubClasses(EClass eClass) {
        HashSet<EClass> set = new HashSet<EClass>();
        this.indirectSubClasses.put(eClass, set);
        set.add(eClass);
        for (EClassifier eClassifier : eClass.getEPackage().getEClassifiers()) {
            EClass e;
            if (!(eClassifier instanceof EClass) || !eClass.isSuperTypeOf(e = (EClass)eClassifier)) continue;
            set.add(e);
        }
    }

    public EPackage getEPackage(String name) {
        return this.packages.get(name);
    }

    public EPackage createEPackage(String name) {
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        ePackage.setName(name);
        ePackage.setNsPrefix(name);
        ePackage.setNsURI(name);
        this.packages.put(ePackage.getName(), ePackage);
        return ePackage;
    }

    public EEnum createEEnum(EPackage ePackage, String name) {
        EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
        this.changes.add(new NewEnumChange(eEnum));
        ePackage.getEClassifiers().add((Object)eEnum);
        eEnum.setName(name);
        return eEnum;
    }

    public EEnumLiteral createEEnumLiteral(EEnum eEnum, String name, int value) {
        EEnumLiteral eEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
        eEnumLiteral.setValue(value);
        eEnum.getELiterals().add((Object)eEnumLiteral);
        eEnumLiteral.setName(name);
        return eEnumLiteral;
    }

    public EEnumLiteral createEEnumLiteral(EEnum eEnum, String name) {
        EEnumLiteral eEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
        if (eEnum.getELiterals().size() == 0) {
            eEnumLiteral.setValue(0);
        } else {
            int largestValue = Integer.MIN_VALUE;
            for (EEnumLiteral existingLiteral : eEnum.getELiterals()) {
                if (existingLiteral.getValue() <= largestValue) continue;
                largestValue = existingLiteral.getValue();
            }
            eEnumLiteral.setValue(largestValue + 1);
        }
        eEnum.getELiterals().add((Object)eEnumLiteral);
        eEnumLiteral.setName(name);
        return eEnumLiteral;
    }

    public EClass createEClass(EPackage ePackage, String name, EClass ... superClasses) {
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        eClass.setName(name);
        this.changes.add(new NewClassChange(eClass));
        for (EClass superClass : superClasses) {
            eClass.getESuperTypes().add((Object)superClass);
        }
        ePackage.getEClassifiers().add((Object)eClass);
        return eClass;
    }

    public EAttribute createEAttribute(EClass eClass, String name, EDataType eDataType, Multiplicity multiplicity) {
        EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
        eAttribute.setName(name);
        if (multiplicity == Multiplicity.MANY) {
            eAttribute.setUpperBound(-1);
        }
        if (!this.isNew(eClass)) {
            this.changes.add(new NewAttributeChange(this, eClass.getEAllStructuralFeatures().size(), eAttribute));
        }
        eAttribute.setEType((EClassifier)eDataType);
        eClass.getEStructuralFeatures().add((Object)eAttribute);
        return eAttribute;
    }

    public EAttribute createEAttribute(EClass eClass, String name, EDataType eDataType) {
        return this.createEAttribute(eClass, name, eDataType, Multiplicity.SINGLE);
    }

    private boolean isNew(EClass eClass) {
        for (Change change : this.changes) {
            NewClassChange newClassChange;
            if (!(change instanceof NewClassChange) || (newClassChange = (NewClassChange)change).getEClass() != eClass) continue;
            return true;
        }
        return false;
    }

    public EReference createEReference(EClass eClass, String name, EClass type, Multiplicity multiplicity) {
        EReference eReference = EcoreFactory.eINSTANCE.createEReference();
        eReference.setName(name);
        if (multiplicity == Multiplicity.MANY) {
            eReference.setUpperBound(-1);
        }
        if (!this.isNew(eClass)) {
            this.changes.add(new NewReferenceChange(this, eClass.getEAllStructuralFeatures().size(), eReference));
        }
        eReference.setEType((EClassifier)type);
        eClass.getEStructuralFeatures().add((Object)eReference);
        return eReference;
    }

    public void writeToEcore(File file) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        Resource resource = resourceSet.createResource(URI.createFileURI((String)file.getAbsolutePath()));
        for (EPackage ePackage : this.packages.values()) {
            resource.getContents().add((Object)ePackage);
        }
        try {
            resource.save(null);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public void upgradeDatabase(Database database, int version, DatabaseSession databaseSession) {
        LOGGER.info("Upgrading database to version " + version);
        this.initSubClasses();
        for (Change change : this.changes) {
            try {
                change.change(database, databaseSession);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        try {
            database.setDatabaseVersion(version, databaseSession);
        }
        catch (BimserverLockConflictException e) {
            LOGGER.error("", (Throwable)((Object)e));
        }
    }

    public EClass getEClass(String packageName, String name) {
        EPackage ePackage = this.packages.get(packageName);
        if (ePackage == null) {
            throw new RuntimeException("Package with name " + name + " not found");
        }
        EClass eClassifier = (EClass)ePackage.getEClassifier(name);
        if (eClassifier == null) {
            throw new RuntimeException("Class " + name + " not found in " + packageName);
        }
        return eClassifier;
    }

    public void clearUpdates() {
        this.changes.clear();
    }

    public void loadEcore(String name, InputStream inputStream) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        Resource resource = resourceSet.createResource(URI.createURI((String)name));
        try {
            resource.load(inputStream, new HashMap());
            for (EObject eObject : resource.getContents()) {
                if (!(eObject instanceof EPackage)) continue;
                EPackage ePackage = (EPackage)eObject;
                this.addEPackage(ePackage);
            }
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public void addEPackage(EPackage ePackage) {
        this.packages.put(ePackage.getName(), ePackage);
        this.changes.add(new NewPackageChange(ePackage));
        HashSet<EClass> newClasses = new HashSet<EClass>();
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            newClasses.add((EClass)eClassifier);
        }
        this.addEClasses(ePackage, newClasses);
    }

    private void addEClasses(EPackage ePackage, Set<EClass> newClasses) {
        this.changes.add(new NewClassBulkChange(ePackage, newClasses));
    }

    public void addEClass(EClass eClass) {
        this.changes.add(new NewClassChange(eClass));
    }

    public Set<EClass> getSubClasses(EClass eClass) {
        return this.indirectSubClasses.get(eClass);
    }

    public EEnum getEEnum(String packageName, String enumName) {
        return (EEnum)this.packages.get(packageName).getEClassifier(enumName);
    }

    public EDataType createEDataType(EPackage ePackage, EDataType dataType) {
        ePackage.getEClassifiers().add((Object)dataType);
        return dataType;
    }

    public EClass createEClass(String packageName, String className) {
        return this.createEClass(this.getEPackage(packageName), className, new EClass[0]);
    }

    public EEnum createEEnum(String packageName, String enumName) {
        return this.createEEnum(this.getEPackage(packageName), enumName);
    }

    public EClass createEClass(String packageName, String className, EClass ... superTypes) {
        return this.createEClass(this.getEPackage(packageName), className, superTypes);
    }

    public void removeEReference(EClass eClass, String name) {
        eClass.getEStructuralFeatures().remove((Object)eClass.getEStructuralFeature(name));
    }

    public void addIndex(EStructuralFeature eStructuralFeature) {
        this.changes.add(new AddIndexChange(this, eStructuralFeature));
        EAnnotation index = EcoreFactory.eINSTANCE.createEAnnotation();
        index.setSource("singleindex");
        eStructuralFeature.getEAnnotations().add((Object)index);
    }

    public static enum Multiplicity {
        SINGLE,
        MANY;

    }
}

