/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.migrations.steps;

import javax.activation.DataHandler;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.migrations.Migration;
import org.bimserver.database.migrations.Schema;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;

public class Step0000
extends Migration {
    private EPackage storePackage;
    private EcorePackage ecorePackage = EcorePackage.eINSTANCE;
    private EClass revisionClass;
    private EEnum objectStateEnum;
    private EEnum siPrefixEnum;
    private EClass user;
    private EClass checkoutClass;
    private EEnum userTypeEnum;
    private EClass geoTagClass;
    private EClass concreteRevisionClass;
    private EClass project;
    private EReference projectHasAuthorizedUsers;
    private EReference projectConcreteRevisions;
    private EReference projectRevisions;
    private EReference projectCheckouts;
    private EReference projectGeoTag;
    private EReference projectSubProjects;
    private EReference projectParentProject;
    private EReference userHasRightsOn;
    private EReference concreteRevisionProject;
    private EReference concreteRevisionRevisions;
    private EReference revisionConcreteRevisions;
    private EReference revisionCheckouts;
    private EReference revisionProject;
    private EReference checkoutRevision;
    private EReference checkoutProject;
    private EReference geoTagProjects;
    private Schema schema;
    private EClass serverSettings;
    private EClass userSettings;
    private EReference revisionUser;
    private EReference userRevisions;

    @Override
    public void migrate(Schema schema, DatabaseSession databaseSession) {
        this.schema = schema;
        this.storePackage = schema.createEPackage("store");
        this.createUserTypeEnum();
        this.createSIPrefixEnum();
        this.createObjectStateEnum();
        this.project = schema.createEClass(this.storePackage, "Project", new EClass[0]);
        this.user = schema.createEClass(this.storePackage, "User", new EClass[0]);
        this.revisionClass = schema.createEClass(this.storePackage, "Revision", new EClass[0]);
        this.concreteRevisionClass = schema.createEClass(this.storePackage, "ConcreteRevision", new EClass[0]);
        this.geoTagClass = schema.createEClass(this.storePackage, "GeoTag", new EClass[0]);
        this.checkoutClass = schema.createEClass(this.storePackage, "Checkout", new EClass[0]);
        this.serverSettings = schema.createEClass(this.storePackage, "ServerSettings", new EClass[0]);
        this.userSettings = schema.createEClass(this.storePackage, "UserSettings", new EClass[0]);
        this.createProjectClass();
        this.createUserClass();
        this.createCheckoutClass();
        this.createGeoTagClass();
        this.createConcreteRevisionClass();
        this.createRevisionClass();
        this.createServerSettingsClass();
        this.userHasRightsOn.setEOpposite(this.projectHasAuthorizedUsers);
        this.projectHasAuthorizedUsers.setEOpposite(this.userHasRightsOn);
        this.revisionProject.setEOpposite(this.projectRevisions);
        this.projectRevisions.setEOpposite(this.revisionProject);
        this.checkoutProject.setEOpposite(this.projectCheckouts);
        this.projectCheckouts.setEOpposite(this.checkoutProject);
        this.checkoutRevision.setEOpposite(this.revisionCheckouts);
        this.revisionCheckouts.setEOpposite(this.checkoutRevision);
        this.revisionUser.setEOpposite(this.userRevisions);
        this.userRevisions.setEOpposite(this.revisionUser);
        this.revisionConcreteRevisions.setEOpposite(this.concreteRevisionRevisions);
        this.concreteRevisionRevisions.setEOpposite(this.revisionConcreteRevisions);
        this.concreteRevisionProject.setEOpposite(this.projectConcreteRevisions);
        this.projectConcreteRevisions.setEOpposite(this.concreteRevisionProject);
        this.projectGeoTag.setEOpposite(this.geoTagProjects);
        this.geoTagProjects.setEOpposite(this.projectGeoTag);
        this.projectParentProject.setEOpposite(this.projectSubProjects);
        this.projectSubProjects.setEOpposite(this.projectParentProject);
        EPackage logPackage = schema.createEPackage("log");
        EEnum accessMethodEnum = schema.createEEnum(logPackage, "AccessMethod");
        schema.createEEnumLiteral(accessMethodEnum, "SOAP");
        schema.createEEnumLiteral(accessMethodEnum, "WEB_INTERFACE");
        schema.createEEnumLiteral(accessMethodEnum, "INTERNAL");
        schema.createEEnumLiteral(accessMethodEnum, "REST");
        schema.createEEnumLiteral(accessMethodEnum, "SYNDICATION");
        schema.createEEnumLiteral(accessMethodEnum, "JSON");
        EClass logAction = schema.createEClass(logPackage, "LogAction", new EClass[0]);
        schema.createEAttribute(logAction, "date", EcorePackage.eINSTANCE.getEDate(), Schema.Multiplicity.SINGLE);
        schema.createEReference(logAction, "executor", this.user, Schema.Multiplicity.SINGLE);
        schema.createEAttribute(logAction, "accessMethod", (EDataType)accessMethodEnum, Schema.Multiplicity.SINGLE);
        EClass serverLogClass = schema.createEClass(logPackage, "ServerLog", new EClass[0]);
        schema.createEReference(serverLogClass, "actions", logAction, Schema.Multiplicity.MANY);
        EClass projectRelated = schema.createEClass(logPackage, "ProjectRelated", logAction);
        EReference projectRelatedProject = schema.createEReference(projectRelated, "project", this.project, Schema.Multiplicity.SINGLE);
        EClass checkoutRelated = schema.createEClass(logPackage, "CheckoutRelated", logAction);
        EReference checkoutRelatedCheckout = schema.createEReference(checkoutRelated, "checkout", this.checkoutClass, Schema.Multiplicity.SINGLE);
        EClass revisionRelated = schema.createEClass(logPackage, "RevisionRelated", logAction);
        EReference revisionRelatedRevision = schema.createEReference(revisionRelated, "revision", this.revisionClass, Schema.Multiplicity.SINGLE);
        EClass userRelated = schema.createEClass(logPackage, "UserRelated", logAction);
        EReference userRelatedUser = schema.createEReference(userRelated, "user", this.user, Schema.Multiplicity.SINGLE);
        schema.createEClass(logPackage, "NewUserAdded", userRelated);
        EClass newProjectAddedClass = schema.createEClass(logPackage, "NewProjectAdded", projectRelated);
        schema.createEReference(newProjectAddedClass, "parentProject", this.project, Schema.Multiplicity.SINGLE);
        EClass revisionBrancedClass = schema.createEClass(logPackage, "RevisionBranched", logAction);
        schema.createEReference(revisionBrancedClass, "oldrevision", this.revisionClass, Schema.Multiplicity.SINGLE);
        schema.createEReference(revisionBrancedClass, "newrevision", this.revisionClass, Schema.Multiplicity.SINGLE);
        EClass newRevisionAdded = schema.createEClass(logPackage, "NewRevisionAdded", revisionRelated);
        schema.createEReference(newRevisionAdded, "project", this.project, Schema.Multiplicity.SINGLE);
        schema.createEClass(logPackage, "NewCheckoutAdded", checkoutRelated);
        schema.createEClass(logPackage, "SettingsSaved", logAction);
        EClass userAddedToProject = schema.createEClass(logPackage, "UserAddedToProject", userRelated);
        schema.createEReference(userAddedToProject, "project", this.project, Schema.Multiplicity.SINGLE);
        schema.createEClass(logPackage, "NewObjectIDMUploaded", logAction);
        schema.createEClass(logPackage, "Download", logAction);
        EClass userRemovedFromProject = schema.createEClass(logPackage, "UserRemovedFromProject", userRelated);
        schema.createEReference(userRemovedFromProject, "project", this.project, Schema.Multiplicity.SINGLE);
        schema.createEClass(logPackage, "ProjectDeleted", projectRelated);
        schema.createEClass(logPackage, "UserDeleted", userRelated);
        schema.createEClass(logPackage, "PasswordReset", userRelated);
        EClass databaseCreatedClass = schema.createEClass(logPackage, "DatabaseCreated", logAction);
        schema.createEAttribute(databaseCreatedClass, "path", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(databaseCreatedClass, "version", this.ecorePackage.getEIntegerObject(), Schema.Multiplicity.SINGLE);
        schema.createEClass(logPackage, "ServerStarted", logAction);
        schema.createEClass(logPackage, "ProjectUpdated", projectRelated);
        schema.createEClass(logPackage, "UserUndeleted", userRelated);
        schema.createEClass(logPackage, "ProjectUndeleted", projectRelated);
        schema.createEClass(logPackage, "RevisionUpdated", revisionRelated);
        EClass geoTagUpdatedClass = schema.createEClass(logPackage, "GeoTagUpdated", logAction);
        schema.createEReference(geoTagUpdatedClass, "geoTag", this.geoTagClass, Schema.Multiplicity.SINGLE);
        schema.createEClass(logPackage, "PasswordChanged", userRelated);
        schema.createEClass(logPackage, "UserChanged", userRelated);
        EClass pluginConfiguration = schema.createEClass(this.storePackage, "PluginConfiguration", new EClass[0]);
        schema.createEAttribute(pluginConfiguration, "name", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(pluginConfiguration, "enabled", EcorePackage.eINSTANCE.getEBooleanObject(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(pluginConfiguration, "description", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        EClass serializerPluginConfiguration = schema.createEClass(this.storePackage, "SerializerPluginConfiguration", pluginConfiguration);
        EClass objectIDMPluginConfiguration = schema.createEClass(this.storePackage, "ObjectIDMPluginConfiguration", pluginConfiguration);
        EReference serializerObjectIDMReference = schema.createEReference(serializerPluginConfiguration, "objectIDM", objectIDMPluginConfiguration, Schema.Multiplicity.SINGLE);
        EReference serializerSettingsReference = schema.createEReference(serializerPluginConfiguration, "userSettings", this.userSettings, Schema.Multiplicity.SINGLE);
        EReference objectIDMSerializers = schema.createEReference(objectIDMPluginConfiguration, "serializers", serializerPluginConfiguration, Schema.Multiplicity.MANY);
        EReference objectIDMSettingsReference = schema.createEReference(objectIDMPluginConfiguration, "userSettings", this.userSettings, Schema.Multiplicity.SINGLE);
        EReference settingsSerializersReference = schema.createEReference(this.userSettings, "serializers", serializerPluginConfiguration, Schema.Multiplicity.MANY);
        EReference settingsObjectIDMReference = schema.createEReference(this.userSettings, "objectIDMs", objectIDMPluginConfiguration, Schema.Multiplicity.MANY);
        serializerSettingsReference.setEOpposite(settingsSerializersReference);
        objectIDMSettingsReference.setEOpposite(settingsObjectIDMReference);
        settingsSerializersReference.setEOpposite(serializerSettingsReference);
        settingsObjectIDMReference.setEOpposite(objectIDMSettingsReference);
        objectIDMSerializers.setEOpposite(serializerObjectIDMReference);
        serializerObjectIDMReference.setEOpposite(objectIDMSerializers);
        schema.createEAttribute(this.serverSettings, "cacheOutputFiles", EcorePackage.eINSTANCE.getEBooleanObject(), Schema.Multiplicity.SINGLE);
        EClass renderEnginePluginConfiguration = schema.createEClass(this.storePackage, "RenderEnginePluginConfiguration", pluginConfiguration);
        EReference renderEngineSerializersReference = schema.createEReference(renderEnginePluginConfiguration, "serializers", serializerPluginConfiguration, Schema.Multiplicity.MANY);
        EReference serializerRenderEngineReference = schema.createEReference(serializerPluginConfiguration, "renderEngine", renderEnginePluginConfiguration, Schema.Multiplicity.SINGLE);
        serializerRenderEngineReference.setEOpposite(renderEngineSerializersReference);
        renderEngineSerializersReference.setEOpposite(serializerRenderEngineReference);
        EReference renderEngineSettings = schema.createEReference(renderEnginePluginConfiguration, "userSettings", this.userSettings, Schema.Multiplicity.SINGLE);
        EReference settingsRenderEngines = schema.createEReference(this.userSettings, "renderEngines", renderEnginePluginConfiguration, Schema.Multiplicity.MANY);
        settingsRenderEngines.setEOpposite(renderEngineSettings);
        renderEngineSettings.setEOpposite(settingsRenderEngines);
        EClass deserializerPluginClass = schema.createEClass(this.storePackage, "DeserializerPluginConfiguration", pluginConfiguration);
        EReference deserializerSettingsReference = schema.createEReference(deserializerPluginClass, "userSettings", this.userSettings, Schema.Multiplicity.SINGLE);
        EReference settingsDeserializersReference = schema.createEReference(this.userSettings, "deserializers", deserializerPluginClass, Schema.Multiplicity.MANY);
        deserializerSettingsReference.setEOpposite(settingsDeserializersReference);
        settingsDeserializersReference.setEOpposite(deserializerSettingsReference);
        EDataType dataHandler = schema.createEDataType(this.storePackage, EcoreFactory.eINSTANCE.createEDataType());
        dataHandler.setName("DataHandler");
        dataHandler.setInstanceClass(DataHandler.class);
        EClass downloadResultClass = schema.createEClass(this.storePackage, "DownloadResult", new EClass[0]);
        schema.createEAttribute(downloadResultClass, "projectName", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(downloadResultClass, "revisionNr", this.ecorePackage.getEIntegerObject(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(downloadResultClass, "file", dataHandler, Schema.Multiplicity.SINGLE);
        schema.createEClass(this.storePackage, "CheckoutResult", downloadResultClass);
        EClass dataValue = schema.createEClass(this.storePackage, "DataValue", new EClass[0]);
        schema.createEAttribute(dataValue, "fieldName", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        EClass dataObjectClass = schema.createEClass(this.storePackage, "DataObject", new EClass[0]);
        schema.createEAttribute(dataObjectClass, "type", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(dataObjectClass, "guid", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(dataObjectClass, "name", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEReference(dataObjectClass, "values", dataValue, Schema.Multiplicity.MANY).getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        EClass userSessionClass = schema.createEClass(this.storePackage, "UserSession", new EClass[0]);
        schema.createEReference(userSessionClass, "user", this.user, Schema.Multiplicity.SINGLE);
        schema.createEAttribute(userSessionClass, "username", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(userSessionClass, "name", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(userSessionClass, "type", (EDataType)schema.getEEnum("store", "UserType"), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(userSessionClass, "remoteAddress", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(userSessionClass, "activeSince", this.ecorePackage.getEDate(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(userSessionClass, "lastActive", this.ecorePackage.getEDate(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(userSessionClass, "accessMethod", (EDataType)schema.getEEnum("log", "AccessMethod"), Schema.Multiplicity.SINGLE);
        EClass migrationClass = schema.createEClass(this.storePackage, "Migration", new EClass[0]);
        schema.createEAttribute(migrationClass, "number", this.ecorePackage.getEIntegerObject(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(migrationClass, "description", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(migrationClass, "executed", this.ecorePackage.getEBooleanObject(), Schema.Multiplicity.SINGLE);
        EClass referenceDataValue = schema.createEClass(this.storePackage, "ReferenceDataValue", dataValue);
        schema.createEAttribute(referenceDataValue, "typeName", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(referenceDataValue, "guid", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        EClass listDataValue = schema.createEClass(this.storePackage, "ListDataValue", dataValue);
        schema.createEReference(listDataValue, "values", dataValue, Schema.Multiplicity.MANY).getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        EClass simpleDataValue = schema.createEClass(this.storePackage, "SimpleDataValue", dataValue);
        schema.createEAttribute(simpleDataValue, "stringValue", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        EClass databaseInformationItem = schema.createEClass(this.storePackage, "DatabaseInformationItem", new EClass[0]);
        schema.createEAttribute(databaseInformationItem, "key", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(databaseInformationItem, "value", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        EClass databaseInformationCategoryClass = schema.createEClass(this.storePackage, "DatabaseInformationCategory", new EClass[0]);
        schema.createEAttribute(databaseInformationCategoryClass, "title", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEReference(databaseInformationCategoryClass, "items", databaseInformationItem, Schema.Multiplicity.MANY).getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        EClass databaseInformationClass = schema.createEClass(this.storePackage, "DatabaseInformation", new EClass[0]);
        schema.createEAttribute(databaseInformationClass, "numberOfProjects", this.ecorePackage.getEIntegerObject(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(databaseInformationClass, "numberOfUsers", this.ecorePackage.getEIntegerObject(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(databaseInformationClass, "numberOfRevisions", this.ecorePackage.getEIntegerObject(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(databaseInformationClass, "numberOfCheckouts", this.ecorePackage.getEIntegerObject(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(databaseInformationClass, "databaseSizeInBytes", this.ecorePackage.getELongObject(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(databaseInformationClass, "type", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(databaseInformationClass, "created", this.ecorePackage.getEDate(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(databaseInformationClass, "location", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(databaseInformationClass, "schemaVersion", this.ecorePackage.getEIntegerObject(), Schema.Multiplicity.SINGLE);
        schema.createEReference(databaseInformationClass, "categories", databaseInformationCategoryClass, Schema.Multiplicity.MANY).getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        EClass pluginDescriptor = schema.createEClass(this.storePackage, "PluginDescriptor", new EClass[0]);
        schema.createEAttribute(pluginDescriptor, "simpleName", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(pluginDescriptor, "defaultName", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(pluginDescriptor, "pluginClassName", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(pluginDescriptor, "description", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(pluginDescriptor, "location", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(pluginDescriptor, "enabled", this.ecorePackage.getEBooleanObject(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(pluginDescriptor, "pluginInterfaceClassName", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        EReference pluginConfigurationPluginDescriptor = schema.createEReference(pluginConfiguration, "pluginDescriptor", pluginDescriptor, Schema.Multiplicity.SINGLE);
        EReference pluginDescriptorPluginConfiguration = schema.createEReference(pluginDescriptor, "configurations", pluginConfiguration, Schema.Multiplicity.MANY);
        pluginDescriptorPluginConfiguration.setEOpposite(pluginConfigurationPluginDescriptor);
        pluginConfigurationPluginDescriptor.setEOpposite(pluginDescriptorPluginConfiguration);
        schema.createEClass(this.storePackage, "SerializerPluginDescriptor", pluginDescriptor);
        schema.createEClass(this.storePackage, "DeserializerPluginDescriptor", pluginDescriptor);
        EClass revisionSummaryTypeClass = schema.createEClass(this.storePackage, "RevisionSummaryType", new EClass[0]);
        schema.createEAttribute(revisionSummaryTypeClass, "name", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(revisionSummaryTypeClass, "count", this.ecorePackage.getEIntegerObject(), Schema.Multiplicity.SINGLE);
        EClass revisionSummaryContainerClass = schema.createEClass(this.storePackage, "RevisionSummaryContainer", new EClass[0]);
        schema.createEAttribute(revisionSummaryContainerClass, "name", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEReference(revisionSummaryContainerClass, "types", revisionSummaryTypeClass, Schema.Multiplicity.MANY).getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        EClass revisionSummaryClass = schema.createEClass(this.storePackage, "RevisionSummary", new EClass[0]);
        schema.createEReference(revisionSummaryClass, "list", revisionSummaryContainerClass, Schema.Multiplicity.MANY).getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        schema.createEReference(this.concreteRevisionClass, "summary", revisionSummaryClass, Schema.Multiplicity.SINGLE);
        EClass longActionClass = schema.createEClass(this.storePackage, "LongAction", new EClass[0]);
        schema.createEAttribute(longActionClass, "identification", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEReference(longActionClass, "user", this.user, Schema.Multiplicity.SINGLE);
        schema.createEAttribute(longActionClass, "start", this.ecorePackage.getEDate(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(longActionClass, "username", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(longActionClass, "name", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        EClass objectIDMPluginDescriptor = schema.createEClass(this.storePackage, "ObjectIDMPluginDescriptor", new EClass[0]);
        schema.createEAttribute(objectIDMPluginDescriptor, "className", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        EEnum compareTypeEnum = schema.createEEnum(this.storePackage, "CompareType");
        schema.createEEnumLiteral(compareTypeEnum, "ALL");
        schema.createEEnumLiteral(compareTypeEnum, "ADD");
        schema.createEEnumLiteral(compareTypeEnum, "MODIFY");
        schema.createEEnumLiteral(compareTypeEnum, "DELETE");
        EClass compareItemClass = schema.createEClass(this.storePackage, "CompareItem", new EClass[0]);
        schema.createEReference(compareItemClass, "dataObject", dataObjectClass, Schema.Multiplicity.SINGLE).getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        schema.createEClass(this.storePackage, "ObjectAdded", compareItemClass);
        schema.createEClass(this.storePackage, "ObjectRemoved", compareItemClass);
        EClass objectModified = schema.createEClass(this.storePackage, "ObjectModified", compareItemClass);
        schema.createEAttribute(objectModified, "fieldName", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(objectModified, "oldValue", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(objectModified, "newValue", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        EClass compareContainerClass = schema.createEClass(this.storePackage, "CompareContainer", new EClass[0]);
        schema.createEAttribute(compareContainerClass, "type", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEReference(compareContainerClass, "items", compareItemClass, Schema.Multiplicity.MANY).getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        EClass compareResultClass = schema.createEClass(this.storePackage, "CompareResult", new EClass[0]);
        schema.createEReference(compareResultClass, "items", compareContainerClass, Schema.Multiplicity.MANY).getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        EEnum actionStateEnum = schema.createEEnum(this.storePackage, "ActionState");
        schema.createEEnumLiteral(actionStateEnum, "UNKNOWN");
        schema.createEEnumLiteral(actionStateEnum, "STARTED");
        schema.createEEnumLiteral(actionStateEnum, "AS_ERROR");
        schema.createEEnumLiteral(actionStateEnum, "FINISHED");
        EClass longActionStateClass = schema.createEClass(this.storePackage, "LongActionState", new EClass[0]);
        schema.createEAttribute(longActionStateClass, "start", this.ecorePackage.getEDate(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(longActionStateClass, "end", this.ecorePackage.getEDate(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(longActionStateClass, "progress", this.ecorePackage.getEIntegerObject(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(longActionStateClass, "state", (EDataType)actionStateEnum, Schema.Multiplicity.SINGLE);
        schema.createEAttribute(longActionStateClass, "title", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(longActionStateClass, "stage", EcorePackage.eINSTANCE.getEInt(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(longActionStateClass, "errors", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.MANY);
        schema.createEAttribute(longActionStateClass, "warnings", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.MANY);
        schema.createEAttribute(longActionStateClass, "infos", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.MANY);
        schema.createEEnumLiteral(accessMethodEnum, "PROTOCOL_BUFFERS");
        EEnum serverState = schema.createEEnum(this.storePackage, "ServerState");
        schema.createEEnumLiteral(serverState, "UNDEFINED");
        schema.createEEnumLiteral(serverState, "NOT_SETUP");
        schema.createEEnumLiteral(serverState, "MIGRATION_REQUIRED");
        schema.createEEnumLiteral(serverState, "MIGRATION_IMPOSSIBLE");
        schema.createEEnumLiteral(serverState, "FATAL_ERROR");
        schema.createEEnumLiteral(serverState, "RUNNING");
        EClass serverInfoClass = schema.createEClass(this.storePackage, "ServerInfo", new EClass[0]);
        schema.createEAttribute(serverInfoClass, "serverState", (EDataType)serverState, Schema.Multiplicity.SINGLE);
        schema.createEAttribute(serverInfoClass, "errorMessage", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        EClass versionInfoClass = schema.createEClass(this.storePackage, "Version", new EClass[0]);
        schema.createEAttribute(versionInfoClass, "major", this.ecorePackage.getEIntegerObject(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(versionInfoClass, "minor", this.ecorePackage.getEIntegerObject(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(versionInfoClass, "revision", this.ecorePackage.getEIntegerObject(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(versionInfoClass, "fullString", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(versionInfoClass, "date", this.ecorePackage.getEDate(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(versionInfoClass, "downloadUrl", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(versionInfoClass, "supportUrl", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(versionInfoClass, "supportEmail", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEReference(this.concreteRevisionClass, "user", this.user, Schema.Multiplicity.SINGLE);
        schema.createEClass(this.storePackage, "RenderEnginePluginDescriptor", pluginDescriptor);
        EEnum extendedDataSchemaType = schema.createEEnum(this.storePackage, "ExtendedDataSchemaType");
        schema.createEEnumLiteral(extendedDataSchemaType, "XSD");
        schema.createEEnumLiteral(extendedDataSchemaType, "PDF");
        schema.createEEnumLiteral(extendedDataSchemaType, "TXT");
        EClass file = schema.createEClass("store", "File");
        schema.createEAttribute(file, "data", EcorePackage.eINSTANCE.getEByteArray(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(file, "filename", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(file, "mime", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        EClass extendedDataSchema = schema.createEClass(this.storePackage, "ExtendedDataSchema", new EClass[0]);
        schema.createEAttribute(extendedDataSchema, "name", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(extendedDataSchema, "url", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(extendedDataSchema, "namespace", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(extendedDataSchema, "description", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEReference(extendedDataSchema, "file", file, Schema.Multiplicity.SINGLE);
        schema.createEAttribute(extendedDataSchema, "size", EcorePackage.eINSTANCE.getELong(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(extendedDataSchema, "validate", EcorePackage.eINSTANCE.getEBoolean(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(extendedDataSchema, "type", (EDataType)extendedDataSchemaType, Schema.Multiplicity.SINGLE);
        EClass extendedDataClass = schema.createEClass(this.storePackage, "ExtendedData", new EClass[0]);
        schema.createEAttribute(extendedDataClass, "url", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEReference(extendedDataClass, "file", file, Schema.Multiplicity.SINGLE);
        schema.createEAttribute(extendedDataClass, "size", EcorePackage.eINSTANCE.getELong(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(extendedDataClass, "title", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(extendedDataClass, "added", EcorePackage.eINSTANCE.getEDate(), Schema.Multiplicity.SINGLE);
        EReference userToExtendedDataSchema = schema.createEReference(this.user, "schemas", extendedDataSchema, Schema.Multiplicity.MANY);
        EReference extendedDataSchemaToUser = schema.createEReference(extendedDataSchema, "users", this.user, Schema.Multiplicity.MANY);
        userToExtendedDataSchema.setEOpposite(extendedDataSchemaToUser);
        extendedDataSchemaToUser.setEOpposite(userToExtendedDataSchema);
        EReference extendedDataToUser = schema.createEReference(extendedDataClass, "user", this.user, Schema.Multiplicity.SINGLE);
        EReference userToExtendedData = schema.createEReference(this.user, "extendedData", extendedDataClass, Schema.Multiplicity.MANY);
        extendedDataToUser.setEOpposite(userToExtendedData);
        userToExtendedData.setEOpposite(extendedDataToUser);
        EReference extendedDataToExtendedDataSchema = schema.createEReference(extendedDataClass, "schema", extendedDataSchema, Schema.Multiplicity.SINGLE);
        EReference extendedDataSchemaToExtendedData = schema.createEReference(extendedDataSchema, "extendedData", extendedDataClass, Schema.Multiplicity.MANY);
        extendedDataToExtendedDataSchema.setEOpposite(extendedDataSchemaToExtendedData);
        extendedDataSchemaToExtendedData.setEOpposite(extendedDataToExtendedDataSchema);
        EReference revisionExtendedData = schema.createEReference(this.revisionClass, "extendedData", extendedDataClass, Schema.Multiplicity.MANY);
        EReference extendedDataRevision = schema.createEReference(extendedDataClass, "revision", this.revisionClass, Schema.Multiplicity.SINGLE);
        revisionExtendedData.setEOpposite(extendedDataRevision);
        extendedDataRevision.setEOpposite(revisionExtendedData);
        EReference projectExtendedData = schema.createEReference(this.project, "extendedData", extendedDataClass, Schema.Multiplicity.MANY);
        EReference extendedDataProject = schema.createEReference(extendedDataClass, "project", this.project, Schema.Multiplicity.SINGLE);
        projectExtendedData.setEOpposite(extendedDataProject);
        extendedDataProject.setEOpposite(projectExtendedData);
        schema.createEClass(this.storePackage, "QueryEnginePluginDescriptor", pluginDescriptor);
        EClass queryEnginePluginConfiguration = schema.createEClass(this.storePackage, "QueryEnginePluginConfiguration", pluginConfiguration);
        EReference queryEngineSettingsReference = schema.createEReference(queryEnginePluginConfiguration, "userSettings", this.userSettings, Schema.Multiplicity.SINGLE);
        EReference settingsQueryEnginesReference = schema.createEReference(this.userSettings, "queryEngines", queryEnginePluginConfiguration, Schema.Multiplicity.MANY);
        queryEngineSettingsReference.setEOpposite(settingsQueryEnginesReference);
        settingsQueryEnginesReference.setEOpposite(queryEngineSettingsReference);
        schema.createEClass(this.storePackage, "WebModulePluginDescriptor", pluginDescriptor);
        EClass webModulePluginConfiguration = schema.createEClass(this.storePackage, "WebModulePluginConfiguration", pluginConfiguration);
        EReference webModulePluginSettingsReference = schema.createEReference(webModulePluginConfiguration, "serverSettings", this.serverSettings, Schema.Multiplicity.SINGLE);
        EReference settingsWebReference = schema.createEReference(this.serverSettings, "webModules", webModulePluginConfiguration, Schema.Multiplicity.MANY);
        webModulePluginSettingsReference.setEOpposite(settingsWebReference);
        settingsWebReference.setEOpposite(webModulePluginSettingsReference);
        schema.createEClass(this.storePackage, "ModelMergerPluginDescriptor", pluginDescriptor);
        EClass modelMergerPluginConfiguration = schema.createEClass(this.storePackage, "ModelMergerPluginConfiguration", pluginConfiguration);
        EReference modelMergerSettingsReference = schema.createEReference(modelMergerPluginConfiguration, "userSettings", this.userSettings, Schema.Multiplicity.SINGLE);
        EReference settingsModelMergersReference = schema.createEReference(this.userSettings, "modelMergers", modelMergerPluginConfiguration, Schema.Multiplicity.MANY);
        modelMergerSettingsReference.setEOpposite(settingsModelMergersReference);
        settingsModelMergersReference.setEOpposite(modelMergerSettingsReference);
        schema.createEClass(this.storePackage, "ModelComparePluginDescriptor", pluginDescriptor);
        EClass modelComparePluginConfiguration = schema.createEClass(this.storePackage, "ModelComparePluginConfiguration", pluginConfiguration);
        EReference modelCompareSettingsReference = schema.createEReference(modelComparePluginConfiguration, "userSettings", this.userSettings, Schema.Multiplicity.SINGLE);
        EReference settingsModelComparesReference = schema.createEReference(this.userSettings, "modelCompares", modelComparePluginConfiguration, Schema.Multiplicity.MANY);
        modelCompareSettingsReference.setEOpposite(settingsModelComparesReference);
        settingsModelComparesReference.setEOpposite(modelCompareSettingsReference);
        schema.createEReference(this.userSettings, "defaultModelMerger", modelMergerPluginConfiguration, Schema.Multiplicity.SINGLE);
        schema.createEReference(this.userSettings, "defaultModelCompare", modelComparePluginConfiguration, Schema.Multiplicity.SINGLE);
        schema.createEReference(this.userSettings, "defaultQueryEngine", queryEnginePluginConfiguration, Schema.Multiplicity.SINGLE);
        schema.createEReference(this.userSettings, "defaultRenderEngine", renderEnginePluginConfiguration, Schema.Multiplicity.SINGLE);
        schema.createEReference(this.userSettings, "defaultSerializer", serializerPluginConfiguration, Schema.Multiplicity.SINGLE);
        schema.createEReference(this.userSettings, "defaultObjectIDM", objectIDMPluginConfiguration, Schema.Multiplicity.SINGLE);
        schema.createEReference(this.serverSettings, "webModule", webModulePluginConfiguration, Schema.Multiplicity.SINGLE);
        EEnum trigger = schema.createEEnum("store", "Trigger");
        schema.createEEnumLiteral(trigger, "NEW_REVISION");
        schema.createEEnumLiteral(trigger, "NEW_PROJECT");
        schema.createEEnumLiteral(trigger, "NEW_EXTENDED_DATA");
        EClass profileDescriptor = schema.createEClass(this.storePackage, "ProfileDescriptor", new EClass[0]);
        profileDescriptor.getEAnnotations().add((Object)this.createNoDatabaseAnnotation());
        schema.createEAttribute(profileDescriptor, "name", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(profileDescriptor, "description", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(profileDescriptor, "publicProfile", EcorePackage.eINSTANCE.getEBoolean(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(profileDescriptor, "identifier", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        EClass serviceDescriptor = schema.createEClass(this.storePackage, "ServiceDescriptor", new EClass[0]);
        serviceDescriptor.getEAnnotations().add((Object)this.createNoDatabaseAnnotation());
        schema.createEAttribute(serviceDescriptor, "name", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(serviceDescriptor, "url", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(serviceDescriptor, "token", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(serviceDescriptor, "identifier", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(serviceDescriptor, "notificationProtocol", (EDataType)schema.getEEnum("log", "AccessMethod"), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(serviceDescriptor, "description", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(serviceDescriptor, "trigger", (EDataType)trigger, Schema.Multiplicity.SINGLE);
        schema.createEAttribute(serviceDescriptor, "readRevision", EcorePackage.eINSTANCE.getEBoolean(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(serviceDescriptor, "readExtendedData", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(serviceDescriptor, "writeRevision", EcorePackage.eINSTANCE.getEBoolean(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(serviceDescriptor, "writeExtendedData", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(serviceDescriptor, "providerName", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        EClass service = schema.createEClass("store", "Service");
        schema.createEAttribute(service, "name", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(service, "serviceName", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(service, "serviceIdentifier", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(service, "providerName", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(service, "url", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(service, "token", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(service, "notificationProtocol", (EDataType)schema.getEEnum("log", "AccessMethod"), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(service, "description", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(service, "trigger", (EDataType)trigger, Schema.Multiplicity.SINGLE);
        schema.createEAttribute(service, "readRevision", EcorePackage.eINSTANCE.getEBoolean(), Schema.Multiplicity.SINGLE);
        schema.createEReference(service, "readExtendedData", extendedDataSchema, Schema.Multiplicity.SINGLE);
        schema.createEReference(service, "writeRevision", this.project, Schema.Multiplicity.SINGLE);
        schema.createEReference(service, "writeExtendedData", extendedDataSchema, Schema.Multiplicity.SINGLE);
        schema.createEAttribute(service, "profileIdentifier", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(service, "profileName", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(service, "profileDescription", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(service, "profilePublic", EcorePackage.eINSTANCE.getEBoolean(), Schema.Multiplicity.SINGLE);
        EReference serviceProject = schema.createEReference(service, "project", this.project, Schema.Multiplicity.SINGLE);
        EReference projectServices = schema.createEReference(this.project, "services", service, Schema.Multiplicity.MANY);
        serviceProject.setEOpposite(projectServices);
        projectServices.setEOpposite(serviceProject);
        EReference serviceUser = schema.createEReference(service, "user", this.user, Schema.Multiplicity.SINGLE);
        EReference userServices = schema.createEReference(this.user, "services", service, Schema.Multiplicity.MANY);
        serviceUser.setEOpposite(userServices);
        userServices.setEOpposite(serviceUser);
        schema.createEAttribute(this.serverSettings, "serviceRepositoryUrl", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        EClass tokenClass = schema.createEClass("store", "Token");
        schema.createEAttribute(tokenClass, "tokenString", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(tokenClass, "expires", EcorePackage.eINSTANCE.getELong(), Schema.Multiplicity.SINGLE);
        schema.createEClass(this.storePackage, "ServicePluginDescriptor", pluginDescriptor);
        EClass internalServicePluginConfiguration = schema.createEClass(this.storePackage, "InternalServicePluginConfiguration", pluginConfiguration);
        schema.createEAttribute(internalServicePluginConfiguration, "remoteAccessible", EcorePackage.eINSTANCE.getEBoolean(), Schema.Multiplicity.SINGLE);
        schema.createEReference(service, "internalService", internalServicePluginConfiguration, Schema.Multiplicity.SINGLE);
        EReference serviceSettingsReference = schema.createEReference(internalServicePluginConfiguration, "userSettings", this.userSettings, Schema.Multiplicity.SINGLE);
        EReference settingsServicesReference = schema.createEReference(this.userSettings, "services", internalServicePluginConfiguration, Schema.Multiplicity.MANY);
        serviceSettingsReference.setEOpposite(settingsServicesReference);
        settingsServicesReference.setEOpposite(serviceSettingsReference);
        EClass serviceInterface = schema.createEClass("store", "ServiceInterface");
        serviceInterface.getEAnnotations().add((Object)this.createNoDatabaseAnnotation());
        schema.createEAttribute(serviceInterface, "name", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(serviceInterface, "nameSpace", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(serviceInterface, "simpleName", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        EClass serviceMethod = schema.createEClass("store", "ServiceMethod");
        serviceMethod.getEAnnotations().add((Object)this.createNoDatabaseAnnotation());
        schema.createEAttribute(serviceMethod, "name", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(serviceMethod, "doc", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(serviceMethod, "returnDoc", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        EEnum serviceSimpleType = schema.createEEnum("store", "ServiceSimpleType");
        schema.createEEnumLiteral(serviceSimpleType, "ENUM");
        schema.createEEnumLiteral(serviceSimpleType, "STRING");
        schema.createEEnumLiteral(serviceSimpleType, "LONG");
        schema.createEEnumLiteral(serviceSimpleType, "INT");
        schema.createEEnumLiteral(serviceSimpleType, "BOOLEAN");
        schema.createEEnumLiteral(serviceSimpleType, "FLOAT");
        schema.createEEnumLiteral(serviceSimpleType, "DOUBLE");
        schema.createEEnumLiteral(serviceSimpleType, "DATE");
        schema.createEEnumLiteral(serviceSimpleType, "CLASS");
        schema.createEEnumLiteral(serviceSimpleType, "DATAHANDLER");
        schema.createEEnumLiteral(serviceSimpleType, "BYTEARRAY");
        schema.createEEnumLiteral(serviceSimpleType, "LIST");
        schema.createEEnumLiteral(serviceSimpleType, "SET");
        schema.createEEnumLiteral(serviceSimpleType, "VOID");
        schema.createEEnumLiteral(serviceSimpleType, "UNKNOWN");
        EClass serviceField = schema.createEClass("store", "ServiceField");
        serviceField.getEAnnotations().add((Object)this.createNoDatabaseAnnotation());
        EClass serviceType = schema.createEClass("store", "ServiceType");
        schema.createEAttribute(serviceField, "name", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEReference(serviceField, "type", serviceType, Schema.Multiplicity.SINGLE).getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        schema.createEReference(serviceField, "genericType", serviceType, Schema.Multiplicity.SINGLE).getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        schema.createEAttribute(serviceField, "doc", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(serviceType, "name", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(serviceType, "simpleName", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEReference(serviceType, "fields", serviceField, Schema.Multiplicity.MANY).getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        schema.createEAttribute(serviceType, "simpleType", (EDataType)serviceSimpleType, Schema.Multiplicity.SINGLE).getEAnnotations();
        EClass serviceParameter = schema.createEClass("store", "ServiceParameter");
        serviceParameter.getEAnnotations().add((Object)this.createNoDatabaseAnnotation());
        schema.createEAttribute(serviceParameter, "name", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(serviceParameter, "doc", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEReference(serviceParameter, "type", serviceType, Schema.Multiplicity.SINGLE).getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        schema.createEReference(serviceParameter, "genericType", serviceType, Schema.Multiplicity.SINGLE).getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        EClass extendedDataAddedToRevision = schema.createEClass(logPackage, "ExtendedDataAddedToRevision", logAction);
        schema.createEReference(extendedDataAddedToRevision, "revision", this.revisionClass, Schema.Multiplicity.SINGLE);
        schema.createEReference(extendedDataAddedToRevision, "extendedData", extendedDataClass, Schema.Multiplicity.SINGLE);
        EClass extendedDataAddedToProject = schema.createEClass(logPackage, "ExtendedDataAddedToProject", logAction);
        schema.createEReference(extendedDataAddedToProject, "project", this.project, Schema.Multiplicity.SINGLE);
        schema.createEReference(extendedDataAddedToProject, "extendedData", extendedDataClass, Schema.Multiplicity.SINGLE);
        EEnum primitiveEnum = schema.createEEnum("store", "PrimitiveEnum");
        schema.createEEnumLiteral(primitiveEnum, "LONG");
        schema.createEEnumLiteral(primitiveEnum, "DOUBLE");
        schema.createEEnumLiteral(primitiveEnum, "BOOLEAN");
        schema.createEEnumLiteral(primitiveEnum, "STRING");
        schema.createEEnumLiteral(primitiveEnum, "BYTE_ARRAY");
        EClass typeDefinition = schema.createEClass("store", "TypeDefinition");
        typeDefinition.getEAnnotations().add((Object)this.createNoDatabaseAnnotation());
        EClass objectDefinition = schema.createEClass("store", "ObjectDefinition", typeDefinition);
        objectDefinition.getEAnnotations().add((Object)this.createNoDatabaseAnnotation());
        EClass primitiveDefinition = schema.createEClass("store", "PrimitiveDefinition", typeDefinition);
        primitiveDefinition.getEAnnotations().add((Object)this.createNoDatabaseAnnotation());
        EClass arrayDefinition = schema.createEClass("store", "ArrayDefinition", typeDefinition);
        arrayDefinition.getEAnnotations().add((Object)this.createNoDatabaseAnnotation());
        EClass parameterDefinition = schema.createEClass("store", "ParameterDefinition");
        parameterDefinition.getEAnnotations().add((Object)this.createNoDatabaseAnnotation());
        schema.createEAttribute(parameterDefinition, "name", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(parameterDefinition, "required", EcorePackage.eINSTANCE.getEBoolean(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(parameterDefinition, "description", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEReference(parameterDefinition, "type", typeDefinition, Schema.Multiplicity.SINGLE).getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        schema.createEReference(objectDefinition, "parameters", parameterDefinition, Schema.Multiplicity.MANY).getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        schema.createEAttribute(primitiveDefinition, "type", (EDataType)primitiveEnum, Schema.Multiplicity.SINGLE);
        schema.createEReference(arrayDefinition, "type", typeDefinition, Schema.Multiplicity.SINGLE).getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        EClass type = schema.createEClass("store", "Type");
        EClass objectType = schema.createEClass("store", "ObjectType", type);
        EClass primitiveType = schema.createEClass("store", "PrimitiveType", type);
        EClass longType = schema.createEClass("store", "LongType", primitiveType);
        EClass byteArrayType = schema.createEClass("store", "ByteArrayType", primitiveType);
        EClass doubleType = schema.createEClass("store", "DoubleType", primitiveType);
        EClass stringType = schema.createEClass("store", "StringType", primitiveType);
        EClass booleanType = schema.createEClass("store", "BooleanType", primitiveType);
        EClass arrayType = schema.createEClass("store", "ArrayType", type);
        EClass parameter = schema.createEClass("store", "Parameter");
        schema.createEAttribute(objectType, "name", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEReference(objectType, "parameters", parameter, Schema.Multiplicity.MANY).getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        schema.createEAttribute(parameter, "name", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEReference(parameter, "value", type, Schema.Multiplicity.SINGLE).getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        schema.createEReference(parameterDefinition, "defaultValue", type, Schema.Multiplicity.SINGLE);
        schema.createEReference(arrayType, "values", type, Schema.Multiplicity.MANY).getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        schema.createEAttribute(longType, "value", EcorePackage.eINSTANCE.getELong(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(doubleType, "value", EcorePackage.eINSTANCE.getEDouble(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(byteArrayType, "value", EcorePackage.eINSTANCE.getEByteArray(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(stringType, "value", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(booleanType, "value", EcorePackage.eINSTANCE.getEBoolean(), Schema.Multiplicity.SINGLE);
        schema.createEReference(pluginConfiguration, "settings", objectType, Schema.Multiplicity.SINGLE);
        EEnum notificationResultEnum = schema.createEEnum("store", "NotifictionResultEnum");
        schema.createEEnumLiteral(notificationResultEnum, "NR_ERROR");
        schema.createEEnumLiteral(notificationResultEnum, "SUCCESS");
        schema.createEEnumLiteral(notificationResultEnum, "PROGRESS_UNKNOWN");
        schema.createEEnumLiteral(notificationResultEnum, "PROGRESS_PERCENTAGE");
        EClass immediateNotificationResult = schema.createEClass("store", "ImmediateNotificationResult");
        schema.createEAttribute(immediateNotificationResult, "result", (EDataType)notificationResultEnum, Schema.Multiplicity.SINGLE);
        schema.createEAttribute(immediateNotificationResult, "description", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.SINGLE);
        EClass remoteServiceCalled = schema.createEClass("log", "RemoteServiceCalled", logAction);
        schema.createEReference(remoteServiceCalled, "service", service, Schema.Multiplicity.SINGLE);
        schema.createEAttribute(remoteServiceCalled, "state", (EDataType)notificationResultEnum, Schema.Multiplicity.SINGLE);
        schema.createEAttribute(remoteServiceCalled, "percentage", EcorePackage.eINSTANCE.getEInt(), Schema.Multiplicity.SINGLE);
        schema.createEAttribute(remoteServiceCalled, "infos", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.MANY);
        schema.createEAttribute(remoteServiceCalled, "warnings", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.MANY);
        schema.createEAttribute(remoteServiceCalled, "errors", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.MANY);
        EReference projectLogs = schema.createEReference(this.project, "logs", projectRelated, Schema.Multiplicity.MANY);
        EReference revisionLogs = schema.createEReference(this.revisionClass, "logs", revisionRelated, Schema.Multiplicity.MANY);
        EReference userLogs = schema.createEReference(this.user, "logs", userRelated, Schema.Multiplicity.MANY);
        EReference checkoutLogs = schema.createEReference(this.checkoutClass, "logs", checkoutRelated, Schema.Multiplicity.MANY);
        projectRelatedProject.setEOpposite(projectLogs);
        projectLogs.setEOpposite(projectRelatedProject);
        revisionRelatedRevision.setEOpposite(revisionLogs);
        revisionLogs.setEOpposite(revisionRelatedRevision);
        userRelatedUser.setEOpposite(userLogs);
        userLogs.setEOpposite(userRelatedUser);
        checkoutRelatedCheckout.setEOpposite(checkoutLogs);
        checkoutLogs.setEOpposite(checkoutRelatedCheckout);
        EClass remoteServiceUpdate = schema.createEClass("store", "RemoteServiceUpdate");
        EClass percentageChange = schema.createEClass("store", "PercentageChange", remoteServiceUpdate);
        schema.createEAttribute(percentageChange, "percentage", EcorePackage.eINSTANCE.getEInt(), Schema.Multiplicity.SINGLE);
        EClass systemInfo = schema.createEClass("store", "SystemInfo");
        schema.createEAttribute(systemInfo, "cpucores", EcorePackage.eINSTANCE.getEInt());
        schema.createEAttribute(systemInfo, "datetime", EcorePackage.eINSTANCE.getEDate());
        schema.createEAttribute(systemInfo, "osname", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(systemInfo, "osversion", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(systemInfo, "userName", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(systemInfo, "userHome", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(systemInfo, "userDir", EcorePackage.eINSTANCE.getEString());
        EClass javaInfo = schema.createEClass("store", "JavaInfo");
        schema.createEAttribute(javaInfo, "heapTotal", EcorePackage.eINSTANCE.getELong());
        schema.createEAttribute(javaInfo, "heapUsed", EcorePackage.eINSTANCE.getELong());
        schema.createEAttribute(javaInfo, "heapFree", EcorePackage.eINSTANCE.getELong());
        schema.createEAttribute(javaInfo, "heapMax", EcorePackage.eINSTANCE.getELong());
        schema.createEAttribute(javaInfo, "threads", EcorePackage.eINSTANCE.getEInt());
        schema.createEAttribute(javaInfo, "javaHome", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(javaInfo, "javaVersion", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(javaInfo, "javaVendor", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(javaInfo, "javaVendorurl", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(javaInfo, "javavmVersion", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(javaInfo, "javavmVendor", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(javaInfo, "javavmName", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(javaInfo, "javaspecVersion", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(javaInfo, "javaspecVendor", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(javaInfo, "javaspecName", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(javaInfo, "javaClassVersion", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(javaInfo, "javaClasspath", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.MANY);
        schema.createEAttribute(javaInfo, "javaLibrarypath", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.MANY);
        schema.createEAttribute(javaInfo, "javaIoTmp", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(javaInfo, "javaExtdir", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(javaInfo, "javaFileSeparator", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(javaInfo, "javaPathSeparator", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(javaInfo, "javaLineSeparator", EcorePackage.eINSTANCE.getEString());
        EClass bimserverInfo = schema.createEClass("store", "BimServerInfo");
        schema.createEAttribute(bimserverInfo, "currentVersion", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(bimserverInfo, "currentDate", EcorePackage.eINSTANCE.getEDate());
        schema.createEAttribute(bimserverInfo, "schemaVersion", EcorePackage.eINSTANCE.getEInt());
        schema.createEAttribute(bimserverInfo, "latestDate", EcorePackage.eINSTANCE.getEDate());
        schema.createEAttribute(bimserverInfo, "latestVersion", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(bimserverInfo, "projects", EcorePackage.eINSTANCE.getEInt());
        schema.createEAttribute(bimserverInfo, "revisions", EcorePackage.eINSTANCE.getEInt());
        schema.createEAttribute(bimserverInfo, "users", EcorePackage.eINSTANCE.getEInt());
        schema.createEAttribute(bimserverInfo, "checkouts", EcorePackage.eINSTANCE.getEInt());
        schema.createEAttribute(bimserverInfo, "serverLogUrl", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(bimserverInfo, "started", EcorePackage.eINSTANCE.getEDate());
        EEnum progressTopicType = schema.createEEnum("store", "ProgressTopicType");
        schema.createEEnumLiteral(progressTopicType, "DOWNLOAD");
        schema.createEEnumLiteral(progressTopicType, "UPLOAD");
        schema.createEEnumLiteral(progressTopicType, "RUNNING_SERVICE");
        schema.createEEnumLiteral(progressTopicType, "BRANCH");
        schema.createEReference(this.revisionClass, "service", service, Schema.Multiplicity.SINGLE);
        EClass projectSmall = schema.createEClass("store", "ProjectSmall");
        schema.createEAttribute(projectSmall, "name", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(projectSmall, "parentId", EcorePackage.eINSTANCE.getELong());
        EClass ifcHeader = schema.createEClass("store", "IfcHeader");
        schema.createEAttribute(ifcHeader, "description", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.MANY).setUnique(false);
        schema.createEAttribute(ifcHeader, "implementationLevel", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(ifcHeader, "filename", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(ifcHeader, "timeStamp", EcorePackage.eINSTANCE.getEDate());
        schema.createEAttribute(ifcHeader, "author", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.MANY).setUnique(false);
        schema.createEAttribute(ifcHeader, "organization", EcorePackage.eINSTANCE.getEString(), Schema.Multiplicity.MANY).setUnique(false);
        schema.createEAttribute(ifcHeader, "preProcessorVersion", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(ifcHeader, "originatingSystem", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(ifcHeader, "ifcSchemaVersion", EcorePackage.eINSTANCE.getEString());
        schema.createEAttribute(ifcHeader, "authorization", EcorePackage.eINSTANCE.getEString());
        schema.createEReference(this.concreteRevisionClass, "ifcHeader", ifcHeader, Schema.Multiplicity.SINGLE);
    }

    private void createSIPrefixEnum() {
        this.siPrefixEnum = this.schema.createEEnum(this.storePackage, "SIPrefix");
        this.schema.createEEnumLiteral(this.siPrefixEnum, "meter", 0);
        this.schema.createEEnumLiteral(this.siPrefixEnum, "attometer", -18);
        this.schema.createEEnumLiteral(this.siPrefixEnum, "femtometer", -15);
        this.schema.createEEnumLiteral(this.siPrefixEnum, "picometer", -12);
        this.schema.createEEnumLiteral(this.siPrefixEnum, "nanometer", -9);
        this.schema.createEEnumLiteral(this.siPrefixEnum, "micrometer", -6);
        this.schema.createEEnumLiteral(this.siPrefixEnum, "millimeter", -3);
        this.schema.createEEnumLiteral(this.siPrefixEnum, "centimeter", -2);
        this.schema.createEEnumLiteral(this.siPrefixEnum, "decimeter", -1);
        this.schema.createEEnumLiteral(this.siPrefixEnum, "decameter", 1);
        this.schema.createEEnumLiteral(this.siPrefixEnum, "hectometer", 2);
        this.schema.createEEnumLiteral(this.siPrefixEnum, "kilometer", 3);
        this.schema.createEEnumLiteral(this.siPrefixEnum, "megameter", 6);
        this.schema.createEEnumLiteral(this.siPrefixEnum, "gigameter", 9);
        this.schema.createEEnumLiteral(this.siPrefixEnum, "terameter", 12);
        this.schema.createEEnumLiteral(this.siPrefixEnum, "petameter", 15);
        this.schema.createEEnumLiteral(this.siPrefixEnum, "exameter", 18);
    }

    private void createUserTypeEnum() {
        this.userTypeEnum = this.schema.createEEnum(this.storePackage, "UserType");
        this.schema.createEEnumLiteral(this.userTypeEnum, "SYSTEM");
        this.schema.createEEnumLiteral(this.userTypeEnum, "ADMIN");
        this.schema.createEEnumLiteral(this.userTypeEnum, "USER");
        this.schema.createEEnumLiteral(this.userTypeEnum, "READ_ONLY");
    }

    private void createObjectStateEnum() {
        this.objectStateEnum = this.schema.createEEnum(this.storePackage, "ObjectState");
        this.schema.createEEnumLiteral(this.objectStateEnum, "ACTIVE");
        this.schema.createEEnumLiteral(this.objectStateEnum, "DELETED");
    }

    private void createRevisionClass() {
        this.schema.createEAttribute(this.revisionClass, "id", this.ecorePackage.getEIntegerObject(), Schema.Multiplicity.SINGLE);
        this.revisionUser = this.schema.createEReference(this.revisionClass, "user", this.user, Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.revisionClass, "date", this.ecorePackage.getEDate(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.revisionClass, "comment", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.revisionClass, "size", this.ecorePackage.getELongObject(), Schema.Multiplicity.SINGLE);
        this.revisionConcreteRevisions = this.schema.createEReference(this.revisionClass, "concreteRevisions", this.concreteRevisionClass, Schema.Multiplicity.MANY);
        this.schema.createEReference(this.revisionClass, "lastConcreteRevision", this.concreteRevisionClass, Schema.Multiplicity.SINGLE);
        this.revisionCheckouts = this.schema.createEReference(this.revisionClass, "checkouts", this.checkoutClass, Schema.Multiplicity.MANY);
        this.revisionProject = this.schema.createEReference(this.revisionClass, "project", this.project, Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.revisionClass, "tag", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.revisionClass, "lastError", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.revisionClass, "bmi", this.ecorePackage.getEIntegerObject(), Schema.Multiplicity.SINGLE);
    }

    private void createConcreteRevisionClass() {
        this.schema.createEAttribute(this.concreteRevisionClass, "id", this.ecorePackage.getEIntegerObject(), Schema.Multiplicity.SINGLE);
        this.concreteRevisionProject = this.schema.createEReference(this.concreteRevisionClass, "project", this.project, Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.concreteRevisionClass, "checksum", this.ecorePackage.getEByteArray(), Schema.Multiplicity.SINGLE);
        this.concreteRevisionRevisions = this.schema.createEReference(this.concreteRevisionClass, "revisions", this.revisionClass, Schema.Multiplicity.MANY);
        this.schema.createEAttribute(this.concreteRevisionClass, "size", this.ecorePackage.getELongObject(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.concreteRevisionClass, "date", this.ecorePackage.getEDate(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.concreteRevisionClass, "lastError", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.concreteRevisionClass, "clear", this.ecorePackage.getEBoolean(), Schema.Multiplicity.SINGLE);
    }

    private void createGeoTagClass() {
        this.schema.createEAttribute(this.geoTagClass, "enabled", this.ecorePackage.getEBooleanObject(), Schema.Multiplicity.SINGLE);
        this.geoTagProjects = this.schema.createEReference(this.geoTagClass, "projects", this.project, Schema.Multiplicity.MANY);
        this.schema.createEAttribute(this.geoTagClass, "x", this.ecorePackage.getEDoubleObject(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.geoTagClass, "y", this.ecorePackage.getEDoubleObject(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.geoTagClass, "z", this.ecorePackage.getEDoubleObject(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.geoTagClass, "epsg", this.ecorePackage.getEIntegerObject(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.geoTagClass, "directionAngle", this.ecorePackage.getEDoubleObject(), Schema.Multiplicity.SINGLE);
    }

    private void createCheckoutClass() {
        this.schema.createEReference(this.checkoutClass, "user", this.user, Schema.Multiplicity.SINGLE);
        this.checkoutRevision = this.schema.createEReference(this.checkoutClass, "revision", this.revisionClass, Schema.Multiplicity.SINGLE);
        this.checkoutRevision.getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        this.checkoutProject = this.schema.createEReference(this.checkoutClass, "project", this.project, Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.checkoutClass, "date", this.ecorePackage.getEDate(), Schema.Multiplicity.SINGLE);
        this.schema.createEReference(this.checkoutClass, "checkin", this.revisionClass, Schema.Multiplicity.SINGLE).getEAnnotations().add((Object)this.createEmbedsReferenceAnnotation());
        this.schema.createEAttribute(this.checkoutClass, "active", this.ecorePackage.getEBooleanObject(), Schema.Multiplicity.SINGLE);
    }

    private void createUserClass() {
        this.schema.createEAttribute(this.user, "name", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.user, "passwordHash", this.ecorePackage.getEByteArray(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.user, "passwordSalt", this.ecorePackage.getEByteArray(), Schema.Multiplicity.SINGLE);
        this.userHasRightsOn = this.schema.createEReference(this.user, "hasRightsOn", this.project, Schema.Multiplicity.MANY);
        this.userRevisions = this.schema.createEReference(this.user, "revisions", this.revisionClass, Schema.Multiplicity.MANY);
        this.schema.createEAttribute(this.user, "state", (EDataType)this.objectStateEnum, Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.user, "createdOn", this.ecorePackage.getEDate(), Schema.Multiplicity.SINGLE);
        this.schema.createEReference(this.user, "createdBy", this.user, Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.user, "userType", (EDataType)this.userTypeEnum, Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.user, "username", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE).getEAnnotations().add((Object)this.createUniqueAnnotation());
        this.schema.createEAttribute(this.user, "lastSeen", this.ecorePackage.getEDate(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.user, "token", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.user, "validationToken", this.ecorePackage.getEByteArray(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.user, "validationTokenCreated", this.ecorePackage.getEDate(), Schema.Multiplicity.SINGLE);
        this.schema.createEReference(this.user, "userSettings", this.userSettings, Schema.Multiplicity.SINGLE);
    }

    private void createServerSettingsClass() {
        this.schema.createEAttribute(this.serverSettings, "sendConfirmationEmailAfterRegistration", this.ecorePackage.getEBoolean(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.serverSettings, "allowSelfRegistration", this.ecorePackage.getEBooleanObject(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.serverSettings, "allowUsersToCreateTopLevelProjects", this.ecorePackage.getEBoolean(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.serverSettings, "checkinMergingEnabled", this.ecorePackage.getEBooleanObject(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.serverSettings, "smtpServer", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.serverSettings, "emailSenderAddress", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.serverSettings, "emailSenderName", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.serverSettings, "siteAddress", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.serverSettings, "generateGeometryOnCheckin", this.ecorePackage.getEBoolean(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.serverSettings, "allowOnlyWhitelisted", this.ecorePackage.getEBoolean(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.serverSettings, "whitelistedDomains", this.ecorePackage.getEString(), Schema.Multiplicity.MANY);
        this.schema.createEAttribute(this.serverSettings, "hideUserListForNonAdmin", this.ecorePackage.getEBooleanObject(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.serverSettings, "protocolBuffersPort", this.ecorePackage.getEIntegerObject(), Schema.Multiplicity.SINGLE);
    }

    private void createProjectClass() {
        this.schema.createEAttribute(this.project, "id", this.ecorePackage.getEIntegerObject(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.project, "name", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE).getEAnnotations().add((Object)this.createIndexAnnotation());
        this.projectHasAuthorizedUsers = this.schema.createEReference(this.project, "hasAuthorizedUsers", this.user, Schema.Multiplicity.MANY);
        this.projectConcreteRevisions = this.schema.createEReference(this.project, "concreteRevisions", this.concreteRevisionClass, Schema.Multiplicity.MANY);
        this.projectRevisions = this.schema.createEReference(this.project, "revisions", this.revisionClass, Schema.Multiplicity.MANY);
        this.schema.createEReference(this.project, "lastConcreteRevision", this.concreteRevisionClass, Schema.Multiplicity.SINGLE);
        this.schema.createEReference(this.project, "lastRevision", this.revisionClass, Schema.Multiplicity.SINGLE);
        this.projectCheckouts = this.schema.createEReference(this.project, "checkouts", this.checkoutClass, Schema.Multiplicity.MANY);
        this.schema.createEAttribute(this.project, "state", (EDataType)this.objectStateEnum, Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.project, "createdDate", this.ecorePackage.getEDate(), Schema.Multiplicity.SINGLE);
        this.schema.createEReference(this.project, "createdBy", this.user, Schema.Multiplicity.SINGLE);
        this.projectGeoTag = this.schema.createEReference(this.project, "geoTag", this.geoTagClass, Schema.Multiplicity.SINGLE);
        this.projectSubProjects = this.schema.createEReference(this.project, "subProjects", this.project, Schema.Multiplicity.MANY);
        this.projectParentProject = this.schema.createEReference(this.project, "parent", this.project, Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.project, "description", this.ecorePackage.getEString(), Schema.Multiplicity.SINGLE);
        this.schema.createEAttribute(this.project, "exportLengthMeasurePrefix", (EDataType)this.siPrefixEnum, Schema.Multiplicity.SINGLE);
    }

    @Override
    public String getDescription() {
        return "Initial store model";
    }
}

