/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.queries;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.actions.AbstractDownloadDatabaseAction;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.QueryStackFrame;
import org.bimserver.database.queries.StackFrame;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Revision;
import org.bimserver.plugins.deserializers.DatabaseInterface;
import org.bimserver.shared.QueryContext;
import org.eclipse.emf.ecore.EClass;

public class ConcreteRevisionStackFrame
extends StackFrame {
    private QueryObjectProvider queryObjectProvider;
    private PackageMetaData packageMetaData;
    private QueryContext reusable;

    public ConcreteRevisionStackFrame(QueryObjectProvider queryObjectProvider, ConcreteRevision concreteRevision) {
        this.queryObjectProvider = queryObjectProvider;
        int highestStopId = AbstractDownloadDatabaseAction.findHighestStopRid(concreteRevision.getProject(), concreteRevision);
        this.packageMetaData = queryObjectProvider.getMetaDataManager().getPackageMetaData(concreteRevision.getProject().getSchema());
        Revision revision = (Revision)concreteRevision.getRevisions().get(0);
        this.reusable = new QueryContext((DatabaseInterface)queryObjectProvider.getDatabaseSession(), this.packageMetaData, concreteRevision.getProject().getId().intValue(), concreteRevision.getId().intValue(), revision.getOid(), highestStopId);
        this.updateOidCounters(this.reusable, concreteRevision, queryObjectProvider.getDatabaseSession());
    }

    private void updateOidCounters(QueryContext reusable, ConcreteRevision subRevision, DatabaseSession databaseSession) {
        if (subRevision.getOidCounters() != null) {
            HashMap<EClass, Long> oidCounters = new HashMap<EClass, Long>();
            ByteBuffer buffer = ByteBuffer.wrap(subRevision.getOidCounters());
            for (int i = 0; i < buffer.capacity() / 10; ++i) {
                short cid = buffer.getShort();
                long oid = buffer.getLong();
                EClass eClass = databaseSession.getEClass(cid);
                oidCounters.put(eClass, oid);
            }
            reusable.setOidCounters(oidCounters);
        }
    }

    @Override
    public boolean process() throws BimserverDatabaseException, JsonParseException, JsonMappingException, IOException {
        this.queryObjectProvider.push(new QueryStackFrame(this.queryObjectProvider, this.reusable));
        return true;
    }
}

