/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.queries;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Date;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.Record;
import org.bimserver.database.SearchingRecordIterator;
import org.bimserver.database.queries.ObjectProvidingStackFrame;
import org.bimserver.database.queries.QueryIncludeStackFrame;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.StackFrame;
import org.bimserver.database.queries.om.CanInclude;
import org.bimserver.database.queries.om.Include;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.HashMapWrappedVirtualObject;
import org.bimserver.shared.QueryContext;
import org.bimserver.shared.QueryException;
import org.bimserver.utils.BinUtils;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EEnumImpl;

public abstract class DatabaseReadingStackFrame
extends StackFrame
implements ObjectProvidingStackFrame {
    private QueryContext reusable;
    private QueryObjectProvider queryObjectProvider;
    protected HashMapVirtualObject currentObject;
    private QueryPart queryPart;

    public DatabaseReadingStackFrame(QueryContext reusable, QueryObjectProvider queryObjectProvider, QueryPart queryPart) {
        this.reusable = reusable;
        this.queryObjectProvider = queryObjectProvider;
        this.queryPart = queryPart;
    }

    public QueryContext getReusable() {
        return this.reusable;
    }

    @Override
    public HashMapVirtualObject getCurrentObject() {
        return this.currentObject;
    }

    public QueryObjectProvider getQueryObjectProvider() {
        return this.queryObjectProvider;
    }

    public PackageMetaData getPackageMetaData() {
        return this.reusable.getPackageMetaData();
    }

    public QueryPart getQueryPart() {
        return this.queryPart;
    }

    protected void processPossibleIncludes(EClass previousType, CanInclude canInclude) throws QueryException, BimserverDatabaseException {
        if (this.currentObject != null) {
            if (canInclude.hasIncludes()) {
                for (Include include : canInclude.getIncludes()) {
                    this.processPossibleInclude(canInclude, include);
                }
            } else if (canInclude.isIncludeAllFields()) {
                for (EReference eReference : this.currentObject.eClass().getEAllReferences()) {
                    Include include = new Include(this.reusable.getPackageMetaData());
                    include.addType(this.currentObject.eClass(), false);
                    include.addField(eReference.getName());
                    this.processPossibleInclude(canInclude, include);
                }
            }
            if (canInclude instanceof Include) {
                this.processPossibleInclude(null, (Include)canInclude);
            }
        }
    }

    protected void processPossibleInclude(CanInclude previousInclude, Include include) throws QueryException, BimserverDatabaseException {
        if (include.hasTypes()) {
            for (EClass filterClass : include.getTypes()) {
                if (filterClass.isSuperTypeOf(this.currentObject.eClass())) continue;
                return;
            }
        }
        if (include.hasFields()) {
            for (EStructuralFeature eStructuralFeature : include.getFields()) {
                this.currentObject.addUseForSerialization(eStructuralFeature);
            }
        }
        this.getQueryObjectProvider().push(new QueryIncludeStackFrame(this.getQueryObjectProvider(), this.getReusable(), previousInclude, include, this.currentObject, this.queryPart));
    }

    public DatabaseSession.GetResult getMap(EClass originalQueryClass, EClass eClass, ByteBuffer buffer, int keyPid, long keyOid, int keyRid) throws BimserverDatabaseException {
        if (keyPid == this.getReusable().getPid()) {
            if (keyRid <= this.getReusable().getRid() && keyRid >= this.getReusable().getStopRid()) {
                if (!this.getQueryObjectProvider().hasRead(keyOid)) {
                    if (buffer.capacity() == 1 && buffer.get(0) == -1) {
                        buffer.position(buffer.position() + 1);
                        return DatabaseSession.GetResult.CONTINUE_WITH_NEXT_OID;
                    }
                    this.currentObject = this.convertByteArrayToObject(eClass, keyOid, buffer, keyRid);
                }
                return DatabaseSession.GetResult.CONTINUE_WITH_NEXT_OID;
            }
            return DatabaseSession.GetResult.CONTINUE_WITH_NEXT_RECORD;
        }
        return DatabaseSession.GetResult.STOP;
    }

    protected HashMapVirtualObject convertByteArrayToObject(EClass eClass, long oid, ByteBuffer buffer, int rid) throws BimserverDatabaseException {
        try {
            HashMapVirtualObject idEObject = new HashMapVirtualObject(this.reusable, eClass);
            idEObject.setOid(oid);
            int unsettedLength = this.getPackageMetaData().getUnsettedLength(eClass);
            byte[] unsetted = new byte[unsettedLength];
            buffer.get(unsetted);
            int fieldCounter = 0;
            for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
                try {
                    boolean isUnsetted;
                    if (!this.getPackageMetaData().useForDatabaseStorage(eClass, feature)) continue;
                    boolean bl = isUnsetted = (unsetted[fieldCounter / 8] & 1 << fieldCounter % 8) != 0;
                    if (isUnsetted) {
                        if (feature.isUnsettable()) {
                            idEObject.eUnset(feature);
                        } else if (!feature.isMany() && feature.getDefaultValue() != null) {
                            idEObject.setAttribute(feature, feature.getDefaultValue());
                        }
                    } else {
                        Object newValue = null;
                        if (feature.isMany()) {
                            newValue = this.readList(idEObject, buffer, feature);
                        } else {
                            if (feature.getEType() instanceof EEnum) {
                                int enumOrdinal = buffer.getInt();
                                if (enumOrdinal == -1) {
                                    newValue = null;
                                } else {
                                    EClassifier eType = feature.getEType();
                                    EEnumLiteral enumLiteral = ((EEnumImpl)eType).getEEnumLiteral(enumOrdinal);
                                    if (enumLiteral != null) {
                                        newValue = enumLiteral.getInstance();
                                    }
                                }
                            } else if (feature.getEType() instanceof EClass) {
                                short cid = buffer.getShort();
                                if (cid != -1) {
                                    EClass referenceClass;
                                    if (cid < 0) {
                                        referenceClass = this.queryObjectProvider.getDatabaseSession().getEClass(-cid);
                                        newValue = feature.getEAnnotation("dbembed") != null ? this.readEmbeddedValue(feature, buffer, referenceClass) : this.readWrappedValue(feature, buffer, referenceClass);
                                    } else if (cid > 0) {
                                        referenceClass = this.queryObjectProvider.getDatabaseSession().getEClass(cid);
                                        if (referenceClass == null) {
                                            throw new BimserverDatabaseException("No eClass found for cid " + cid);
                                        }
                                        newValue = this.readReference(buffer, feature, referenceClass);
                                        if ((Long)newValue != -1L && (this.queryObjectProvider.hasReadOrIsGoingToRead((Long)newValue) || this.queryObjectProvider.hasReadOrIsGoingToRead(referenceClass))) {
                                            idEObject.addUseForSerialization(feature);
                                        }
                                    }
                                }
                            } else if (feature.getEType() instanceof EDataType) {
                                newValue = this.readPrimitiveValue(feature.getEType(), buffer);
                            }
                            if (newValue != null) {
                                idEObject.setAttribute(feature, newValue);
                            }
                        }
                    }
                    ++fieldCounter;
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new BimserverDatabaseException("Reading " + eClass.getName() + "." + feature.getName(), (Throwable)e);
                }
                catch (BufferUnderflowException e) {
                    throw new BimserverDatabaseException("Reading " + eClass.getName() + "." + feature.getName(), (Throwable)e);
                }
                catch (BufferOverflowException e) {
                    throw new BimserverDatabaseException("Reading " + eClass.getName() + "." + feature.getName(), (Throwable)e);
                }
            }
            return idEObject;
        }
        catch (BufferUnderflowException e) {
            throw new BimserverDatabaseException("Reading " + eClass.getName(), (Throwable)e);
        }
        catch (BufferOverflowException e) {
            throw new BimserverDatabaseException("Reading " + eClass.getName(), (Throwable)e);
        }
    }

    private long readReference(ByteBuffer buffer, EStructuralFeature feature, EClass eClass) throws BimserverDatabaseException {
        if (buffer.capacity() == 1 && buffer.get(0) == -1) {
            buffer.position(buffer.position() + 1);
            return -1L;
        }
        long oid = buffer.getLong();
        return oid;
    }

    private HashMapWrappedVirtualObject readWrappedValue(EStructuralFeature feature, ByteBuffer buffer, EClass eClass) throws BimserverDatabaseException {
        EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature("wrappedValue");
        Object primitiveValue = this.readPrimitiveValue(eStructuralFeature.getEType(), buffer);
        HashMapWrappedVirtualObject eObject = new HashMapWrappedVirtualObject(this.reusable, eClass);
        eObject.setAttribute(eStructuralFeature, primitiveValue);
        if (eStructuralFeature.getEType() == EcorePackage.eINSTANCE.getEDouble() || eStructuralFeature.getEType() == EcorePackage.eINSTANCE.getEDoubleObject()) {
            EStructuralFeature strFeature = eClass.getEStructuralFeature("wrappedValueAsString");
            Object stringVal = this.readPrimitiveValue((EClassifier)EcorePackage.eINSTANCE.getEString(), buffer);
            eObject.setAttribute(strFeature, stringVal);
        }
        return eObject;
    }

    private HashMapWrappedVirtualObject readEmbeddedValue(EStructuralFeature feature, ByteBuffer buffer, EClass eClass) throws BimserverDatabaseException {
        HashMapWrappedVirtualObject eObject = new HashMapWrappedVirtualObject(this.reusable, eClass);
        for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
            if (eStructuralFeature.isMany()) continue;
            Object primitiveValue = this.readPrimitiveValue(eStructuralFeature.getEType(), buffer);
            eObject.setAttribute(eStructuralFeature, primitiveValue);
        }
        return eObject;
    }

    public Object readPrimitiveValue(EClassifier classifier, ByteBuffer buffer) {
        if (classifier == EcorePackage.eINSTANCE.getEString()) {
            int length = buffer.getInt();
            if (length != -1) {
                return BinUtils.readString((ByteBuffer)buffer, (int)length);
            }
            return null;
        }
        if (classifier == EcorePackage.eINSTANCE.getEInt() || classifier == EcorePackage.eINSTANCE.getEIntegerObject()) {
            return buffer.getInt();
        }
        if (classifier == EcorePackage.eINSTANCE.getELong() || classifier == EcorePackage.eINSTANCE.getELongObject()) {
            return buffer.getLong();
        }
        if (classifier == EcorePackage.eINSTANCE.getEFloat() || classifier == EcorePackage.eINSTANCE.getEFloatObject()) {
            return Float.valueOf(buffer.getFloat());
        }
        if (classifier == EcorePackage.eINSTANCE.getEDouble() || classifier == EcorePackage.eINSTANCE.getEDoubleObject()) {
            return buffer.getDouble();
        }
        if (classifier == EcorePackage.eINSTANCE.getEBoolean() || classifier == EcorePackage.eINSTANCE.getEBooleanObject()) {
            return buffer.get() == 1;
        }
        if (classifier == EcorePackage.eINSTANCE.getEDate()) {
            long val = buffer.getLong();
            if (val == -1L) {
                return null;
            }
            return new Date(val);
        }
        if (classifier == EcorePackage.eINSTANCE.getEByteArray()) {
            int size = buffer.getInt();
            byte[] result = new byte[size];
            buffer.get(result);
            return result;
        }
        if (classifier.getName().equals("Tristate")) {
            int ordinal = buffer.getInt();
            EEnum tristateEnum = this.getPackageMetaData().getEEnum("Tristate");
            return tristateEnum.getEEnumLiteral(ordinal).getInstance();
        }
        if (classifier instanceof EEnum) {
            int ordinal = buffer.getInt();
            EEnum eEnum = (EEnum)classifier;
            return eEnum.getEEnumLiteral(ordinal).getInstance();
        }
        throw new RuntimeException("Unsupported type " + classifier.getName());
    }

    private Object readList(HashMapVirtualObject idEObject, ByteBuffer buffer, EStructuralFeature feature) throws BimserverDatabaseException {
        block9: {
            block10: {
                if (feature.getEType() instanceof EEnum) break block9;
                if (!(feature.getEType() instanceof EClass)) break block10;
                if (buffer.capacity() == 1 && buffer.get(0) == -1) {
                    buffer.position(buffer.position() + 1);
                } else {
                    int listSize = buffer.getInt();
                    for (int i = 0; i < listSize; ++i) {
                        EClass referenceClass;
                        if (feature.getEAnnotation("twodimensionalarray") != null) {
                            HashMapVirtualObject newObject = new HashMapVirtualObject(this.reusable, (EClass)feature.getEType());
                            Object result = this.readList(newObject, buffer, newObject.eClass().getEStructuralFeature("List"));
                            if (result != null) {
                                newObject.setAttribute(newObject.eClass().getEStructuralFeature("List"), result);
                            }
                            idEObject.setListItem(feature, i, (Object)newObject);
                            continue;
                        }
                        short cid = buffer.getShort();
                        if (cid == -1) continue;
                        if (cid < 0) {
                            referenceClass = this.queryObjectProvider.getDatabaseSession().getEClass(-cid);
                            if (referenceClass == null) {
                                throw new BimserverDatabaseException("No class found for cid " + -cid);
                            }
                            idEObject.setListItem(feature, i, (Object)this.readWrappedValue(feature, buffer, referenceClass));
                            continue;
                        }
                        if (cid <= 0) continue;
                        referenceClass = this.queryObjectProvider.getDatabaseSession().getEClass(cid);
                        if (referenceClass == null) {
                            throw new BimserverDatabaseException("Cannot find class with cid " + cid);
                        }
                        long rf = this.readReference(buffer, feature, referenceClass);
                        idEObject.setListItemReference(feature, i, referenceClass, Long.valueOf(rf), -1);
                        if (rf == -1L || !this.queryObjectProvider.hasReadOrIsGoingToRead(rf) && !this.queryObjectProvider.hasReadOrIsGoingToRead(referenceClass)) continue;
                        idEObject.addUseForSerialization(feature, i);
                    }
                }
                break block9;
            }
            if (!(feature.getEType() instanceof EDataType)) break block9;
            int listSize = buffer.getInt();
            for (int i = 0; i < listSize; ++i) {
                Object reference = this.readPrimitiveValue(feature.getEType(), buffer);
                if (reference == null) continue;
                idEObject.setListItem(feature, i, reference);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMapVirtualObject getByOid(long oid) throws BimserverDatabaseException {
        EClass eClass = this.getQueryObjectProvider().getDatabaseSession().getEClassForOid(oid);
        ByteBuffer mustStartWith = ByteBuffer.wrap(new byte[12]);
        mustStartWith.putInt(this.reusable.getPid());
        mustStartWith.putLong(oid);
        ByteBuffer startSearchWith = ByteBuffer.wrap(new byte[16]);
        startSearchWith.putInt(this.reusable.getPid());
        startSearchWith.putLong(oid);
        startSearchWith.putInt(-this.reusable.getRid());
        try (SearchingRecordIterator recordIterator = this.getQueryObjectProvider().getDatabaseSession().getKeyValueStore().getRecordIterator(eClass.getEPackage().getName() + "_" + eClass.getName(), mustStartWith.array(), startSearchWith.array(), this.getQueryObjectProvider().getDatabaseSession());){
            Record record = recordIterator.next();
            if (record == null) {
                HashMapVirtualObject hashMapVirtualObject = null;
                return hashMapVirtualObject;
            }
            this.getQueryObjectProvider().incReads();
            ByteBuffer keyBuffer = ByteBuffer.wrap(record.getKey());
            ByteBuffer valueBuffer = ByteBuffer.wrap(record.getValue());
            keyBuffer.getInt();
            long keyOid = keyBuffer.getLong();
            int keyRid = -keyBuffer.getInt();
            if (keyRid <= this.reusable.getRid()) {
                if (valueBuffer.capacity() == 1 && valueBuffer.get(0) == -1) {
                    valueBuffer.position(valueBuffer.position() + 1);
                    HashMapVirtualObject hashMapVirtualObject = null;
                    return hashMapVirtualObject;
                }
                HashMapVirtualObject hashMapVirtualObject = this.convertByteArrayToObject(eClass, keyOid, valueBuffer, keyRid);
                return hashMapVirtualObject;
            }
            HashMapVirtualObject hashMapVirtualObject = null;
            return hashMapVirtualObject;
        }
    }
}

