/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database.queries;

import java.nio.ByteBuffer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.Record;
import org.bimserver.database.SearchingRecordIterator;
import org.bimserver.database.queries.DatabaseReadingStackFrame;
import org.bimserver.database.queries.ObjectProvidingStackFrame;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.om.CanInclude;
import org.bimserver.database.queries.om.Include;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.shared.QueryContext;
import org.bimserver.shared.QueryException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class FollowReferenceStackFrame
extends DatabaseReadingStackFrame
implements ObjectProvidingStackFrame {
    private long oid;
    private boolean hasRun = false;
    private Include include;
    private EReference fromReference;

    public FollowReferenceStackFrame(QueryObjectProvider queryObjectProvider, Long oid, QueryContext reusable, QueryPart queryPart, EReference fromReference, Include include) {
        super(reusable, queryObjectProvider, queryPart);
        this.oid = oid;
        this.fromReference = fromReference;
        this.include = include;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process() throws BimserverDatabaseException, QueryException {
        block12: {
            if (this.getQueryObjectProvider().hasRead(this.oid)) {
                this.processPossibleIncludes(null, (CanInclude)this.include);
                return true;
            }
            if (this.hasRun) {
                return true;
            }
            this.hasRun = true;
            if (this.oid == -1L) {
                throw new BimserverDatabaseException("Cannot get object for oid " + this.oid);
            }
            EClass eClass = this.getQueryObjectProvider().getDatabaseSession().getEClassForOid(this.oid);
            ByteBuffer mustStartWith = ByteBuffer.wrap(new byte[12]);
            mustStartWith.putInt(this.getReusable().getPid());
            mustStartWith.putLong(this.oid);
            ByteBuffer startSearchWith = ByteBuffer.wrap(new byte[16]);
            startSearchWith.putInt(this.getReusable().getPid());
            startSearchWith.putLong(this.oid);
            startSearchWith.putInt(-this.getReusable().getRid());
            try (SearchingRecordIterator recordIterator = this.getQueryObjectProvider().getDatabaseSession().getKeyValueStore().getRecordIterator(eClass.getEPackage().getName() + "_" + eClass.getName(), mustStartWith.array(), startSearchWith.array(), this.getQueryObjectProvider().getDatabaseSession());){
                Record record = recordIterator.next();
                if (record == null) {
                    boolean bl = true;
                    return bl;
                }
                this.getQueryObjectProvider().incReads();
                ByteBuffer keyBuffer = ByteBuffer.wrap(record.getKey());
                ByteBuffer valueBuffer = ByteBuffer.wrap(record.getValue());
                keyBuffer.getInt();
                long keyOid = keyBuffer.getLong();
                int keyRid = -keyBuffer.getInt();
                if (keyRid <= this.getReusable().getRid()) {
                    EReference opposite;
                    if (valueBuffer.capacity() == 1 && valueBuffer.get(0) == -1) {
                        valueBuffer.position(valueBuffer.position() + 1);
                        boolean bl = true;
                        return bl;
                    }
                    this.currentObject = this.convertByteArrayToObject(eClass, keyOid, valueBuffer, keyRid);
                    if (this.currentObject != null && (opposite = this.getPackageMetaData().getInverseOrOpposite(this.currentObject.eClass(), (EStructuralFeature)this.fromReference)) != null) {
                        this.currentObject.addUseForSerialization((EStructuralFeature)opposite);
                    }
                    this.processPossibleIncludes(null, (CanInclude)this.include);
                    break block12;
                }
                boolean bl = true;
                return bl;
            }
        }
        return true;
    }
}

